/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.slave;

import com.geoway.vtile.cluster.bean.DistributedTaskBean;
import com.geoway.vtile.cluster.bean.TaskStateBean;
import com.geoway.vtile.cluster.sched.ClusterTaskScheduler;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.data_source.DataScourceShell;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.cellv4.MapTileBuilderUnit;
import com.geoway.vtile.transform.cellv4.TileOptimizer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VTileHandler {
    private static Logger logger = LoggerFactory.getLogger(VTileHandler.class);
    private DistributedTaskBean currentTaskBean;
    private Client client;
    private IVectorService mapService;
    private ExecutorService cutThreadPool = null;
    private MapTileBuilderUnit cutterCell;
    private MongoTileSaver tileSaver;
    private IDocumentEncoder<Object[]> encoder;

    public VTileHandler(DistributedTaskBean currentTaskBean, Client client, IVectorService mapService) {
        this.currentTaskBean = currentTaskBean;
        this.client = client;
        this.mapService = mapService;
        this.cutThreadPool = ClusterTaskScheduler.getCutThreadPool();
    }

    public void init() {
        IStorageInfo storageInfo = this.mapService.getStorageInfo();
        if (null == storageInfo) {
            throw new RuntimeException("\u672a\u627e\u5230\u74e6\u7247\u5b58\u50a8\u6e90\u4fe1\u606f\uff01");
        }
        String tileCollectionName = storageInfo.getStorageName();
        String dsrcId = storageInfo.getDataSource().getId();
        DataScourceShell ds = (DataScourceShell)this.client.getDataSourcesManager().get(dsrcId);
        MongodbDataSource tileMogoDS = (MongodbDataSource)ds.getBean();
        this.tileSaver = new MongoTileSaver(tileMogoDS.getUri(), tileCollectionName);
        this.tileSaver.setEnableSharding(true);
        logger.info("VTileHandler \u5f00\u59cb\u521d\u59cb\u5316Saver");
        this.tileSaver.init();
        this.encoder = new TileDataDocumentEncoder();
        TileOptimizer tileOptimizer = new TileOptimizer(tileMogoDS.factory().getDao(tileCollectionName));
        TaskStateBean state = this.currentTaskBean.getTaskState();
        int startLevel = state.getStageLevel1();
        int endLevel = state.getStageLevel2();
        this.cutterCell = new MapTileBuilderUnit(this.mapService, this.cutThreadPool);
        this.cutterCell.setOptimizer(tileOptimizer);
        this.cutterCell.setMainLevel(Integer.valueOf(startLevel));
        this.cutterCell.setDown(endLevel - startLevel);
        this.cutterCell.init();
        int nThreads = TileDispatchTaskManager.getPoolThreadCount();
        logger.info("\u5207\u7247\u7ebf\u7a0b\u6c60\u5927\u5c0f\uff1a" + nThreads);
    }

    public void processGrid(GridExtent extent) {
        try {
            this.cutVTile(extent);
        }
        catch (Exception ex) {
            String msg = "\u7f51\u683c\u5904\u7406\u5931\u8d25\uff1a" + extent.getCodeXYL() + "\uff0c " + ex.getMessage();
            logger.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    private void cutVTile(GridExtent extent) throws Exception {
        TileCutOptions opt = new TileCutOptions();
        List data = this.cutterCell.cut(extent, opt);
        this.saveVTile(extent, data);
    }

    private void saveVTile(GridExtent extent, List<Object[]> tilesData) {
        String mainGrid = extent.getCodeXYL();
        if (null == tilesData || tilesData.isEmpty()) {
            logger.info("\u7a7a\u74e6\u7247\uff1a" + mainGrid);
            return;
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info(Log4jUtil.MARKER_DIAG, "\u5199\u5165\u74e6\u7247: {} \u53ca\u4e0b\u7ea7\u5b50\u74e6\u7247\u5171 {} \u5f20", (Object)mainGrid, (Object)tilesData.size());
        }
        this.tileSaver.save(tilesData, this.encoder);
    }
}

