/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.task.update;

import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.model.vector_service.utfgrid.IUtfgridInfo;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.tiledispatch.consumer.ITileConsumer;
import com.geoway.vtile.tiledispatch.consumer.VectorCutMongoConsumer;
import com.geoway.vtile.tiledispatch.consumer.handler.update.UtfGridUpdateHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.tiledispatch.consumer.scroll.WktArrayScroll;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.task.stage.TileConsumeStage;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractUpdateTask;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.UtfGridCell;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class UtfgridTileUpdateTask
extends AbstractUpdateTask {
    IVectorService vectorService;
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;
    Integer beginLevel;
    Integer endLevel;
    ExecutorService cutExecutor;
    boolean useServiceStorage = true;
    List<String> updateRegions;
    long timestamp;

    public UtfgridTileUpdateTask(String name, IVectorService vectorService, List<String> updateRegions, Long timestamp) {
        super(name);
        this.vectorService = vectorService;
        IUtfgridInfo utfgridInfo = this.vectorService.getUtfgridInfo();
        if (utfgridInfo == null) {
            throw new RuntimeException("\u672a\u63d0\u53d6\u7684\u670d\u52a1\u65e0\u6cd5\u66f4\u65b0");
        }
        IStorageInfo storageInfo = utfgridInfo.getStorageInfo();
        if (storageInfo == null) {
            throw new RuntimeException("\u672a\u63d0\u53d6\u7684\u670d\u52a1\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mongodbDataSource = (MongodbDataSource)storageInfo.getDataSource().getBean();
        this.beginLevel = storageInfo.getStartLevel();
        this.endLevel = storageInfo.getEndLevel();
        this.updateRegions = updateRegions;
        this.timestamp = timestamp == null ? new Date().getTime() : timestamp.longValue();
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver(this.getStorageName());
        int taskNum = Runtime.getRuntime().availableProcessors();
        if (this.executor == null) {
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        this.cutExecutor = new DoubleQueueExecutor(taskNum * 2);
        this.grid = this.vectorService.getGridTree();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.buildStages();
    }

    private String getStorageName() {
        return (String)this.vectorService.getId() + "_utfgrid";
    }

    private void buildStages() {
        this.stages = new ArrayList();
        UtfGridCell cell = new UtfGridCell((String)this.vectorService.getId(), this.vectorService.getUtfgridInfo(), this.vectorService.getClient().getMapServerAccess(), true);
        cell.setTimestamp(Long.valueOf(this.timestamp));
        cell.setRemoveOldTile(this.removeOldTile);
        ITileScroll scroll = this.getTileScroll(this.endLevel + 1);
        ITileConsumer tileConsumer = this.createConsumer(cell, scroll);
        String consumeStageName = "\u751f\u4ea7\u7b2c" + (this.endLevel + 1) + "\u7ea7\u522butfgrid\u74e6\u7247";
        TileConsumeStage stage = new TileConsumeStage(consumeStageName, tileConsumer);
        stage.setLogger(this.cutLogger);
        this.stages.add(stage);
        cell = new UtfGridCell((String)this.vectorService.getId(), this.vectorService.getUtfgridInfo(), this.vectorService.getClient().getMapServerAccess(), false);
        cell.setTimestamp(Long.valueOf(this.timestamp));
        cell.setRemoveOldTile(this.removeOldTile);
        for (int level = this.endLevel.intValue(); level >= this.beginLevel; --level) {
            scroll = this.getTileScroll(level);
            tileConsumer = this.createConsumer(cell, scroll);
            consumeStageName = "\u751f\u4ea7\u7b2c" + level + "\u7ea7\u522butfgrid\u74e6\u7247";
            stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
        }
    }

    private ITileScroll getTileScroll(int start) {
        HashMap<String, List<String>> updateRegionsMap = new HashMap<String, List<String>>();
        updateRegionsMap.put("utflayer", this.updateRegions);
        return new WktArrayScroll(updateRegionsMap, this.grid, start);
    }

    private ITileConsumer createConsumer(UtfGridCell cell, ITileScroll scroll) {
        UtfGridUpdateHandler handlerStream = new UtfGridUpdateHandler(this.executor, 1, (ITileCutterCell)cell, (ITileSaver)this.saver, this.timestamp, this.removeOldTile);
        handlerStream.setResume(this.resume);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private MongoTileSaver createTileSaver(String collectionName) {
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), collectionName);
        tileSaver.init();
        return tileSaver;
    }
}

