/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.handler;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.spatial.grid.extent.impl.GridExtentImpl;
import com.geoway.vtile.tiledispatch.consumer.handler.abstractclass.AbstractTileHandlerStream;
import com.geoway.vtile.tiledispatch.consumer.handler.error.ITileErrorHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.UtfGridCell;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.cellv4.MapTileBuilderUnit;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileListCutHandler
extends AbstractTileHandlerStream<TileLayout> {
    private static Logger logger = LoggerFactory.getLogger(TileListCutHandler.class);
    protected ITileCutterCell<GridExtent, List<Object[]>> cell;
    private boolean isUtfGridTask = false;
    protected ITileSaver saver;
    protected IDocumentEncoder<Object[]> encoder;

    public TileListCutHandler(ExecutorService executor, int bufferSize) {
        super(executor, bufferSize);
    }

    public TileListCutHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, IDocumentEncoder encoder) {
        super(executor, bufferSize);
        this.cell = cell;
        this.isUtfGridTask = this.cell instanceof UtfGridCell;
        this.saver = saver;
        this.encoder = encoder;
    }

    public TileListCutHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, ITileErrorHandler errorHandler, IDocumentEncoder encoder) {
        super(executor, bufferSize);
        this.cell = cell;
        this.isUtfGridTask = this.cell instanceof UtfGridCell;
        this.saver = saver;
        this.errorHandler = errorHandler;
        this.encoder = encoder;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        if (this.cell != null) {
            this.cell.init();
        }
        this.saver.init();
        this.init = true;
    }

    @Override
    public void flush() {
    }

    @Override
    public void handle(TileLayout layout) {
        GridExtent extent = layout.getExtent();
        String extraFilter = layout.getExtraFilter();
        if (this.executor != null) {
            this.executor.execute(() -> this.handleItem(extent, extraFilter));
        } else {
            this.handleItem(extent, extraFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleItem(GridExtent extent, String extraFilter) {
        if (this.resume && this.saver.hasRecord(extent) || this.cancel) {
            this.count.countDown();
            return;
        }
        if (this.error) {
            this.count.countDown();
            return;
        }
        TileCutOptions options = new TileCutOptions();
        options.setExtraSqlFilter(extraFilter);
        List data = null;
        try {
            data = (List)this.cell.cut((Object)extent, options);
            if (!this.isUtfGridTask) {
                if (null != data) {
                    this.saver.save(data, this.encoder);
                }
                if (Log4jUtil.isDiagnoseEnable() && data != null && !data.isEmpty()) {
                    Object[] record0 = (Object[])data.get(0);
                    GridExtentImpl tile = (GridExtentImpl)record0[0];
                    logger.info(Log4jUtil.MARKER_DIAG, "\u5199\u5165\u74e6\u7247: {} \u53ca\u4e0b\u7ea7\u5b50\u74e6\u7247\u5171 {} \u5f20", (Object)tile.getCodeXYL(), (Object)data.size());
                }
            }
            if (null != data && null != this.progressFunc) {
                boolean hasData = !data.isEmpty();
                this.progressFunc.accept(hasData ? 1 : 0);
            }
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                this.errorHandler.handle(extent);
            } else {
                this.e = e;
                this.error = true;
            }
        }
        finally {
            this.count.countDown();
        }
    }

    @Override
    public void cancel() {
        this.cell.cancel();
        super.cancel();
    }

    public void summarize() {
        if (this.cell instanceof MapTileBuilderUnit) {
            MapTileBuilderUnit maptcell = (MapTileBuilderUnit)this.cell;
            maptcell.summarize();
        }
    }
}

