/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.scroll;

import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import java.util.ArrayList;
import java.util.List;

public class TileListScroll
implements ITileScroll {
    private List<GridExtent> grids = null;
    private int pos = 0;

    public TileListScroll() {
        this.grids = new ArrayList<GridExtent>();
    }

    public TileListScroll(List<GridExtent> grids) {
        this.grids = grids;
    }

    public void add(GridExtent grid) {
        this.grids.add(grid);
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0 && this.pos < this.grids.size();
    }

    @Override
    public TileLayout next() {
        if (this.pos < 0 || this.pos >= this.grids.size()) {
            return null;
        }
        GridExtent gridExtent = this.grids.get(this.pos++);
        return new TileLayout(gridExtent, null);
    }

    @Override
    public void init() {
        this.pos = 0;
    }

    @Override
    public Long getCount() {
        return this.grids.size();
    }

    public void reset() {
        this.pos = 0;
    }

    @Override
    public int getLevel() {
        if (this.grids.size() > 0) {
            return this.grids.get(0).getLevel();
        }
        return 0;
    }

    @Override
    public void release() {
        this.pos = 0;
        this.grids.clear();
    }
}

