/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.sched;

import com.geoway.vtile.cluster.bean.DistributedTaskBean;
import com.geoway.vtile.cluster.sched.TaskMaster;
import com.geoway.vtile.cluster.tasks.ParallelCutTask;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTaskScheduler {
    private static Logger logger = LoggerFactory.getLogger(ClusterTaskScheduler.class);
    private static ClusterTaskScheduler _scheduler = null;
    private static final Object lock = new Object();
    public static final long STAGE_TIMEOUT = 72001000L;
    private Client client;
    private TaskMaster taskMaster;
    private ExecutorService cutThreadPool;

    public static TaskMaster getTaskMaster() {
        return ClusterTaskScheduler.getInstance().taskMaster;
    }

    private ClusterTaskScheduler(Client client) {
        this.client = client;
        this.taskMaster = new TaskMaster(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterTaskScheduler getInstance() {
        if (null == _scheduler) {
            Object object = lock;
            synchronized (object) {
                if (null == _scheduler) {
                    if (null == Client.getInstance()) {
                        throw new RuntimeException("Client\u4e0a\u4e0b\u6587\u73af\u5883\u672a\u521d\u59cb\u5316\uff01");
                    }
                    _scheduler = new ClusterTaskScheduler(Client.getInstance());
                    _scheduler.init();
                }
            }
        }
        return _scheduler;
    }

    public void init() {
        int nThreads = TileDispatchTaskManager.getPoolThreadCount();
        this.cutThreadPool = new DoubleQueueExecutor(nThreads);
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u521d\u59cb\u5316\u9884\u70ed\u7ebf\u7a0b\u6c60, \u7ebf\u7a0b\u6570: {}", (Object)nThreads);
        }
    }

    public static ExecutorService getCutThreadPool() {
        return ClusterTaskScheduler.getInstance().cutThreadPool;
    }

    public static void startTask(ParallelCutTask task) throws Exception {
        ClusterTaskScheduler scheduler = ClusterTaskScheduler.getInstance();
        DistributedTaskBean bean = task.getTaskBean();
        logger.info("\u5df2\u542f\u52a8\u5206\u5e03\u5f0f\u5730\u56fe\u9884\u70ed\u4efb\u52a1\uff1a{}(\u5173\u8054\u5730\u56fe\u670d\u52a1\uff1a{})", (Object)bean.getTaskId(), (Object)bean.getVectorServiceId());
        scheduler.taskMaster.addTask(bean);
    }

    public static void stopTask(ParallelCutTask task) {
        ClusterTaskScheduler scheduler = ClusterTaskScheduler.getInstance();
        DistributedTaskBean bean = task.getTaskBean();
        logger.info("\u5df2\u7ed3\u675f\u5206\u5e03\u5f0f\u5730\u56fe\u9884\u70ed\u4efb\u52a1\uff1a{}(\u5173\u8054\u5730\u56fe\u670d\u52a1\uff1a{})", (Object)bean.getTaskId(), (Object)bean.getVectorServiceId());
        String tid = task.getTaskId();
        scheduler.taskMaster.deleteTask(tid);
    }
}

