/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.sched;

import com.geoway.vtile.cluster.bean.DistributedTaskBean;
import com.geoway.vtile.cluster.bean.TaskStateBean;
import com.geoway.vtile.cluster.dao.TaskGridDao;
import com.geoway.vtile.cluster.dao.TaskMetaDao;
import com.geoway.vtile.cluster.tasks.SlaveTaskUnit;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.service.client.Client;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskClient {
    private static Logger logger = LoggerFactory.getLogger(TaskClient.class);
    private static final int TASK_FETCH_INVERVAL_MS = 10000;
    private Client client;
    private TaskMetaDao dao;
    private TaskGridDao gridDao;
    private String workerIps;
    private DistributedTaskBean currentTaskBean;
    private IVectorService currentMapService;
    private SlaveTaskUnit taskUnit;

    public void setWorkerIps(String workerIps) {
        this.workerIps = workerIps;
    }

    public TaskClient(Client cli) {
        this.client = cli;
        this.dao = new TaskMetaDao();
        this.gridDao = new TaskGridDao();
    }

    public void start() {
        while (true) {
            try {
                while (true) {
                    this.loadTask();
                    if (null == this.currentTaskBean) {
                        logger.info("\u672a\u67e5\u8be2\u5230\u5206\u5e03\u5f0f\u4efb\u52a1");
                        Thread.sleep(10000L);
                        continue;
                    }
                    this.initTask();
                    if (null == this.taskUnit) {
                        Thread.sleep(10000L);
                        this.currentTaskBean = null;
                        continue;
                    }
                    this.executeTask();
                    this.taskUnit = null;
                    this.currentTaskBean = null;
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                continue;
            }
            break;
        }
    }

    private void loadTask() throws Exception {
        String tid = null;
        List<String> tasks = this.dao.listWorkingTasks();
        if (null == tasks || 0 == tasks.size()) {
            return;
        }
        tid = tasks.get(0);
        this.currentTaskBean = this.dao.get(tid);
        if (null == this.currentTaskBean) {
            throw new Exception("\u672a\u80fd\u4eceredis\u7f13\u5b58\u52a0\u8f7d\u4efb\u52a1\u4fe1\u606f\uff1a" + tid);
        }
        logger.info("\u4ece\u8282\u70b9\u6210\u529f\u52a0\u8f7d\u4efb\u52a1\uff1a" + this.currentTaskBean.getTaskId());
    }

    private SlaveTaskUnit initTask() {
        String mapId = this.currentTaskBean.getVectorServiceId();
        int gridsCount = this.gridDao.countGrids(this.currentTaskBean.getTaskId());
        if (gridsCount <= 0) {
            logger.info("\u672a\u83b7\u53d6\u5230\u4efb\u52a1\u7f51\u683c\uff0c\u7a0d\u540e\u91cd\u8bd5\u3002\uff08{}\uff09", (Object)this.currentTaskBean.getTaskId());
            this.taskUnit = null;
            return null;
        }
        IVectorServiceManager svcmanager = this.client.getVectorServiceManager();
        this.currentMapService = (IVectorService)svcmanager.get(mapId);
        this.taskUnit = new SlaveTaskUnit(this.currentTaskBean, this.currentMapService);
        return this.taskUnit;
    }

    private void executeTask() {
        this.taskUnit.init();
        try {
            this.taskUnit.start();
        }
        catch (Exception ex) {
            this.reportError(ex);
        }
        List<String> finishedGrids = this.taskUnit.getFinishedGrids();
        logger.info("worker <{}> \u5df2\u5904\u7406\u5b8c {} \u4e2a\u7f51\u683c", (Object)this.workerIps, (Object)finishedGrids.size());
        finishedGrids.clear();
    }

    private void reportError(Exception ex) {
        TaskStateBean stateBean = this.currentTaskBean.getTaskState();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : ex.getStackTrace()) {
            sb.append(element.toString() + "\n");
        }
        String stackTraceString = sb.toString();
        try (PrintWriter writer = new PrintWriter(new FileWriter("exception.txt", true));){
            ex.printStackTrace(writer);
            System.out.println("\u5f02\u5e38\u4fe1\u606f\u5df2\u5199\u5165\u5230 exception.txt \u6587\u4ef6\u4e2d\u3002");
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            System.err.println("\u65e0\u6cd5\u5199\u5165\u5f02\u5e38\u4fe1\u606f\u5230\u6587\u4ef6\u3002");
        }
    }
}

