/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.dao;

import com.geoway.vtile.tools.redis.RedisCache;
import java.util.List;

public class TaskGridDao {
    public final String NAMESPACE = "taskgrids";
    public final String KEY_COMPLETED_COUNT = "taskgrids_finished_count";
    private RedisCache redis = new RedisCache();

    private String wrapKey(String id) {
        return "taskgrids:" + id;
    }

    public void offerGrids(String taskId, List<String> gridKeys) {
        String gridsetKey = this.wrapKey(taskId);
        this.redis.setBatchAdd(gridsetKey, gridKeys);
    }

    public int countGrids(String taskId) {
        String gridsetKey = this.wrapKey(taskId);
        int n = (int)this.redis.setCount(gridsetKey);
        return n;
    }

    public void clearGrids(String taskId) {
        String gridsetKey = this.wrapKey(taskId);
        this.redis.remove(gridsetKey);
    }

    public String takeGrid(String taskId) {
        String gridsetKey = this.wrapKey(taskId);
        Object val = this.redis.setPop(gridsetKey);
        if (null == val) {
            return null;
        }
        return (String)val;
    }

    public int getCompletedCount(String taskId) {
        String key = "taskgrids_finished_count:" + taskId;
        String val = (String)this.redis.get(key);
        if (null == val) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    public int increaseCompleted(String taskId) {
        String key = "taskgrids_finished_count:" + taskId;
        long val = this.redis.incr(key);
        return (int)val;
    }

    public void clearCounter(String taskId) {
        String key = "taskgrids_finished_count:" + taskId;
        this.redis.remove(key);
    }
}

