/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.group;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.task.ITaskCallback;
import com.geoway.vtile.manager.task.ITileDispatchTask;
import com.geoway.vtile.tiledispatch.base.AbstractBaseComponent;
import com.geoway.vtile.tiledispatch.enums.TASKGROUP_ERROR_POLICY;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.geoway.vtile.transform.cell.process.ProcessList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDispatchTaskGroup
extends AbstractBaseComponent
implements ITileDispatchTask {
    private static Logger logger = LoggerFactory.getLogger(TileDispatchTaskGroup.class);
    protected ScheduledExecutorService logPool;
    protected boolean success = false;
    protected boolean onlyOne = false;
    private boolean _isReleased = false;
    protected TASKGROUP_ERROR_POLICY errorPolicy = TASKGROUP_ERROR_POLICY.shutdown;
    protected ITaskCallback onSuccess;
    protected ITaskCallback onError;
    protected ITaskCallback onStart;
    protected ITaskCallback onCancel;
    protected ITaskCallback onPause;
    protected ExecutorService executor;
    List<ITileDispatchTask> tasks;
    int nextIndex = 0;

    public TileDispatchTaskGroup(String name, List<ITileDispatchTask> tasks) {
        super(name);
        this.tasks = tasks;
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u521d\u59cb\u5316\u4efb\u52a1\u7ec4\uff1a{}, \u5b50\u4efb\u52a1\u4e2a\u6570\uff1a{}", (Object)name, (Object)tasks.size());
        }
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.logPool = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this.onStart != null) {
            this.onStart.callback();
        }
        String timeCost = "";
        long timeStart = System.currentTimeMillis();
        try {
            if (Log4jUtil.isDiagnoseEnable()) {
                logger.info("\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u7ec4\uff1a{}", (Object)this.name);
            }
            this.log(this.name + " \u5f00\u59cb");
            if (this.onlyOne) {
                ITileDispatchTask task = this.tasks.get(this.nextIndex);
                this.execute(task, false);
            } else {
                for (int i = 0; i < this.tasks.size(); ++i) {
                    if (this.error || this.cancel) {
                        return;
                    }
                    ITileDispatchTask task = this.tasks.get(i);
                    if (Log4jUtil.isDiagnoseEnable()) {
                        logger.info("\u5f00\u59cb\u6267\u884c\u5b50\u4efb\u52a1{} {}", (Object)i, (Object)task.getClass().getName());
                    }
                    this.execute(task, i > 0);
                    ++this.nextIndex;
                }
            }
            long timeEnd = System.currentTimeMillis();
            timeCost = String.format("%.3f", (double)(timeEnd - timeStart) * 1.0 / 1000.0);
            this.success();
            ProcessList.clearCache();
            this.log(this.name + " \u7ed3\u675f, \u603b\u8017\u65f6\uff08\u79d2\uff09\uff1a" + timeCost);
        }
        catch (Exception e) {
            this.log(this.name + " \u5f02\u5e38\u7ed3\u675f");
            this.log(e.getMessage());
            this.error();
            e.printStackTrace();
            if (Log4jUtil.isDiagnoseEnable()) {
                long timeEnd = System.currentTimeMillis();
                timeCost = String.format("%.3f", (double)(timeEnd - timeStart) * 1.0 / 1000.0);
                logger.error("\u4efb\u52a1\u7ec4 {} \u5f02\u5e38\u7ed3\u675f\uff01\u5df2\u8017\u65f6: {} s, \u9519\u8bef\uff1a{}", new Object[]{this.name, timeCost, e.getMessage()});
            }
            if (this.errorPolicy == TASKGROUP_ERROR_POLICY.shutdown) {
                return;
            }
            if (this.errorPolicy == TASKGROUP_ERROR_POLICY.ignore) {
                // empty if block
            }
        }
        finally {
            if (this.pause) {
                if (this.onPause != null) {
                    this.onPause.callback();
                }
            } else if (this.cancel) {
                if (this.onCancel != null) {
                    this.onCancel.callback();
                }
            } else if (this.error && this.onError != null) {
                this.onError.callback();
            }
            this.logPool.shutdown();
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u4efb\u52a1\u7ec4 {} \u5df2\u7ed3\u675f, \u603b\u8017\u65f6: {} s", (Object)this.name, (Object)timeCost);
        }
        if (!this.pause) {
            this.release();
        }
    }

    private void execute(ITileDispatchTask task, Boolean isChild) throws Exception {
        try {
            if (this.executor.isShutdown()) {
                this.executor = TileDispatchTaskManager.getInstance().getNewExecutor();
            }
            task.setLogger(this.cutLogger);
            task.setLogPool(this.logPool);
            task.setExecutor(this.executor);
            if (task instanceof AbstractTileDispatchTask) {
                ((AbstractTileDispatchTask)task).setIsChild(isChild);
            }
            task.init();
            task.start();
        }
        catch (Exception ex) {
            logger.error("\u4efb\u52a1\u5f02\u5e38:" + ex.getMessage(), (Throwable)ex);
            this.error = true;
            throw ex;
        }
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void setLogPool(ScheduledExecutorService logPool) {
        this.logPool = logPool;
    }

    public void success() {
        if (this.onSuccess != null) {
            this.onSuccess.callback();
        }
        this.success = true;
    }

    public void error() {
        this.error = true;
    }

    @Override
    public void cancel() {
        if (!this.init) {
            return;
        }
        this.cancel = true;
        ITileDispatchTask currentTask = this.tasks.get(this.nextIndex);
        currentTask.cancel();
    }

    public void pause() {
        if (!this.init) {
            return;
        }
        this.cancel = true;
        this.pause = true;
        ITileDispatchTask currentTask = this.tasks.get(this.nextIndex);
        currentTask.cancel();
    }

    public void onSuccess(ITaskCallback onSuccess) {
        this.onSuccess = onSuccess;
    }

    public void onError(ITaskCallback onError) {
        this.onError = onError;
    }

    public void onStart(ITaskCallback onStart) {
        this.onStart = onStart;
    }

    public void onCancel(ITaskCallback onCancel) {
        this.onCancel = onCancel;
    }

    public void onPause(ITaskCallback onPause) {
        this.onPause = onPause;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setNextIndex(int nextIndex) {
        this.nextIndex = nextIndex;
    }

    public void setErrorPolicy(TASKGROUP_ERROR_POLICY errorPolicy) {
        this.errorPolicy = errorPolicy;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isFinished() {
        return this.error || this.cancel || this.success;
    }

    public void release() {
        if (this._isReleased) {
            return;
        }
        if (this.pause) {
            return;
        }
        this._isReleased = true;
        if (null != this.tasks) {
            for (ITileDispatchTask task : this.tasks) {
                task.release();
            }
            this.tasks.clear();
            this.tasks = null;
        }
    }
}

