/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.pipeline;

import com.geoway.vtile.cluster.bean.DistributedTaskBean;
import com.geoway.vtile.cluster.bean.TaskContext;
import com.geoway.vtile.cluster.bean.TaskStateBean;
import com.geoway.vtile.cluster.dao.TaskGridDao;
import com.geoway.vtile.cluster.pipeline.ITaskHandler;
import com.geoway.vtile.cluster.sched.ClusterTaskScheduler;
import com.geoway.vtile.cluster.sched.TaskMaster;
import com.geoway.vtile.cluster.tasks.ParallelCutTask;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.tiledispatch.base.AbstractBaseComponent;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridsSummarizeHandler
extends AbstractBaseComponent
implements ITaskHandler {
    private static Logger logger = LoggerFactory.getLogger(GridsSummarizeHandler.class);
    private TaskGridDao dao = new TaskGridDao();
    private int interval_ms = 1000;

    @Override
    public Object handleGrids(TaskContext ctx) throws TimeoutException {
        int singleGridTimeout = GlobalTileSettings.PER_TILE_TIMEOUT_MS;
        ParallelCutTask cutTask = (ParallelCutTask)ctx.getCurrentTask();
        String tid = cutTask.getTaskId();
        long gridCount = ctx.getGridsScroll().getCount();
        System.out.println("\u6536\u96c6\u5b50\u4efb\u52a1\u7f51\u683c\u5b8c\u6210\u60c5\u51b5");
        int oldCount = 0;
        long oldTimestamp = System.currentTimeMillis();
        int finishedGridNum = 0;
        int nPercent10 = (int)(gridCount > 10L ? gridCount / 10L : 1L);
        int lastPct = 0;
        long lastPctTime = System.currentTimeMillis();
        while ((long)finishedGridNum < gridCount) {
            try {
                Thread.sleep(this.interval_ms);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finishedGridNum = this.dao.getCompletedCount(tid);
            if (oldCount != finishedGridNum) {
                int percent = finishedGridNum * 100 / (int)gridCount;
                if (nPercent10 > 1 && 0 == finishedGridNum % nPercent10) {
                    logger.info(Log4jUtil.MARKER_DIAG, "==>\u7b2c{}\u7ea7\u8d77\u59cb\u7684\u74e6\u7247\u9884\u70ed\u5b50\u4efb\u52a1\u5927\u7ea6\u8fdb\u5ea6\uff1a{}%", (Object)ctx.getStageLevel1(), (Object)percent);
                }
                oldCount = finishedGridNum;
                oldTimestamp = System.currentTimeMillis();
                this.checkException(tid);
                if (percent - lastPct <= 10 || oldTimestamp - lastPctTime <= 5000L) continue;
                lastPct = percent;
                lastPctTime = oldTimestamp;
                this.log("\u6b63\u5728\u751f\u4ea7\u7b2c" + ctx.getStageLevel1() + "\u7ea7\u5f00\u59cb\u7684\u4e00\u7ec4\u74e6\u7247\uff0c\u8fdb\u5ea6\uff1a" + finishedGridNum + "/" + gridCount + " \uff08" + percent + "%\uff09");
                continue;
            }
            long now = System.currentTimeMillis();
            if (now - oldTimestamp <= (long)singleGridTimeout) continue;
            logger.error("\u4efb\u52a1\u8fdb\u5ea6\u505c\u6ede\u8d85\u65f6\uff08{} s\uff09\uff0c\u53ef\u80fd\u6267\u884c\u8fdb\u7a0b\u5f02\u5e38\u9000\u51fa\uff0c\u6216\u8005\u5355\u4e2a\u74e6\u7247\u6570\u636e\u91cf\u592a\u5927\uff01", (Object)(singleGridTimeout / 1000));
            throw new TimeoutException("\u4efb\u52a1\u8fdb\u5ea6\u505c\u6ede\u8d85\u65f6");
        }
        System.out.println(gridCount + "\u4e2a\u7f51\u683c\u5df2\u7ecf\u5b8c\u6210");
        this.dao.clearGrids(tid);
        this.dao.clearCounter(tid);
        this.updateTaskState(tid);
        return null;
    }

    private void checkException(String tid) {
        TaskMaster master = ClusterTaskScheduler.getTaskMaster();
        DistributedTaskBean tbean = master.refreshTaskBean(tid);
        TaskStateBean state = tbean.getTaskState();
        List<String> errors = state.getErrors();
        if (null == errors || 0 == errors.size()) {
            return;
        }
        errors.stream().forEach(err -> logger.error(err));
        throw new RuntimeException("\u5206\u5e03\u5f0f\u5207\u7247\u51fa\u73b0\u5f02\u5e38");
    }

    private void updateTaskState(String tid) {
        try {
            TaskMaster master = ClusterTaskScheduler.getTaskMaster();
            DistributedTaskBean tbean = master.getTaskBean(tid);
            TaskStateBean state = tbean.getTaskState();
            int stageOrder = state.getCurrentStage();
            state.setPercentage((stageOrder + 1) * 100 / tbean.getStageCount());
            master.updateTaskState(tbean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init() {
    }
}

