/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.handler;

import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.handler.TileListCutHandler;
import com.geoway.vtile.tiledispatch.consumer.handler.error.ITileErrorHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import java.util.concurrent.ExecutorService;

public class UpdateRollbackHandler
extends TileListCutHandler {
    Long timestamp;
    Long nextTime;

    public UpdateRollbackHandler(ExecutorService executor, int bufferSize, ITileSaver saver, long timestamp, Long nextTime) {
        super(executor, bufferSize);
        this.saver = saver;
        this.timestamp = timestamp;
        this.nextTime = nextTime;
    }

    public UpdateRollbackHandler(ExecutorService executor, int bufferSize, ITileSaver saver, ITileErrorHandler errorHandler, Long timestamp, Long nextTime) {
        super(executor, bufferSize);
        this.cell = this.cell;
        this.saver = saver;
        this.errorHandler = errorHandler;
        this.timestamp = timestamp;
        this.nextTime = nextTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleItem(GridExtent extent, String extraFilter) {
        if (this.cancel) {
            this.count.countDown();
            return;
        }
        if (this.error) {
            this.count.countDown();
            return;
        }
        try {
            this.saver.removeAndUpdateEndTime(extent, this.timestamp, this.nextTime);
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                this.errorHandler.handle(extent);
            } else {
                this.e = e;
                this.error = true;
            }
        }
        finally {
            this.count.countDown();
        }
    }
}

