/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.task;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.model.vector_service.storage.StorageInfoBean;
import com.geoway.vtile.model.vector_service.storage.StorageInfoShell;
import com.geoway.vtile.model.vector_service.utfgrid.IUtfgridInfo;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.tiledispatch.consumer.ITileConsumer;
import com.geoway.vtile.tiledispatch.consumer.VectorCutMongoConsumer;
import com.geoway.vtile.tiledispatch.consumer.handler.TileListCutHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.TileLayoutDocumentEncoder;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.tiledispatch.consumer.scroll.UtfgridMongoDataScroll;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.producer.ITileProducer;
import com.geoway.vtile.tiledispatch.producer.TileLayoutProducer;
import com.geoway.vtile.tiledispatch.task.stage.TileConsumeStage;
import com.geoway.vtile.tiledispatch.task.stage.TileProduceStage;
import com.geoway.vtile.tiledispatch.task.stage.abstractclass.AbstractTaskStage;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.UtfGridCell;
import com.geoway.vtile.transform.cell.layout.ITileLayoutPrecutter;
import com.geoway.vtile.transform.cell.layout.MapTilePrecutter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtfgridTileCutTask
extends AbstractTileDispatchTask {
    private static Logger logger = LoggerFactory.getLogger(UtfgridTileCutTask.class);
    private static int SYNC_TIMEOUT_MILLIS = 30000;
    IVectorService vectorService;
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;
    List<MongoTileSaver> vtileSaver;
    Integer beginLevel;
    Integer endLevel;
    ExecutorService cutExecutor;
    boolean useServiceStorage = true;
    String dataServiceId = "";

    public UtfgridTileCutTask(String name, IVectorService vectorService, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel, String bbox) {
        this(name, vectorService, dataSource, beginLevel, endLevel);
        this.bbox = bbox;
    }

    public UtfgridTileCutTask(String name, IVectorService vectorService, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel) {
        super(name + "-UTFGrid-Task");
        this.vectorService = vectorService;
        this.mongodbDataSource = dataSource;
        this.beginLevel = beginLevel;
        this.endLevel = endLevel;
        this.bbox = vectorService.getBbox();
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.checkService();
        IStorageInfo storageInfo = this.createStorageInfo();
        IUtfgridInfo utfgridInfo = this.vectorService.getUtfgridInfo();
        utfgridInfo.setStorageInfo(storageInfo);
        try {
            this.vectorService.getClient().getVectorServiceManager().update((Object)this.vectorService);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5730\u56fe\u670d\u52a1" + (String)this.vectorService.getId() + "\u66f4\u65b0\u4fdd\u5b58utfgrid\u5143\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
        }
        this.saver = this.createTileSaver(this.getStorageName());
        this.vtileSaver = this.getVtileSaver(this.vectorService);
        int taskNum = Runtime.getRuntime().availableProcessors();
        if (this.executor == null) {
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        this.cutExecutor = new DoubleQueueExecutor(taskNum * 2);
        this.grid = this.vectorService.getGridTree();
        try {
            if (GlobalTileSettings.UTFGRID_SYNC_TIMEOUT_MILLIS > 0) {
                SYNC_TIMEOUT_MILLIS = GlobalTileSettings.UTFGRID_SYNC_TIMEOUT_MILLIS;
            }
            logger.info("\u7b49\u5f85utrgrid\u5143\u6570\u636e\u4fe1\u606f\u540c\u6b65\uff0c {} ms", (Object)SYNC_TIMEOUT_MILLIS);
            Thread.sleep(SYNC_TIMEOUT_MILLIS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.buildStages();
    }

    private IStorageInfo createStorageInfo() {
        StorageInfoBean storageInfoBean = new StorageInfoBean();
        storageInfoBean.setDataSourceId(this.mongodbDataSource.getId());
        storageInfoBean.setStartLevel(this.beginLevel);
        storageInfoBean.setEndLevel(this.endLevel);
        storageInfoBean.setStorageName(this.getStorageName());
        storageInfoBean.setCompleted(false);
        return new StorageInfoShell(this.vectorService.getClient(), storageInfoBean);
    }

    private void checkService() {
        if (this.vectorService.getUtfgridInfo() == null) {
            throw new RuntimeException("\u670d\u52a1 " + (String)this.vectorService.getId() + " \u4e0d\u5305\u542butfgrid\u4fe1\u606f\uff0c \u65e0\u6cd5\u63d0\u53d6");
        }
        Iterator iterator = this.vectorService.getLayerMap().values().iterator();
        String[] mergeFields = this.vectorService.getUtfgridInfo().getMergeFields().split(",");
        ArrayList<String> ignoreLayers = new ArrayList<String>();
        while (iterator.hasNext()) {
            ILayer layer = (ILayer)iterator.next();
            if (!this.dataServiceId.equals(layer.getDataServiceId())) {
                ignoreLayers.add(layer.getId());
                continue;
            }
            IDataSet dataSet = ((ILayerLevel)layer.getLevelMap().values().iterator().next()).getDataSet();
            Constants.GEO_TYPE geometryType = dataSet.getGeometryType();
            if (geometryType != Constants.GEO_TYPE.POLYGON && geometryType != Constants.GEO_TYPE.MULTIPOLYGON) {
                throw new RuntimeException("\u670d\u52a1 " + (String)this.vectorService.getId() + "\u7684\u56fe\u5c42 " + layer.getId() + " \u4e0d\u662f\u9762\u72b6\u56fe\u5c42\uff0c\u65e0\u6cd5\u63d0\u53d6");
            }
            String idField = dataSet.getIdField();
            Optional<String> hasIdFieldInMerge = Arrays.stream(mergeFields).filter(field -> idField.equals(field)).findFirst();
            if (hasIdFieldInMerge.isPresent()) {
                throw new RuntimeException("\u878d\u5408\u5b57\u6bb5\u4e0d\u80fd\u5305\u62ec\u4e3b\u952e\u5b57\u6bb5");
            }
            List<String> fieldsArr = Arrays.asList(dataSet.getFieldsArr());
            for (int i = 0; i < mergeFields.length; ++i) {
                if (fieldsArr.contains(mergeFields[i])) continue;
                throw new RuntimeException("\u56fe\u5c42" + layer.getId() + "\u4e0d\u5305\u542b\u878d\u5408\u5b57\u6bb5" + mergeFields[i]);
            }
        }
        String ignoLayers = StringUtils.join(ignoreLayers, (char)',');
        logger.info("\u4e0d\u53c2\u4e0eUTFGrid\u751f\u6210\u7684\u56fe\u5c42\uff1a" + ignoLayers);
        this.vectorService.getUtfgridInfo().getBean().setIgnoreLayer(ignoLayers);
        List<IStorageInfo> storageInfoList = this.getVtileStorageInfo(this.vectorService);
        if (storageInfoList == null || storageInfoList.isEmpty()) {
            throw new RuntimeException("\u670d\u52a1 " + (String)this.vectorService.getId() + " \u6ca1\u6709\u9884\u70ed\u74e6\u7247\uff0c\u65e0\u6cd5\u63d0\u53d6");
        }
        for (IStorageInfo storageInfo : storageInfoList) {
            int cutStartLevel = storageInfo.getStartLevel();
            int cutEndLevel = storageInfo.getEndLevel();
            int utfEndLevel = this.endLevel;
            if (utfEndLevel + 1 >= cutStartLevel && utfEndLevel + 1 <= cutEndLevel) continue;
            throw new RuntimeException("\u9700\u8981\u4ece\u63d0\u53d6\u7ec8\u6b62\u7ea7\u522b\u7684\u4e0b\u4e00\u7ea7\u7684\u77e2\u91cf\u74e6\u7247\u5f00\u59cb\u6784\u5efautfgrid\uff0c\u4f46\u8be5\u7ea7\u522b\u76ee\u524d\u6ca1\u6709\u9884\u70ed\u74e6\u7247");
        }
    }

    @Override
    public void success() throws Exception {
        IUtfgridInfo utfgridInfo = this.vectorService.getUtfgridInfo();
        IStorageInfo storageInfo = utfgridInfo.getStorageInfo();
        storageInfo.setCompleted(true);
        try {
            this.vectorService.getClient().getVectorServiceManager().update((Object)this.vectorService);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5730\u56fe\u670d\u52a1" + (String)this.vectorService.getId() + "\u66f4\u65b0\u4fdd\u5b58utfgrid\u72b6\u6001\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
        }
        super.success();
    }

    private String getStorageName() {
        return (String)this.vectorService.getId() + "_utfgrid";
    }

    private void buildStages() {
        this.stages = new ArrayList();
        UtfGridCell cell = null;
        int start = this.grid.getBeginLevel();
        int end = this.endLevel + 1;
        String produceStageName = "\u751f\u4ea7" + start + "\u81f3" + end + "\u7ea7\u522b\u74e6\u7247\u6846\u67b6";
        MapTilePrecutter layoutCell = new MapTilePrecutter(this.vectorService, this.cutExecutor);
        layoutCell.setMainLevel(Integer.valueOf(end));
        layoutCell.setDown(0);
        ITileProducer producer = this.createProducer(start, end, layoutCell);
        AbstractTaskStage stage = new TileProduceStage(produceStageName, producer, null, null);
        stage.setLogger(this.cutLogger);
        this.stages.add(stage);
        cell = new UtfGridCell((String)this.vectorService.getId(), this.vectorService.getUtfgridInfo(), this.vectorService.getClient().getMapServerAccess(), true);
        UtfgridMongoDataScroll scroll = new UtfgridMongoDataScroll(end, this.grid, this.saver, null, true);
        ITileConsumer tileConsumer = this.createConsumer(cell, scroll, this.endLevel + 1);
        String consumeStageName = "\u751f\u4ea7\u5e95\u5c42\u7b2c" + end + "\u7ea7\u522butfgrid\u74e6\u7247";
        stage = new TileConsumeStage(consumeStageName, tileConsumer);
        stage.setLogger(this.cutLogger);
        this.stages.add(stage);
        cell = new UtfGridCell((String)this.vectorService.getId(), this.vectorService.getUtfgridInfo(), this.vectorService.getClient().getMapServerAccess(), false);
        for (int level = this.endLevel.intValue(); level >= this.beginLevel; --level) {
            scroll = new UtfgridMongoDataScroll(level, this.grid, this.saver, null, true);
            tileConsumer = this.createConsumer(cell, scroll, level);
            consumeStageName = "\u751f\u4ea7\u7b2c" + level + "\u7ea7\u522butfgrid\u74e6\u7247";
            stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
        }
    }

    private ITileProducer createProducer(int beginLevel, int endLevel, MapTilePrecutter cell) {
        TileLayoutProducer tileProducer = new TileLayoutProducer((ITileLayoutPrecutter)cell, this.saver, this.executor, beginLevel, endLevel, this.grid, this.bbox, (String)this.vectorService.getId(), new TileLayoutDocumentEncoder());
        tileProducer.setUtfgrid(true);
        tileProducer.setLogPool(this.logPool);
        tileProducer.setLogger(this.cutLogger);
        tileProducer.init();
        return tileProducer;
    }

    private ITileConsumer createConsumer(UtfGridCell cell, ITileScroll scroll, Integer level) {
        TileListCutHandler handlerStream = new TileListCutHandler(this.executor, 1, (ITileCutterCell)cell, this.saver, new TileDataDocumentEncoder());
        handlerStream.setResume(this.resume);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private MongoTileSaver createTileSaver(String collectionName) {
        IUtfgridInfo utfgridInfo;
        if (!this.resume && (utfgridInfo = this.vectorService.getUtfgridInfo()) != null) {
            utfgridInfo.drop();
        }
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), collectionName);
        tileSaver.setEnableSharding(true);
        tileSaver.init();
        return tileSaver;
    }

    private List<IStorageInfo> getVtileStorageInfo(IVectorService vectorService) {
        ArrayList<IStorageInfo> list = new ArrayList<IStorageInfo>();
        IStorageInfo storageInfo = vectorService.getStorageInfo();
        if (storageInfo == null || !this.useServiceStorage) {
            for (ILayer layer : vectorService.getLayerMap().values()) {
                IDataSet dataSet;
                if (!this.dataServiceId.equals(layer.getDataServiceId()) || (storageInfo = (dataSet = ((ILayerLevel)layer.getLevelMap().values().iterator().next()).getDataSet()).getDataService().getStorageInfo()) == null) continue;
                list.add(storageInfo);
            }
        } else {
            list.add(storageInfo);
        }
        return list;
    }

    private List<MongoTileSaver> getVtileSaver(IVectorService vectorService) {
        List<IStorageInfo> storageInfoList = this.getVtileStorageInfo(vectorService);
        ArrayList<MongoTileSaver> list = new ArrayList<MongoTileSaver>(storageInfoList.size());
        for (IStorageInfo storageInfo : storageInfoList) {
            MongodbDataSource mongodbDataSource = (MongodbDataSource)storageInfo.getDataSource().getBean();
            MongoTileSaver tileSaver = new MongoTileSaver(mongodbDataSource.getUri(), storageInfo.getStorageName());
            tileSaver.setEnableSharding(true);
            tileSaver.init();
            list.add(tileSaver);
        }
        return list;
    }

    public void setUseServiceStorage(boolean useServiceStorage) {
        this.useServiceStorage = useServiceStorage;
    }

    public void setPickDataServiceId(String dataServiceId) {
        this.dataServiceId = dataServiceId;
    }

    public void setUseDataStorageId(String dataServiceId) {
        this.useServiceStorage = false;
        this.dataServiceId = dataServiceId;
    }
}

