/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.tasks;

import com.geoway.vtile.cluster.bean.DistributedTaskBean;
import com.geoway.vtile.cluster.bean.TaskContext;
import com.geoway.vtile.cluster.bean.TaskStateBean;
import com.geoway.vtile.cluster.pipeline.GridsDistributeHandler;
import com.geoway.vtile.cluster.pipeline.GridsFilterHandler;
import com.geoway.vtile.cluster.pipeline.GridsSummarizeHandler;
import com.geoway.vtile.cluster.pipeline.TaskPipeline;
import com.geoway.vtile.cluster.sched.ClusterTaskScheduler;
import com.geoway.vtile.cluster.sched.TaskMaster;
import com.geoway.vtile.cluster.tasks.ParallelCutTask;
import com.geoway.vtile.manager.task.exception.TaskCancelException;
import com.geoway.vtile.tiledispatch.exception.ConsumeException;
import com.geoway.vtile.tiledispatch.exception.ProduceException;
import com.geoway.vtile.tiledispatch.task.stage.abstractclass.AbstractTaskStage;

public class ParallelTaskStage
extends AbstractTaskStage {
    private TaskPipeline pipeline;
    private TaskContext taskCtx;
    private int stageOrder;

    public void setTaskCtx(TaskContext taskCtx) {
        this.taskCtx = taskCtx;
    }

    public int getStageOrder() {
        return this.stageOrder;
    }

    public void setStageOrder(int stageOrder) {
        this.stageOrder = stageOrder;
    }

    public ParallelTaskStage(String name) {
        super(name);
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        if (null == this.taskCtx) {
            return;
        }
        try {
            ParallelCutTask currentTask = (ParallelCutTask)this.taskCtx.getCurrentTask();
            TaskMaster master = ClusterTaskScheduler.getTaskMaster();
            DistributedTaskBean tbean = master.getTaskBean(currentTask.getTaskId());
            TaskStateBean state = tbean.getTaskState();
            if (null == state) {
                state = new TaskStateBean();
                tbean.setTaskState(state);
                tbean.setStartTime(System.currentTimeMillis());
            }
            state.setTaskId(tbean.getTaskId());
            state.setCurrentStage(this.stageOrder);
            state.setCurrentLevel(this.taskCtx.getStageLevel1());
            state.setStageLevel1(this.taskCtx.getStageLevel1());
            state.setStageLevel2(this.taskCtx.getStageLevel2());
            state.setPercentage(this.stageOrder * 100 / tbean.getStageCount());
            master.updateTaskState(tbean);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u66f4\u65b0\u96c6\u7fa4\u4efb\u52a1\u72b6\u6001\u5931\u8d25", ex);
        }
        this.pipeline = new TaskPipeline(this.taskCtx);
        this.pipeline.use(new GridsFilterHandler());
        this.pipeline.use(new GridsDistributeHandler());
        GridsSummarizeHandler gridsSummarizeHandler = new GridsSummarizeHandler();
        gridsSummarizeHandler.setLogger(this.cutLogger);
        this.pipeline.use(gridsSummarizeHandler);
        this.init = true;
    }

    @Override
    public void execute() throws ConsumeException, TaskCancelException, ProduceException {
        this.log(this.name + " \u5f00\u59cb");
        try {
            this.pipeline.proceed();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        this.log(this.name + " \u7ed3\u675f");
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }
}

