/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.handler.update;

import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.handler.update.AbstractUpdateHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class VectorLayerUpdateHandler
extends AbstractUpdateHandler {
    long timestamp;
    IDocumentEncoder<Object[]> encoder;

    public VectorLayerUpdateHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, long timestamp, IDocumentEncoder encoder) {
        super(executor, bufferSize, true);
        this.cell = cell;
        this.saver = saver;
        this.timestamp = timestamp;
        this.encoder = encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleItem(GridExtent extent, String extraFilter) {
        if (this.resume && this.saver.hasRecord(extent, this.timestamp) || this.cancel) {
            this.count.countDown();
            return;
        }
        if (this.error) {
            this.count.countDown();
            return;
        }
        List data = null;
        try {
            data = (List)this.cell.cut((Object)extent, new TileCutOptions());
            if (this.removeOldTile) {
                this.removeOldTile(extent);
            } else {
                this.updateOldTileEndTime(extent, data, this.timestamp);
            }
            this.saver.updateEndTimeAndSave(data, this.timestamp, this.encoder);
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                this.errorHandler.handle(extent);
            } else {
                this.e = e;
                this.error = true;
            }
        }
        finally {
            this.count.countDown();
        }
    }
}

