/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.sched;

import com.geoway.vtile.cluster.bean.DistributedTaskBean;
import com.geoway.vtile.cluster.dao.TaskMetaDao;
import com.geoway.vtile.service.client.Client;
import java.util.LinkedHashMap;
import java.util.Map;

public class TaskMaster {
    private Client client;
    private TaskMetaDao dao;
    private Map<String, DistributedTaskBean> tasks;

    public TaskMaster(Client cli) {
        this.client = cli;
        this.dao = new TaskMetaDao();
        this.tasks = new LinkedHashMap<String, DistributedTaskBean>();
    }

    public void addTask(DistributedTaskBean taskBean) throws Exception {
        this.tasks.put(taskBean.getTaskId(), taskBean);
        this.dao.insert(taskBean);
    }

    public void updateTaskState(DistributedTaskBean taskBean) throws Exception {
        this.tasks.put(taskBean.getTaskId(), taskBean);
        this.dao.sync2Redis(taskBean);
    }

    public void deleteTask(String taskId) {
        this.tasks.remove(taskId);
        this.dao.delete(taskId);
    }

    public DistributedTaskBean getTaskBean(String taskId) {
        return this.tasks.get(taskId);
    }

    public DistributedTaskBean refreshTaskBean(String taskId) {
        DistributedTaskBean bean = null;
        try {
            bean = this.dao.get(taskId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tasks.put(taskId, bean);
        return bean;
    }
}

