/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task;

import com.geoway.vtile.commons.concurrent.BlockThreadPool;
import com.geoway.vtile.diagnose.GlobalMetrics;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.task.ITaskManager;
import com.geoway.vtile.manager.task.ITileDispatchTask;
import com.geoway.vtile.manager.task.exception.TaskIsRunningException;
import com.geoway.vtile.manager.task.exception.TaskNotFoundException;
import com.geoway.vtile.service.client.Client;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDispatchTaskManager
implements ITaskManager {
    public static int MAX_PROCESS_NUM = 1;
    public static Integer CUSTOM_THREAD_COUNT = 0;
    public static final Integer TASK_EXCECUTOR_NUM = Runtime.getRuntime().availableProcessors() * 2;
    public static final int MAX_QUEUE_SIZE = TASK_EXCECUTOR_NUM * 10;
    private static Logger logger = LoggerFactory.getLogger(TileDispatchTaskManager.class);
    private static TileDispatchTaskManager manager;
    private Client client;
    private Map<String, Future> futuresMap = new ConcurrentHashMap<String, Future>();
    private Map<String, ITileDispatchTask> tasksMap = new ConcurrentHashMap<String, ITileDispatchTask>();
    private Map<String, ITileDispatchTask> taskTrashbin = new ConcurrentHashMap<String, ITileDispatchTask>();
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(MAX_PROCESS_NUM, MAX_PROCESS_NUM, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(MAX_QUEUE_SIZE), new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            throw new RuntimeException("\u961f\u5217\u5df2\u6ee1");
        }
    });
    private ExecutorService executor = this.getNewExecutor();

    private TileDispatchTaskManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TileDispatchTaskManager getInstance() {
        if (manager != null) return manager;
        Class<TileDispatchTaskManager> clazz = TileDispatchTaskManager.class;
        synchronized (TileDispatchTaskManager.class) {
            if (manager != null) return manager;
            manager = new TileDispatchTaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public void init() {
    }

    public ExecutorService getNewExecutor() {
        int nThreads = TileDispatchTaskManager.getPoolThreadCount();
        return new BlockThreadPool(nThreads, MAX_QUEUE_SIZE);
    }

    public static int getPoolThreadCount() {
        return CUSTOM_THREAD_COUNT > 0 ? CUSTOM_THREAD_COUNT : TASK_EXCECUTOR_NUM;
    }

    public void addTask(String taskId, ITileDispatchTask task) {
        this.addTask(taskId, task, TileDispatchTaskManager.getPoolThreadCount());
    }

    public void addTask(String taskId, ITileDispatchTask task, Integer taskExcecutorNum) {
        if (this.executor.isShutdown()) {
            this.executor = new BlockThreadPool(taskExcecutorNum.intValue(), MAX_QUEUE_SIZE);
        }
        task.setExecutor(this.executor);
        Future<?> future = this.pool.submit(() -> {
            try {
                logger.info("\u5df2\u63d0\u4ea4\u4efb\u52a1\u5230\u8c03\u5ea6\u961f\u5217\u3002 {} {} ", (Object)task.toString(), (Object)taskId);
                task.start();
            }
            catch (Exception e) {
                logger.error("\u63d0\u4ea4\u4efb\u52a1\u5230\u8c03\u5ea6\u961f\u5217\u5931\u8d25\uff01 {} {} ", (Object)task.toString(), (Object)taskId);
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.remove(taskId);
            }
        });
        this.futuresMap.put(taskId, future);
        this.tasksMap.put(taskId, task);
        this.trimTrashbin();
        if (Log4jUtil.isDiagnoseEnable()) {
            GlobalMetrics.Current.getnTaskStartCalled().incrementAndGet();
        }
    }

    public void cancel(String taskId) throws TaskNotFoundException {
        Future future = this.futuresMap.get(taskId);
        ITileDispatchTask task = this.tasksMap.get(taskId);
        if (future == null || task == null) {
            throw new TaskNotFoundException("\u627e\u4e0d\u5230\u4efb\u52a1" + taskId);
        }
        if (this.pool.getQueue().contains(future)) {
            future.cancel(true);
            this.pool.remove((FutureTask)future);
        } else {
            task.cancel();
        }
        this.remove(taskId);
        this.trimTrashbin();
        if (Log4jUtil.isDiagnoseEnable()) {
            GlobalMetrics.Current.getnTaskCancelCalled().incrementAndGet();
        }
    }

    public void pause(String taskId) throws TaskNotFoundException {
        Future future = this.futuresMap.get(taskId);
        ITileDispatchTask task = this.tasksMap.get(taskId);
        if (future == null || task == null) {
            throw new TaskNotFoundException("\u627e\u4e0d\u5230\u4efb\u52a1" + taskId);
        }
        if (this.pool.getQueue().contains(future)) {
            future.cancel(true);
            this.pool.remove((FutureTask)future);
        } else {
            task.pause();
        }
        this.remove(taskId);
        this.trimTrashbin();
        if (Log4jUtil.isDiagnoseEnable()) {
            GlobalMetrics.Current.getnTaskCancelCalled().incrementAndGet();
        }
    }

    public void remove(String taskId) {
        this.futuresMap.remove(taskId);
        ITileDispatchTask task = this.tasksMap.remove(taskId);
        if (null != task) {
            this.moveToTrashbin(taskId, task);
        }
    }

    private void moveToTrashbin(String taskId, ITileDispatchTask task) {
        if (null == task) {
            return;
        }
        if (task.isFinished()) {
            task.release();
        } else {
            this.taskTrashbin.put(taskId, task);
        }
    }

    private void trimTrashbin() {
        if (null == this.taskTrashbin || 0 == this.taskTrashbin.size()) {
            return;
        }
        ArrayList<String> finshedList = new ArrayList<String>();
        for (String taskId : this.taskTrashbin.keySet()) {
            ITileDispatchTask task = this.taskTrashbin.get(taskId);
            if (!task.isFinished()) continue;
            finshedList.add(taskId);
            task.release();
        }
        finshedList.forEach(id -> this.taskTrashbin.remove(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrder(String taskId, int targetIndex) throws TaskIsRunningException, TaskNotFoundException {
        Future future = this.futuresMap.get(taskId);
        if (future == null) {
            throw new TaskNotFoundException("\u627e\u4e0d\u5230\u4efb\u52a1" + taskId);
        }
        LinkedList<Runnable> list = new LinkedList<Runnable>();
        BlockingQueue<Runnable> blockingQueue = this.pool.getQueue();
        synchronized (blockingQueue) {
            if (!this.pool.getQueue().contains(future)) {
                throw new TaskIsRunningException("\u4efb\u52a1" + taskId + "\u6b63\u5728\u8fd0\u884c,\u4e0d\u80fd\u8c03\u6574\u987a\u5e8f");
            }
            this.pool.getQueue().drainTo(list);
            int originIndex = list.indexOf(future);
            Runnable task = (Runnable)list.get(originIndex);
            list.remove(originIndex);
            list.add(targetIndex, task);
            this.pool.getQueue().addAll(list);
        }
        list.clear();
    }

    public boolean isBusy() {
        return !this.isEnough(1);
    }

    public boolean isEnough(int size) {
        return MAX_QUEUE_SIZE - this.pool.getQueue().size() >= size;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Map<String, Object> getQueueStatus() {
        ThreadPoolExecutor tpool = this.pool;
        HashMap<String, Integer> poolStat = new HashMap<String, Integer>();
        poolStat.put("poolSize", tpool.getCorePoolSize());
        poolStat.put("runingCount", tpool.getActiveCount());
        poolStat.put("waitingCount", tpool.getQueue().size());
        poolStat.put("finishedCount", (int)tpool.getCompletedTaskCount());
        poolStat.put("isShutdown", tpool.isShutdown() ? 1 : 0);
        BlockThreadPool tilepool = (BlockThreadPool)this.executor;
        HashMap<String, Integer> tilepoolStat = new HashMap<String, Integer>();
        tilepoolStat.put("poolSize", tilepool.getCorePoolSize());
        tilepoolStat.put("runingCount", tilepool.getActiveCount());
        tilepoolStat.put("waitingCount", tilepool.getQueue().size());
        tilepoolStat.put("finishedCount", (int)tilepool.getCompletedTaskCount());
        tilepoolStat.put("isShutdown", tilepool.isShutdown() ? 1 : 0);
        LinkedHashMap<String, Object> queStat = new LinkedHashMap<String, Object>();
        queStat.put("\u8fd0\u884c\u4e2d\u7684\u7684\u4efb\u52a1\u5217\u8868", this.tasksMap);
        queStat.put("\u8c03\u5ea6\u7ebf\u7a0b\u6c60\u72b6\u6001", poolStat);
        queStat.put("\u5207\u7247\u7ebf\u7a0b\u6c60\u72b6\u6001", tilepoolStat);
        queStat.put("\u4efb\u52a1\u56de\u6536\u7ad9", this.taskTrashbin);
        return queStat;
    }

    public void resetCutThreaPool() {
        BlockThreadPool tilepool = (BlockThreadPool)this.executor;
        if (!tilepool.isShutdown()) {
            tilepool.shutdownNow();
        }
        if (!this.pool.isShutdown()) {
            List<Runnable> queuingJobs = this.pool.shutdownNow();
            this.pool = new ThreadPoolExecutor(MAX_PROCESS_NUM, MAX_PROCESS_NUM, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(MAX_QUEUE_SIZE), new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    throw new RuntimeException("\u961f\u5217\u5df2\u6ee1");
                }
            });
            if (this.tasksMap.size() > 0) {
                this.tasksMap.keySet().forEach(tid -> {
                    ITileDispatchTask t = this.tasksMap.get(tid);
                    if (!t.isFinished()) {
                        this.addTask((String)tid, t);
                    }
                });
            }
            if (Log4jUtil.isDiagnoseEnable()) {
                GlobalMetrics.Current.getnTaskPoolRebuilt().incrementAndGet();
            }
        }
        this.trimTrashbin();
    }
}

