/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.tasks;

import com.geoway.vtile.cluster.bean.DistributedTaskBean;
import com.geoway.vtile.cluster.dao.TaskGridDao;
import com.geoway.vtile.cluster.slave.VTileHandler;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlaveTaskUnit {
    private static Logger logger = LoggerFactory.getLogger(SlaveTaskUnit.class);
    private DistributedTaskBean taskBean;
    private IVectorService mapService;
    private TaskGridDao dao;
    private VTileHandler vtiler;
    private List<String> finishedGrids = new ArrayList<String>();

    public List<String> getFinishedGrids() {
        return this.finishedGrids;
    }

    public SlaveTaskUnit(DistributedTaskBean currentTaskBean, IVectorService currentMapService) {
        this.taskBean = currentTaskBean;
        this.mapService = currentMapService;
        this.dao = new TaskGridDao();
    }

    public void init() {
        VTileHandler cutter = new VTileHandler(this.taskBean, Client.getInstance(), this.mapService);
        cutter.init();
        this.vtiler = cutter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        String tid = this.taskBean.getTaskId();
        IGridSystem gridSys = this.mapService.getGridTree();
        int total = this.dao.countGrids(tid);
        logger.info("\u8fd8\u6709{}\u4e2a\u7f51\u683c\u5f85\u5904\u7406", (Object)total);
        while (true) {
            String strGridKey;
            if (StringUtils.isBlank((CharSequence)(strGridKey = this.dao.takeGrid(tid)))) break;
            logger.info("\u5f85\u5904\u7406\u7f51\u683c\uff1a" + strGridKey);
            String[] args = strGridKey.split("_", 3);
            GridExtent ext = gridSys.getGridExtent(Integer.parseInt(args[2]), Integer.parseInt(args[0]), Integer.parseInt(args[1]));
            this.vtiler.processGrid(ext);
            logger.info("\u5df2\u5b8c\u6210\u7f51\u683c\uff1a" + strGridKey);
            this.dao.increaseCompleted(tid);
            List<String> list = this.finishedGrids;
            synchronized (list) {
                this.finishedGrids.add(strGridKey);
            }
        }
        logger.info("\u672a\u83b7\u53d6\u5230\u4efb\u52a1\u7f51\u683c\uff0c\u51c6\u5907\u9000\u51fa");
    }
}

