/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.buffer;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.tiledispatch.consumer.buffer.IDataBuffer;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import com.geoway.vtile.transform.writer.ConcurrentVarintWriter;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarintWriterBuffer
implements IDataBuffer<Object[]> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Map<String, ConcurrentVarintWriter> tileMap = new ConcurrentHashMap<String, ConcurrentVarintWriter>();
    Map<Long, Deque<Object[]>> itemThreadBuffer = new ConcurrentHashMap<Long, Deque<Object[]>>(Runtime.getRuntime().availableProcessors() * 2);
    ITileSaver saver;
    IDocumentEncoder encoder;
    IGridSystem grid;
    LAYER_TYPE layerType;
    Constants.GEO_TYPE geoType;
    ITable table;
    String[] propertyFields;
    protected Throwable e;
    boolean isInit = false;
    public boolean error = false;
    protected ExecutorService saveThread;
    protected ScheduledExecutorService collectThread;
    public static final int MAX_COORDINATES_SIZE_THRESHOLD = 3072;
    public static final int MAX_UN_MODIFIED_NUM = 3;
    public static final int MAX_UN_FLUSH_NUM = 10;

    public VarintWriterBuffer(ITileSaver tileSaver, IDocumentEncoder encoder, IGridSystem grid, ITable table, LAYER_TYPE layerType, Constants.GEO_TYPE geoType) {
        this.saver = tileSaver;
        this.encoder = encoder;
        this.grid = grid;
        this.table = table;
        this.layerType = layerType;
        this.geoType = geoType;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver.init();
        this.saveThread = TileDispatchTaskManager.getInstance().getNewExecutor();
        this.collectThread = Executors.newScheduledThreadPool(1);
        this.collectThread.scheduleWithFixedDelay(() -> this.collect(), 2L, 60L, TimeUnit.SECONDS);
        Object[] fields = this.table.getFields();
        String spatialField = this.table.spatialInfo().getSpatialField();
        int spatialIndex = ArrayUtils.indexOf((Object[])fields, (Object)spatialField);
        this.propertyFields = (String[])ArrayUtils.remove((Object[])fields, (int)spatialIndex);
    }

    @Override
    public void push(List<Object[]> datas) {
        long threadId = Thread.currentThread().getId();
        Deque<Object[]> deque = this.itemThreadBuffer.get(threadId);
        if (deque == null) {
            deque = new ConcurrentLinkedDeque<Object[]>();
            Deque<Object[]> newDeque = this.itemThreadBuffer.putIfAbsent(threadId, deque);
            if (newDeque != null) {
                deque = newDeque;
            }
        }
        deque.addAll(datas);
    }

    private synchronized void collect() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Iterator<Long> iterator = this.itemThreadBuffer.keySet().iterator();
        while (iterator.hasNext()) {
            Deque<Object[]> deque = this.itemThreadBuffer.get(iterator.next());
            Object[] item = null;
            while ((item = deque.poll()) != null) {
                list.add(item);
            }
        }
        this.merge(list);
    }

    private void merge(List<Object[]> datas) {
        if (this.error) {
            throw new RuntimeException(this.e);
        }
        switch (this.geoType) {
            case POINT: {
                this.dealWithPoint(datas);
                break;
            }
            case MULTIPOINT: {
                this.dealWithMultiPoint(datas);
                break;
            }
            case LINESTRING: 
            case POLYGON: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                this.dealWithOthers(datas);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + this.geoType.name());
            }
        }
    }

    private void dealWithPoint(List<Object[]> datas) {
        for (Object[] data : datas) {
            String extentKey = (String)data[0];
            ConcurrentVarintWriter writer = this.getWriter(extentKey);
            Object[] item = (Object[])data[1];
            Double x = (Double)data[2];
            Double y = (Double)data[3];
            writer.beginFeature();
            StringBuilder sb = writer.createPropertysPart(this.geoType, this.propertyFields, item);
            writer.addCoordinates(x.doubleValue(), y.doubleValue(), 1.0);
            writer.setPropertysPart((Object)sb);
            writer.endFeature();
        }
    }

    private void dealWithMultiPoint(List<Object[]> datas) {
        for (Object[] data : datas) {
            String extentKey = (String)data[0];
            ConcurrentVarintWriter writer = this.getWriter(extentKey);
            Object[] item = (Object[])data[1];
            DoubleBuilder geom = (DoubleBuilder)data[2];
            writer.beginFeature();
            StringBuilder sb = writer.createPropertysPart(this.geoType, this.propertyFields, item);
            int size = geom.size();
            for (int i = 0; i < size; i += 2) {
                double x = geom.get(i);
                double y = geom.get(i + 1);
                writer.addCoordinates(x, y, 1.0);
            }
            writer.setPropertysPart((Object)sb);
            writer.endFeature();
        }
    }

    private void dealWithOthers(List<Object[]> datas) {
        for (Object[] data : datas) {
            String extentKey = (String)data[0];
            ConcurrentVarintWriter writer = this.getWriter(extentKey);
            Object[] item = (Object[])data[1];
            List geom = (List)data[2];
            writer.beginFeature();
            StringBuilder sb = writer.createPropertysPart(this.geoType, this.propertyFields, item);
            for (DoubleBuilder doubleBuilder : geom) {
                writer.addCoordinates(doubleBuilder, 1.0);
            }
            writer.setPropertysPart((Object)sb);
            writer.endFeature();
        }
    }

    @Override
    public synchronized void flush() {
        try {
            Set<Map.Entry<String, ConcurrentVarintWriter>> collect = this.tileMap.entrySet();
            HashMap<String, ConcurrentVarintWriter> writerMap = new HashMap<String, ConcurrentVarintWriter>(collect.size());
            for (Map.Entry entry : collect) {
                String key = (String)entry.getKey();
                ConcurrentVarintWriter writer = (ConcurrentVarintWriter)entry.getValue();
                int coordinatesSize = writer.getCoordinatesSize();
                if (coordinatesSize > 3072) {
                    writerMap.put(key, writer);
                    this.tileMap.remove(key);
                    continue;
                }
                if (writer.getUnModifiedNum() > 2 && coordinatesSize == writer.getLastSize()) {
                    writerMap.put(key, writer);
                    this.tileMap.remove(key);
                    continue;
                }
                if (writer.getUnFlushNum() > 10) {
                    writerMap.put(key, writer);
                    this.tileMap.remove(key);
                    continue;
                }
                if (coordinatesSize == writer.getLastSize()) {
                    writer.setUnModifiedNum(writer.getUnModifiedNum() + 1);
                } else {
                    writer.setLastSize(coordinatesSize);
                    writer.setUnModifiedNum(0);
                }
                writer.setUnFlushNum(writer.getUnFlushNum() + 1);
            }
            this.saveThread.execute(() -> {
                this.logger.info("\u5f00\u59cb\u6279\u91cf\u5199\u5165\u74e6\u7247\uff0c\u74e6\u7247\u6570\u91cf\uff1a{}", (Object)writerMap.size());
                this.saveWriterMap(writerMap);
                this.logger.info("\u6279\u91cf\u5199\u5165\u74e6\u7247\u5b8c\u6210\uff0c \u74e6\u7247\u6570\u91cf\uff1a{}", (Object)writerMap.size());
            });
        }
        catch (Exception e) {
            this.e = e;
            this.error = true;
        }
    }

    @Override
    public synchronized void flushAll() {
        this.collectThread.shutdown();
        try {
            this.collectThread.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.collect();
        this.saveWriterMap(this.tileMap);
    }

    private void saveWriterMap(Map<String, ConcurrentVarintWriter> writerMap) {
        ArrayList<Object[]> saveList = new ArrayList<Object[]>(writerMap.size());
        for (String key : writerMap.keySet()) {
            ConcurrentVarintWriter writer = writerMap.get(key);
            byte[] data = writer.getData();
            if (data != null) {
                if (data.length > 0x1000000) {
                    System.out.println(key);
                }
                saveList.add(new Object[]{key, data});
            }
            writer.clear();
        }
        writerMap.clear();
        try {
            this.saver.save(saveList, this.encoder);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ConcurrentVarintWriter getWriter(String extentKey) {
        ConcurrentVarintWriter newWriter;
        ConcurrentVarintWriter writer = this.tileMap.get(extentKey);
        if (writer == null && (newWriter = this.tileMap.putIfAbsent(extentKey, writer = new ConcurrentVarintWriter())) != null) {
            writer = newWriter;
        }
        return writer;
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.saveThread.shutdown();
        this.saveThread.awaitTermination(timeout, unit);
    }
}

