/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.dao;

import com.geoway.vtile.cluster.bean.DistributedTaskBean;
import com.geoway.vtile.exception.NotFoundException;
import com.geoway.vtile.tools.redis.RedisCache;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMetaDao {
    private static Logger logger = LoggerFactory.getLogger(TaskMetaDao.class);
    public final String NAMESPACE = "task";
    private RedisCache redis = new RedisCache();

    public void insert(DistributedTaskBean task) throws Exception {
        this.sync2Redis(task);
    }

    public DistributedTaskBean get(String taskId) throws Exception {
        return this.getFromRedis(taskId);
    }

    public void delete(String taskId) {
        this.redis.remove(this.wrapKey(taskId));
    }

    private String wrapKey(String id) {
        return "task:" + id;
    }

    private DistributedTaskBean getFromRedis(String id) throws Exception {
        try {
            DistributedTaskBean bean = null;
            try {
                String json = (String)this.redis.get(this.wrapKey(id));
                if (null != json) {
                    bean = DistributedTaskBean.fromJson(json);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return bean;
        }
        catch (Exception e) {
            logger.info("redis\u4e2d\u672a\u67e5\u8be2\u5230\u4efb\u52a1\uff1a" + id);
            throw new NotFoundException(id);
        }
    }

    public void sync2Redis(DistributedTaskBean bean) throws Exception {
        String json = bean.toJson();
        this.redis.set(this.wrapKey(bean.getTaskId()), json);
    }

    public List<String> listWorkingTasks() {
        String prefix = "task:";
        List keys = this.redis.scan(prefix);
        List<String> tasks = keys.stream().filter(key -> !StringUtils.isBlank((CharSequence)key) && key.startsWith(prefix)).map(key -> key.substring(prefix.length())).collect(Collectors.toList());
        return tasks;
    }
}

