/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.v4;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.data_source.DataScourceShell;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.geoway.vtile.tiledispatch.consumer.scroll.TileRangeScroll;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.cellv4.MapTileBuilderUnit;
import com.geoway.vtile.transform.cellv4.TileOptimizer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaptileRefreshTask {
    private static Logger logger = LoggerFactory.getLogger(MaptileRefreshTask.class);
    private Client client;
    private IVectorService mapService;
    private String bboxInterested;
    private ExecutorService cutThreadPool;
    private List<MapTileBuilderUnit> cutUnits;
    private MongoTileSaver tileSaver;
    private int beginL;
    private int endL;
    private int stageLevelSpan = 2;
    private boolean cancelled = false;
    private long tsms;

    public IVectorService getRelatedMap() {
        return this.mapService;
    }

    public long getTsms() {
        return this.tsms;
    }

    public void setTsms(long tsms) {
        this.tsms = tsms;
    }

    public MaptileRefreshTask(Client client, IVectorService mapService, String bboxInterested) {
        this.client = client;
        this.mapService = mapService;
        this.bboxInterested = bboxInterested;
    }

    public void setLevels(int levelBegin, int levelEnd, int stageLevelSpan) {
        this.beginL = levelBegin;
        this.endL = levelEnd;
        if (stageLevelSpan <= 0) {
            stageLevelSpan = 2;
        } else if (stageLevelSpan > levelEnd - levelBegin) {
            stageLevelSpan = levelEnd - levelBegin;
        }
        this.stageLevelSpan = stageLevelSpan;
        if (this.endL < this.beginL) {
            throw new RuntimeException("\u4e0d\u5408\u7406\u7684\u5207\u7247\u7ea7\u522b\u8bbe\u7f6e:" + this.beginL + " -> " + this.endL);
        }
    }

    public void prepare() {
        IStorageInfo storageInfo = this.mapService.getStorageInfo();
        if (null == storageInfo) {
            throw new RuntimeException("\u672a\u627e\u5230\u74e6\u7247\u5b58\u50a8\u6e90\u4fe1\u606f\uff01");
        }
        String tileCollectionName = storageInfo.getStorageName();
        String dsrcId = storageInfo.getDataSource().getId();
        DataScourceShell ds = (DataScourceShell)this.client.getDataSourcesManager().get(dsrcId);
        MongodbDataSource tileMogoDS = (MongodbDataSource)ds.getBean();
        this.tileSaver = new MongoTileSaver(tileMogoDS.getUri(), tileCollectionName);
        this.tileSaver.setEnableSharding(true);
        logger.info("VTileHandler \u5f00\u59cb\u521d\u59cb\u5316Saver");
        this.tileSaver.init();
        int nThreads = TileDispatchTaskManager.getPoolThreadCount();
        logger.info("\u5207\u7247\u7ebf\u7a0b\u6c60\u5927\u5c0f\uff1a" + nThreads);
        this.cutThreadPool = new DoubleQueueExecutor(nThreads);
        TileOptimizer tileOptimizer = new TileOptimizer(tileMogoDS.factory().getDao(tileCollectionName));
        if (this.stageLevelSpan == 0) {
            this.stageLevelSpan = 2;
        }
        this.cutUnits = new ArrayList<MapTileBuilderUnit>();
        for (int i = this.beginL; i <= this.endL; ++i) {
            MapTileBuilderUnit cutUnit = new MapTileBuilderUnit(this.mapService, this.cutThreadPool);
            cutUnit.setOptimizer(tileOptimizer);
            cutUnit.setMainLevel(Integer.valueOf(i));
            cutUnit.setDown(this.stageLevelSpan);
            cutUnit.init();
            this.cutUnits.add(cutUnit);
            i += this.stageLevelSpan;
        }
        this.cancelled = false;
    }

    public void process() throws Exception {
        int nStages = this.cutUnits.size();
        TileCutOptions opt = new TileCutOptions();
        for (int i = 0; i < nStages; ++i) {
            MapTileBuilderUnit cutUnit = this.cutUnits.get(i);
            int levelBegin = cutUnit.getMainLevel();
            TileRangeScroll scroll = new TileRangeScroll(levelBegin, this.bboxInterested, this.mapService.getGridTree());
            scroll.init();
            while (scroll.hasNext()) {
                TileLayout layout = scroll.next();
                GridExtent seedGrid = layout.getExtent();
                List tilesData = cutUnit.cut(seedGrid, opt);
                this.saveVTile(seedGrid, tilesData);
                if (!this.cancelled) continue;
                return;
            }
        }
    }

    private void saveVTile(GridExtent extent, List<Object[]> tilesData) {
        String mainGrid = extent.getCodeXYL();
        if (null == tilesData || tilesData.isEmpty()) {
            logger.info("\u7a7a\u74e6\u7247\u533a\uff1a" + mainGrid);
            return;
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info(Log4jUtil.MARKER_DIAG, "\u5199\u5165\u74e6\u7247: {} \u53ca\u4e0b\u7ea7\u5b50\u74e6\u7247\u5171 {} \u5f20", (Object)mainGrid, (Object)tilesData.size());
        }
        try {
            this.tileSaver.replaceAll(tilesData, new TileDataDocumentEncoder());
        }
        catch (Exception ex) {
            logger.error("\u6279\u91cf\u66ff\u6362\u74e6\u7247\u6570\u636e\u5931\u8d25\uff1a" + ex.getMessage() + "\uff0c \u51c6\u5907\u91cd\u8bd5");
            this.tileSaver.replaceAll(tilesData, new TileDataDocumentEncoder());
        }
    }

    public void cancel() {
        this.cancelled = true;
    }
}

