/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell.process;

import com.geoway.vtile.commons.concurrent.BlockThreadPool;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.resources.datatable.MoreThanOneSpatialField;
import com.geoway.vtile.resources.datatable.dao.IMapDAO;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.geofeature.GeoFeature;
import com.geoway.vtile.transform.cache.GeoFeatureLruCache;
import com.geoway.vtile.transform.cell.process.IProcesser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;

public class ProcessList<T> {
    public static boolean userCache = true;
    protected static int CACHE_SIZE = 10000;
    protected static GeoFeatureLruCache<GeoBuffer> GEO_BUFFER_LRU_CACHE = new GeoFeatureLruCache(CACHE_SIZE);
    public static final Integer TASK_EXCECUTOR_NUM = Runtime.getRuntime().availableProcessors() / 2;
    public static final int MAX_QUEUE_SIZE = TASK_EXCECUTOR_NUM * 10;
    protected ITable table;
    protected List<Object> dataArray = new ArrayList<Object>();
    protected int count = 0;
    protected boolean useMultiThread = false;
    protected int max = 10000;
    protected long MIN_CACHE_ITEM_SIZE = 10000L;
    protected IProcesser processer;
    protected Throwable e;
    IMapDAO<?> dao;
    String[] fields;
    ExecutorService executor;

    public ProcessList() {
    }

    public ProcessList(boolean useMultiThread) {
        boolean bl = this.useMultiThread = useMultiThread && GlobalTileSettings.DISABLE_INGRID_MULTITHREAD == false;
        if (this.useMultiThread) {
            this.executor = new BlockThreadPool(TASK_EXCECUTOR_NUM.intValue(), MAX_QUEUE_SIZE);
        }
    }

    public void init(ITable table, IProcesser processer) {
        this.table = table;
        this.processer = processer;
        try {
            this.dao = table.mapDao();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6\u521d\u59cb\u5316\u5f02\u5e38");
        }
        if (this.table.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.oracle || this.table.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.fgdb) {
            this.max = 999;
        } else if (this.table.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.spark) {
            this.max = Integer.MAX_VALUE;
        }
        if (GlobalTileSettings.PG_FETCH_PAGESIZE >= 100 && GlobalTileSettings.PG_FETCH_PAGESIZE <= 100000) {
            this.max = GlobalTileSettings.PG_FETCH_PAGESIZE;
        }
    }

    public void push(Object id) throws Exception {
        this.dataArray.add(id);
        ++this.count;
        if (this.count == this.max) {
            this.end();
        }
    }

    private String createKeyRoot() {
        String keyRoot = this.table.mark();
        return keyRoot;
    }

    public void end() throws Exception {
        if (this.e != null) {
            throw new Exception(this.e);
        }
        ArrayList<Object> dataArray = new ArrayList<Object>(this.dataArray.size());
        dataArray.addAll(this.dataArray);
        this.dataArray.clear();
        this.count = 0;
        if (!this.useMultiThread) {
            this.endBatch(dataArray);
        } else {
            this.executor.execute(() -> {
                try {
                    this.endBatch(dataArray);
                }
                catch (Exception ex) {
                    this.e = ex;
                }
            });
        }
    }

    public void waitEnd() throws Exception {
        if (this.e != null) {
            throw new Exception(this.e);
        }
        if (this.useMultiThread) {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.HOURS);
        }
    }

    private void endBatch(List<Object> dataArray) throws Exception {
        if (dataArray.isEmpty()) {
            return;
        }
        String keyRoot = this.createKeyRoot();
        LinkedList<Object[]> cacheKeyList = new LinkedList<Object[]>();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (int i = 0; i < dataArray.size(); ++i) {
            Object id = dataArray.get(i);
            if (userCache) {
                String key = keyRoot + "@" + id;
                GeoFeature geoFeature = GEO_BUFFER_LRU_CACHE.get(key);
                if (geoFeature != null) {
                    String keyIndex = key + "||" + i;
                    cacheKeyList.add(new Object[]{keyIndex, geoFeature});
                    continue;
                }
                idList.add(id);
                continue;
            }
            idList.add(id);
        }
        if (idList.isEmpty() && cacheKeyList.isEmpty()) {
            return;
        }
        Object[] idArr = idList.stream().toArray();
        List<Object[]> dataArr = new ArrayList();
        if (!idList.isEmpty()) {
            QueryFilter filter = new QueryFilter();
            if (this.fields != null) {
                filter.setOutputFieldNames(this.fields);
            }
            filter.addFilter(this.table.getIdField(), Constants.OPERATION.IN, idArr);
            dataArr = this.dao.queryArray(filter, Integer.valueOf(1000));
        }
        if (this.fields == null) {
            this.fields = this.table.getFields();
        }
        String idField = this.table.getIdField();
        String spatialField = null;
        try {
            spatialField = this.table.spatialInfo().getSpatialField();
        }
        catch (MoreThanOneSpatialField e) {
            e.printStackTrace();
        }
        final int idIndex = ArrayUtils.indexOf((Object[])this.fields, (Object)idField);
        int spatialIndex = ArrayUtils.indexOf((Object[])this.fields, (Object)spatialField);
        if (userCache) {
            for (Object[] data : dataArr) {
                Geom geom = (Geom)data[spatialIndex];
                geom.changeType(Constants.SPATIAL_TYPE.geoBuffer);
                GeoBuffer geoBuffer = geom.toGeoBuffer();
                Object id = data[idIndex];
                String key = keyRoot + "@" + String.valueOf(id);
                GeoFeature geoFeature = GEO_BUFFER_LRU_CACHE.get(key);
                if (geoFeature != null || (long)geoBuffer.getCoordinateCount() <= this.MIN_CACHE_ITEM_SIZE) continue;
                geoFeature = new GeoFeature(data, (Object)geoBuffer);
                GEO_BUFFER_LRU_CACHE.put(key, geoFeature);
            }
            for (int i = 0; i < cacheKeyList.size(); ++i) {
                String keyIndex = (String)((Object[])cacheKeyList.get(i))[0];
                int index = Integer.valueOf(keyIndex.split("\\|\\|")[1]);
                GeoFeature geoFeature = (GeoFeature)((Object[])cacheKeyList.get(i))[1];
                dataArr.add(index, geoFeature.getProperty());
            }
            if ((this.table.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.postgreSQL || this.table.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.kingbase) && "Integer".equalsIgnoreCase(this.table.idFieldType().name())) {
                Collections.sort(dataArr, new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] o1, Object[] o2) {
                        Integer id1 = (Integer)o1[idIndex];
                        Integer id2 = (Integer)o2[idIndex];
                        return id1.compareTo(id2);
                    }
                });
            }
        }
        this.processer.process(dataArr, this.fields, idIndex, spatialIndex);
    }

    public void setFields(String[] fields) {
        this.fields = fields;
    }

    public static void clearCache() {
        GEO_BUFFER_LRU_CACHE.clear();
    }
}

