/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.service;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.diagnose.ProfilingUtil;
import com.geoway.vtile.exception.ServerException;
import com.geoway.vtile.manager.cell.ITileDataCellManager;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.service.httpstatistic.RealtimeTileReqeustStatis;
import com.geoway.vtile.transform.service.IAreaStatisService;
import com.geoway.vtile.transform.service.IDataSetService;
import com.geoway.vtile.transform.service.ITileDataService;
import com.geoway.vtile.transform.service.impl.AreaStatisService;
import com.geoway.vtile.transform.service.impl.DataSetService;
import com.geoway.vtile.transform.service.impl.TileDataService;
import com.geoway.vtile.transform.tools.NamedThreadFactory;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDataCellManager
implements ITileDataCellManager {
    private Logger logger = LoggerFactory.getLogger(TileDataCellManager.class);
    protected Client client;
    protected IVectorServiceManager vectorServiceManager;
    protected ExecutorService taskExecutorService;
    protected IAreaStatisService areaStatisService;
    protected ITileDataService tileDataService;
    protected IDataSetService dataSetService;
    private ConcurrentHashMap<String, Boolean> _cancelMap;
    private ConcurrentHashMap<String, RealtimeTileReqeustStatis> _statisMap;
    private ConcurrentHashMap<String, Long> _frozenServices;
    private static final int FROZEN_TIMEOUT = 0x6DDD00;
    private static final int MAX_FAILS_TO_FROZEN = 10;
    private static final int MAX_FEATURES_LIMIT = 30000;

    public TileDataCellManager() {
        int executorsNum = Runtime.getRuntime().availableProcessors() / 2;
        int customNum = GlobalTileSettings.REALTIME_TILE_THREAD_COUNT;
        executorsNum = customNum > 0 ? customNum : (executorsNum < 1 ? 1 : executorsNum);
        this.taskExecutorService = Executors.newFixedThreadPool(executorsNum, new NamedThreadFactory("TileManagerThread"));
        this.areaStatisService = new AreaStatisService();
        this.tileDataService = new TileDataService(executorsNum);
        this.dataSetService = new DataSetService();
        this.logger.info(Log4jUtil.MARKER_DIAG, "RealtimeTileManager thread pool size: " + executorsNum);
        this._cancelMap = new ConcurrentHashMap();
        this._statisMap = new ConcurrentHashMap();
        this._frozenServices = new ConcurrentHashMap();
    }

    public void getData(String serverName, String layerName, String type, String gridstr, Integer x, Integer y, Integer level, String filter, Boolean _cut, Integer start, Integer limit, ChannelHandlerContext ctx, byte[] markByte) throws Exception {
        CompletableFuture.supplyAsync(() -> {
            String reqId = new String(markByte);
            try {
                if (this.checkCancelled(reqId, serverName)) {
                    return null;
                }
                if (this.checkFrozen(serverName)) {
                    String errinfo = "\u670d\u52a1" + serverName + "\u5df2\u88ab\u51bb\u7ed3";
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, errinfo.getBytes("utf-8")})));
                    return null;
                }
                IVectorService service = (IVectorService)this.vectorServiceManager.get(serverName);
                if (service == null) {
                    throw new ServerException("\u672a\u627e\u5230\u670d\u52a1:" + serverName);
                }
                int nLimit = limit;
                if (nLimit <= 0) {
                    nLimit = 30000;
                }
                RealtimeTileReqeustStatis profiling = null;
                if (ProfilingUtil.isProfilingEnabled()) {
                    profiling = this.getRealtimeStatis(serverName);
                    profiling.requestCount.incrementAndGet();
                }
                long perfStart = 0L;
                if (Log4jUtil.isDiagnoseEnable()) {
                    this.logger.info(Log4jUtil.MARKER_DIAG, "\u76f4\u8fde\u83b7\u53d6{}\u6570\u636e({}_{}_{}) service:{}, layer:{}, start:{}, limit:{}", new Object[]{type, x, y, level, serverName, layerName, start, nLimit});
                    perfStart = System.currentTimeMillis();
                }
                byte[] data = this.tileDataService.getData(service, layerName, type, gridstr, x, y, level, filter, _cut, start, nLimit);
                if (Log4jUtil.isDiagnoseEnable() && null != data) {
                    long cost = System.currentTimeMillis() - perfStart;
                    this.logger.info(Log4jUtil.MARKER_DIAG, "({}_{}_{})\u8fd4\u56de{}\u6570\u636e\u5927\u5c0f: {} KB, cost: {} ms", new Object[]{x, y, level, type, String.format("%.3f", (double)data.length * 1.0 / 1024.0), cost});
                    if (null != profiling) {
                        profiling.updateMaxTimecost(cost);
                    }
                }
                if (this.checkCancelled(reqId, serverName)) {
                    return null;
                }
                if (data == null || data.length == 0) {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}})));
                } else {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}, data})));
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                String stackTrace = null;
                try (PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    stackTrace = sw.toString();
                    this.logger.error(Log4jUtil.MARKER_DIAG, "getData\u5f02\u5e38." + e.getMessage(), (Throwable)e);
                }
                this.printPoolState();
                this.captureErrorService(serverName, x, y, level);
                if (this.checkCancelled(reqId, null)) {
                    return null;
                }
                try {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            if (((ThreadPoolExecutor)this.taskExecutorService).getQueue().size() > 100) {
                this.printPoolState();
            }
            return null;
        }, this.taskExecutorService);
    }

    public void getDataSetData(String serverName, String dataLayerName, String filterStr, String spatialFilter, String fields, String ids, Integer start, Integer limit, Integer level, Boolean withGeometry, Boolean withExtent, Boolean withCenter, ChannelHandlerContext ctx, byte[] markByte) {
        CompletableFuture.supplyAsync(() -> {
            try {
                int nLimit;
                IVectorService service = (IVectorService)this.vectorServiceManager.get(serverName);
                if (service == null) {
                    throw new ServerException("\u672a\u627e\u5230\u670d\u52a1:" + serverName);
                }
                String svckey = serverName + "/" + dataLayerName;
                RealtimeTileReqeustStatis profiling = null;
                if (ProfilingUtil.isProfilingEnabled()) {
                    profiling = this.getRealtimeStatis(svckey);
                    profiling.requestCount.incrementAndGet();
                }
                if ((nLimit = limit.intValue()) <= 0) {
                    nLimit = 30000;
                }
                long perfStart = 0L;
                if (Log4jUtil.isDiagnoseEnable()) {
                    this.logger.info(Log4jUtil.MARKER_DIAG, "\u76f4\u8fde\u83b7\u53d6\u7a7a\u95f4\u8981\u7d20\u6570\u636e service: {}, layer: {}, filter: {}, level: {}, start: {}, limit: {}, withGeometry: {}.", new Object[]{serverName, dataLayerName, filterStr, level, start, nLimit, withGeometry});
                    perfStart = System.currentTimeMillis();
                }
                byte[] data = this.dataSetService.getDataSetData(service, dataLayerName, filterStr, spatialFilter, fields, ids, start, nLimit, level, withGeometry, withExtent, withCenter);
                if (Log4jUtil.isDiagnoseEnable() && null != data) {
                    long cost = System.currentTimeMillis() - perfStart;
                    this.logger.info(Log4jUtil.MARKER_DIAG, "\u8981\u7d20\u67e5\u8be2\u83b7\u53d6DataSet\u6570\u636e\u5927\u5c0f: {} KB, cost: {} ms", (Object)String.format("%.3f", (double)data.length * 1.0 / 1024.0), (Object)cost);
                    if (null != profiling) {
                        profiling.updateMaxTimecost(cost);
                    }
                }
                if (data == null || data.length == 0) {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}})));
                } else {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}, data})));
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                String stackTrace = null;
                try (PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    stackTrace = sw.toString();
                    this.logger.error(Log4jUtil.MARKER_DIAG, "\u8981\u7d20\u67e5\u8be2\u5f02\u5e38." + e.getMessage(), (Throwable)e);
                    String svckey = serverName + "/" + dataLayerName;
                    RealtimeTileReqeustStatis profiling = null;
                    if (ProfilingUtil.isProfilingEnabled()) {
                        profiling = this.getRealtimeStatis(svckey);
                        profiling.exceptionCount.incrementAndGet();
                    }
                }
                try {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            return null;
        }, this.taskExecutorService);
    }

    public void getDataSetDataCount(String serverName, String dataLayerName, String filterStr, String spatialFilter, String ids, Integer level, ChannelHandlerContext ctx, byte[] markByte) throws Exception {
        CompletableFuture.supplyAsync(() -> {
            try {
                IVectorService service = (IVectorService)this.vectorServiceManager.get(serverName);
                if (service == null) {
                    throw new ServerException("\u672a\u627e\u5230\u670d\u52a1:" + serverName);
                }
                byte[] data = this.dataSetService.getDataSetDataCount(service, dataLayerName, filterStr, spatialFilter, ids, level);
                if (data == null || data.length == 0) {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}})));
                } else {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}, data})));
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                String stackTrace = null;
                try (PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    stackTrace = sw.toString();
                }
                try {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            return null;
        }, this.taskExecutorService);
    }

    public byte[] getDataSetInfo(String serverName, String dataLayerName, Integer level) throws Exception {
        IVectorService service = (IVectorService)this.vectorServiceManager.get(serverName);
        if (service == null) {
            throw new ServerException("\u672a\u627e\u5230\u670d\u52a1:" + serverName);
        }
        return this.dataSetService.getDataSetInfo(service, dataLayerName, level);
    }

    public void getAreaAsync(String serverName, String dataLayerName, String filterStr, String spatialFilter, String fields, ChannelHandlerContext ctx, byte[] markByte) {
        CompletableFuture.supplyAsync(() -> {
            try {
                if (StringUtils.isEmpty((CharSequence)spatialFilter)) {
                    throw new ServerException("\u7edf\u8ba1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                IVectorService service = (IVectorService)this.vectorServiceManager.get(serverName);
                if (service == null) {
                    throw new ServerException("\u672a\u627e\u5230\u670d\u52a1:" + serverName);
                }
                byte[] data = this.areaStatisService.getArea(service, dataLayerName, filterStr, spatialFilter, fields, null);
                if (data == null || data.length == 0) {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}})));
                } else {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}, data})));
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                String stackTrace = null;
                try (PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    stackTrace = sw.toString();
                }
                try {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            return null;
        }, this.taskExecutorService);
    }

    public byte[] getArea(String serverName, String dataLayerName, String filterStr, String spatialFilter, String fields, String cacheKey) throws Exception {
        if (StringUtils.isEmpty((CharSequence)spatialFilter)) {
            throw new ServerException("\u7edf\u8ba1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IVectorService service = (IVectorService)this.vectorServiceManager.get(serverName);
        if (service == null) {
            throw new ServerException("\u672a\u627e\u5230\u670d\u52a1:" + serverName);
        }
        return this.areaStatisService.getArea(service, dataLayerName, filterStr, spatialFilter, fields, cacheKey);
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void init() {
        this.vectorServiceManager = this.client.getVectorServiceManager();
    }

    public void getRealtimeProfilingData(String serverName, ChannelHandlerContext ctx, byte[] markByte) {
        CompletableFuture.supplyAsync(() -> {
            try {
                HashMap<String, Object> profList = new HashMap<String, Object>();
                if (StringUtils.isEmpty((CharSequence)serverName)) {
                    profList.put("realtimeRequestStatis", this._statisMap);
                    profList.put("frozenServices", this._frozenServices);
                    ThreadPoolExecutor tpool = (ThreadPoolExecutor)this.taskExecutorService;
                    HashMap<String, Integer> poolStat = new HashMap<String, Integer>();
                    poolStat.put("poolSize", tpool.getCorePoolSize());
                    poolStat.put("runingCount", tpool.getActiveCount());
                    poolStat.put("waitingCount", tpool.getQueue().size());
                    poolStat.put("finishedCount", (int)tpool.getCompletedTaskCount());
                    profList.put("threadPool", poolStat);
                } else {
                    RealtimeTileReqeustStatis profiling = null;
                    if (this._statisMap.containsKey(serverName)) {
                        profiling = this._statisMap.get(serverName);
                    }
                    if (null != profiling) {
                        profList.put(serverName, profiling);
                    } else {
                        profList.put("error", "\u672a\u627e\u5230\u670d\u52a1\u7684\u7edf\u8ba1\u4fe1\u606f\uff1a" + serverName);
                    }
                }
                String profilingJson = JSON.toJSONString(profList);
                byte[] bytes = profilingJson.getBytes("utf-8");
                ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}, bytes})));
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                String stackTrace = null;
                try (PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    stackTrace = sw.toString();
                    this.logger.error(Log4jUtil.MARKER_DIAG, "getRealtimeProfilingData\u5f02\u5e38." + e.getMessage(), (Throwable)e);
                }
                try {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            return null;
        });
    }

    public void printPoolState() {
        ThreadPoolExecutor tpool = (ThreadPoolExecutor)this.taskExecutorService;
        int poolSize = tpool.getCorePoolSize();
        int waitingCount = tpool.getQueue().size();
        long finishedCount = tpool.getCompletedTaskCount();
        if (Log4jUtil.isDiagnoseEnable()) {
            String strStat = String.format("\u76f4\u8fde\u7ebf\u7a0b\u6c60\u5f53\u524d\u72b6\u6001\uff1a[ \u7ebf\u7a0b\u6c60\u5927\u5c0f %d  | \u6d3b\u52a8\u7ebf\u7a0b\u6570(\u8fd0\u884c\u4efb\u52a1\u6570) %d  | \u6392\u961f\u4efb\u52a1\u6570 %d  | \u5df2\u5b8c\u6210\u4efb\u52a1\u6570 %d  ]", poolSize, tpool.getActiveCount(), waitingCount, finishedCount);
            if (waitingCount > poolSize) {
                this.logger.warn(Log4jUtil.MARKER_DIAG, strStat);
            } else {
                this.logger.info(Log4jUtil.MARKER_DIAG, strStat);
            }
        }
    }

    public void cancelRequest(ChannelHandlerContext ctx, byte[] markByte) {
        String reqId = new String(markByte);
        if (Log4jUtil.isDiagnoseEnable()) {
            this.logger.info("\u5df2\u8bb0\u5f55\u5f85\u53d6\u6d88\u7684\u8bf7\u6c42\uff1a" + reqId);
        }
        this._cancelMap.put(reqId, true);
    }

    public void recoverFrozenService(String serviceName, ChannelHandlerContext ctx, byte[] markByte) {
        boolean bok = false;
        String msg = "";
        try {
            if (!ProfilingUtil.isProfilingEnabled()) {
                msg = "profiling\u672a\u5f03\u7528\uff0c\u65e0\u9700\u89e3\u51bb";
            } else {
                boolean has;
                boolean bl = has = this._frozenServices.size() > 0 && this._frozenServices.containsKey(serviceName);
                if (!has && !"all".equalsIgnoreCase(serviceName)) {
                    msg = "\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u9700\u8981\u89e3\u51bb\u7684\u670d\u52a1\uff1a" + serviceName;
                    this.logger.error(msg);
                } else {
                    if (has) {
                        this._frozenServices.remove(serviceName);
                    } else if ("all".equalsIgnoreCase(serviceName)) {
                        this._frozenServices.clear();
                    }
                    msg = "\u5df2\u6062\u590d\u51bb\u7ed3\u7684\u670d\u52a1\uff1a" + serviceName;
                    this.logger.info(msg);
                    bok = true;
                }
            }
        }
        catch (Exception e) {
            msg = "\u6062\u590d\u51bb\u7ed3\u670d\u52a1\u65f6\u51fa\u9519\uff1a" + e.getMessage();
            this.logger.info(msg);
        }
        byte flag = (byte)(bok ? 1 : 0);
        try {
            ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {flag}, msg.getBytes("utf-8")})));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkCancelled(String reqId, String serviceName) {
        boolean has;
        boolean bl = has = this._cancelMap.size() > 0 && this._cancelMap.containsKey(reqId);
        if (has) {
            this._cancelMap.remove(reqId);
            if (Log4jUtil.isDiagnoseEnable()) {
                this.logger.info("\u5df2\u53d6\u6d88\u76f4\u8fde\u8bf7\u6c42\uff1a" + reqId);
            }
            if (!StringUtils.isEmpty((CharSequence)serviceName)) {
                this.captureTimeoutCancelService(serviceName);
            }
        }
        return has;
    }

    private boolean checkFrozen(String serviceName) {
        boolean has;
        if (!ProfilingUtil.isProfilingEnabled()) {
            return false;
        }
        boolean bl = has = this._frozenServices.size() > 0 && this._frozenServices.containsKey(serviceName);
        if (has) {
            long frozenTime = this._frozenServices.get(serviceName);
            if (System.currentTimeMillis() - frozenTime > 0x6DDD00L) {
                this.logger.info("\u5df2\u6062\u590d\u51bb\u7ed3\u7684\u670d\u52a1\uff1a" + serviceName);
                this._frozenServices.remove(serviceName);
                has = false;
            }
        }
        return has;
    }

    private void captureErrorService(String serverName, Integer x, Integer y, Integer level) {
        if (!ProfilingUtil.isProfilingEnabled()) {
            return;
        }
        RealtimeTileReqeustStatis profiling = this.getRealtimeStatis(serverName);
        int failsCount = profiling.exceptionCount.incrementAndGet();
        if (failsCount > 10) {
            this._frozenServices.put(serverName, System.currentTimeMillis());
        }
    }

    private void captureTimeoutCancelService(String serverName) {
        if (!ProfilingUtil.isProfilingEnabled()) {
            return;
        }
        RealtimeTileReqeustStatis profiling = this.getRealtimeStatis(serverName);
        profiling.timeoutCount.incrementAndGet();
    }

    private RealtimeTileReqeustStatis getRealtimeStatis(String serviceName) {
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            return null;
        }
        RealtimeTileReqeustStatis profiling = null;
        if (!this._statisMap.containsKey(serviceName)) {
            profiling = new RealtimeTileReqeustStatis();
            profiling.serviceName = serviceName;
            this._statisMap.put(serviceName, profiling);
        } else {
            profiling = this._statisMap.get(serviceName);
        }
        return profiling;
    }

    public void getDatasourcePoolMetrics(ChannelHandlerContext ctx, byte[] markByte) {
        CompletableFuture.supplyAsync(() -> {
            try {
                HashMap poolMetrics = this.client.getPoolMetrics();
                String profilingJson = JSON.toJSONString((Object)poolMetrics);
                byte[] bytes = profilingJson.getBytes("utf-8");
                ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}, bytes})));
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                String stackTrace = null;
                try (PrintWriter pw = new PrintWriter(sw);){
                    e.printStackTrace(pw);
                    stackTrace = sw.toString();
                    this.logger.error(Log4jUtil.MARKER_DIAG, "getDatasourcePoolMetrics\u5f02\u5e38." + e.getMessage(), (Throwable)e);
                }
                try {
                    ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            return null;
        });
    }
}

