/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.vtile.exception.ServerException;
import com.geoway.vtile.model.data_service.IDataService;
import com.geoway.vtile.model.data_service.tileInfo.IAreaTileInfo;
import com.geoway.vtile.model.data_service.tileInfo.IFeatureTileInfo;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.resources.MongodbDao;
import com.geoway.vtile.resources.MongodbFactory;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.resources.datatable.IField;
import com.geoway.vtile.resources.inmemoryold.IMapFilter;
import com.geoway.vtile.resources.inmemoryold.QueryFilterToInMemory;
import com.geoway.vtile.spatial.geofeature.GeoFeature;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.ScanLine;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.bean.ExtentGeometry;
import com.geoway.vtile.transform.bean.FeatureTile;
import com.geoway.vtile.transform.bean.RtreeJtsGeometry;
import com.geoway.vtile.transform.dataholder.IMetricsHolder;
import com.geoway.vtile.transform.dataholder.bucket.BucketHolder;
import com.geoway.vtile.transform.dataholder.metrics.ObjectArrayMetricsHolder;
import com.geoway.vtile.transform.service.IAreaStatisService;
import com.geoway.vtile.transform.task.ExtentGeometryForkTask;
import com.geoway.vtile.transform.tools.CTerranArea;
import com.geoway.vtile.transform.utils.GeometryUtils;
import com.geoway.vtile.type.Type;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCursor;
import io.protostuff.ProtostuffIOUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.operation.overlay.OverlayOp;

public class AreaStatisService
implements IAreaStatisService {
    public static final double[] areas = new double[]{518400.0, 129600.0, 32400.0, 8100.0, 2025.0, 506.25, 126.5625, 31.640625, 7.91015625, 1.9775390625, 0.494384765625, 0.12359619140625, 0.0308990478515625, 0.007724761962890625, 0.0019311904907226562, 4.8279762268066406E-4, 1.2069940567016602E-4, 3.0174851417541504E-5, 7.543712854385376E-6, 1.885928213596344E-6};
    public static final GeometryFactory geometryFactory = new GeometryFactory();
    public static final ThreadLocal<ForkJoinPool> forkLocal = new ThreadLocal();
    public static final String METRICS = "@value";
    public static final String DELIMITER = "@#";

    @Override
    public byte[] getArea(IVectorService service, String layerName, String filterStr, String spatialFilter, String fields, String cacheKey) throws Exception {
        Object[] allGroupFields;
        IDataSet dataSet = this.getDataSet(layerName, null, service);
        IDataService dataService = dataSet.getDataService();
        IFeatureTileInfo featureTileInfo = dataService.getFeatureTileInfo();
        Object[] fieldsArr = allGroupFields = featureTileInfo.getGroupFields();
        if (fields != null) {
            fieldsArr = fields.split(",");
        }
        if (fieldsArr.length > allGroupFields.length) {
            throw new ServerException("fields length can not large than group fields length");
        }
        int fieldsLength = fieldsArr.length;
        for (int i = 0; i < fieldsLength; ++i) {
            if (ArrayUtils.contains((Object[])allGroupFields, (Object)fieldsArr[i])) continue;
            throw new ServerException("fields " + (String)fieldsArr[i] + " must be in group fields " + Arrays.toString(allGroupFields));
        }
        BucketHolder root = this.getCacheByKey(cacheKey);
        if (root == null) {
            root = this.getArea(service, layerName, filterStr, spatialFilter, fields);
        }
        if (StringUtils.isNotEmpty((CharSequence)filterStr) || StringUtils.isNotEmpty((CharSequence)fields)) {
            int size = fieldsArr.length;
            Type[] types = new Type[size];
            for (int i = 0; i < size; ++i) {
                types[i] = ((IField)dataService.getFieldMap().get(fieldsArr[i])).getType();
            }
            root = this.filter(root, (String[])allGroupFields, (String[])fieldsArr, types, filterStr);
        }
        JSONObject result = new JSONObject();
        result.put("groupFields", (Object)StringUtils.join((Object[])fieldsArr, (String)","));
        result.put("data", (Object)root);
        return result.toJSONString().getBytes("utf-8");
    }

    private BucketHolder getCacheByKey(String cacheKey) {
        return null;
    }

    public BucketHolder getArea(IVectorService service, String layerName, String filterStr, String spatialFilter, String fields) throws Exception {
        IDataSet dataSet = this.getDataSet(layerName, null, service);
        if (dataSet == null) {
            throw new RuntimeException("\u6ca1\u6709\u5728\u670d\u52a1 " + (String)service.getId() + " \u4e2d\u627e\u5230\u56fe\u5c42 " + layerName);
        }
        IDataService dataService = dataSet.getDataService();
        IAreaTileInfo areaTileInfo = dataService.getAreaTileInfo();
        if (areaTileInfo == null) {
            throw new ServerException("\u7f3a\u5c11\u7edf\u8ba1\u7f13\u5b58\u4fe1\u606f");
        }
        IFeatureTileInfo featureTileInfo = dataService.getFeatureTileInfo();
        if (featureTileInfo == null) {
            throw new ServerException("\u7f3a\u5c11\u8981\u7d20\u74e6\u7247\u9884\u70ed\u4fe1\u606f");
        }
        Integer startLevel = areaTileInfo.getStartLevel();
        int endLevel = areaTileInfo.getEndLevel();
        Geometry region = GeometryUtils.getGeometryFromWkt(spatialFilter);
        long start = System.currentTimeMillis();
        List<ExtentGeometry> extents = this.getRootExtentByEnv(region, service.getGridTree(), endLevel);
        Integer rootLevel = extents.get(0).getExtent().getLevel();
        if (rootLevel != endLevel) {
            extents = endLevel - rootLevel > 5 ? this.getExtentByRoot(extents, endLevel, service.getGridTree()) : this.getExtentByRoot(extents, rootLevel, startLevel, endLevel, service.getGridTree());
        }
        System.out.println("split region:" + (System.currentTimeMillis() - start));
        List<String> coveredTileList = extents.stream().filter(extentGeometry -> extentGeometry.isFull()).map(extentGeometry -> extentGeometry.getExtent().getKey()).collect(Collectors.toList());
        start = System.currentTimeMillis();
        List<BucketHolder> bucketHolders = this.getAreaFromStatisTile(areaTileInfo.getStorageInfo(), coveredTileList);
        System.out.println("query cache:" + (System.currentTimeMillis() - start));
        BucketHolder tileRoot = BucketHolder.mergeBucketsList(bucketHolders);
        Map<String, ExtentGeometry> intersectExtentsMap = extents.stream().filter(extentGeometry -> !extentGeometry.isFull()).collect(Collectors.toMap(extentGeometry -> extentGeometry.getExtent().getKey(), extentGeometry -> extentGeometry));
        BucketHolder dataRoot = this.getAreaFromFeatureTile(featureTileInfo, intersectExtentsMap, region);
        if (tileRoot == null && dataRoot == null) {
            return null;
        }
        if (tileRoot == null) {
            return dataRoot;
        }
        if (dataRoot != null) {
            BucketHolder.mergeBucket(tileRoot, dataRoot);
        }
        return tileRoot;
    }

    public BucketHolder filter(BucketHolder bucketHolder, String[] allFields, String[] fields, Type[] types, String filter) throws Exception {
        List<Object> items = this.transform2Items(bucketHolder, allFields, -1);
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            QueryFilter queryFilter = new QueryFilter();
            queryFilter.addSQL(filter, Constants.RELATION.AND);
            HashMap<String, Type> mapType = new HashMap<String, Type>();
            int size = fields.length;
            for (int i = 0; i < size; ++i) {
                mapType.put(fields[i], types[i]);
            }
            IMapFilter mapFilter = new QueryFilterToInMemory(queryFilter, mapType).toMapFilter();
            items = items.stream().filter(item -> {
                try {
                    return mapFilter.isSave((Map)item);
                }
                catch (Exception e) {
                    throw new ServerException("\u4e8c\u6b21\u8fc7\u6ee4\u5931\u8d25");
                }
            }).collect(Collectors.toList());
        }
        if (fields != null) {
            Map<String, List<JSONObject>> groupMap = items.stream().collect(Collectors.groupingBy(item -> Arrays.stream(fields).map(field -> item.get(field).toString()).collect(Collectors.joining(DELIMITER))));
            items = groupMap.values().stream().map(group -> {
                JSONObject first = (JSONObject)group.get(0);
                first.put(METRICS, (Object)group.stream().collect(Collectors.summingDouble(item -> (Double)item.get((Object)METRICS))));
                return first;
            }).collect(Collectors.toList());
        }
        return this.mergeItems(items, fields);
    }

    private BucketHolder mergeItems(List<JSONObject> items, String[] fields) throws UnsupportedEncodingException {
        List collect = items.stream().map(item -> {
            Object[] properties = new Object[fields.length];
            int size = fields.length;
            for (int i = 0; i < size; ++i) {
                properties[i] = item.get((Object)fields[i]);
            }
            return new ObjectArrayMetricsHolder(item.getDouble(METRICS), properties);
        }).collect(Collectors.toList());
        BucketHolder dataRoot = null;
        if (collect != null && !collect.isEmpty()) {
            dataRoot = BucketHolder.createBucket((IMetricsHolder)collect.get(0));
            int size = collect.size();
            if (size > 1) {
                for (int i = 1; i < size; ++i) {
                    BucketHolder.mergeBuckets(dataRoot, (IMetricsHolder)collect.get(i));
                }
            }
        }
        return dataRoot;
    }

    private List<JSONObject> transform2Items(BucketHolder bucketHolder, String[] allFields, int fieldIndex) {
        Collection<BucketHolder> bucketsList = bucketHolder.getBucketsList();
        if (bucketsList == null || bucketsList.isEmpty()) {
            JSONObject item = new JSONObject();
            item.put(allFields[fieldIndex], (Object)bucketHolder.getName());
            item.put(METRICS, (Object)bucketHolder.getNumber());
            return Collections.singletonList(item);
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        Iterator<BucketHolder> iterator = bucketsList.iterator();
        while (iterator.hasNext()) {
            List<JSONObject> sublist = this.transform2Items(iterator.next(), allFields, fieldIndex + 1);
            if (fieldIndex >= 0) {
                for (JSONObject jsonObject : sublist) {
                    jsonObject.put(allFields[fieldIndex], (Object)bucketHolder.getName());
                }
            }
            list.addAll(sublist);
        }
        return list;
    }

    private List<BucketHolder> getAreaFromStatisTile(IStorageInfo areaStorageInfo, Collection<String> ids) {
        MongodbDataSource mongodbDataSource = (MongodbDataSource)areaStorageInfo.getDataSource().getBean();
        MongodbFactory factory = mongodbDataSource.factory();
        MongodbDao dao = factory.getDao(areaStorageInfo.getStorageName());
        BasicDBObject query = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        values.addAll(ids);
        query.put((Object)"fkey", (Object)new BasicDBObject("$in", (Object)values));
        MongoCursor documentMongoCursor = dao.find((Bson)query);
        ArrayList<BucketHolder> tileBuckets = new ArrayList<BucketHolder>();
        Document doc = null;
        while (documentMongoCursor.hasNext()) {
            doc = (Document)documentMongoCursor.next();
            byte[] content = ((Binary)doc.get((Object)"fstatis")).getData();
            BucketHolder holder = (BucketHolder)BucketHolder.schema.newMessage();
            ProtostuffIOUtil.mergeFrom((byte[])content, (Object)holder, BucketHolder.schema);
            tileBuckets.add(holder);
        }
        return tileBuckets;
    }

    private BucketHolder getAreaFromFeatureTile(IFeatureTileInfo featureTileInfo, Map<String, ExtentGeometry> intersectsMap, Geometry region) throws IOException, ParseException {
        IStorageInfo featureStorageInfo = featureTileInfo.getStorageInfo();
        int groupFieldsNum = featureTileInfo.getGroupFields().length;
        MongodbDataSource mongodbDataSource = (MongodbDataSource)featureStorageInfo.getDataSource().getBean();
        long start = System.currentTimeMillis();
        MongodbFactory factory = mongodbDataSource.factory();
        MongodbDao dao = factory.getDao(featureStorageInfo.getStorageName());
        BasicDBObject query = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        values.addAll(intersectsMap.keySet());
        query.put((Object)"fkey", (Object)new BasicDBObject("$in", (Object)values));
        BasicDBObject fields = new BasicDBObject();
        fields.put((Object)"fdata1", (Object)1);
        fields.put((Object)"fkey", (Object)1);
        MongoCursor documentMongoCursor = dao.find((Bson)query, (Bson)fields);
        Document doc = null;
        ArrayList<AbstractMap.SimpleEntry<String, byte[]>> contentEntries = new ArrayList<AbstractMap.SimpleEntry<String, byte[]>>(values.size());
        while (documentMongoCursor.hasNext()) {
            doc = (Document)documentMongoCursor.next();
            String key = doc.getString((Object)"fkey");
            byte[] content = ((Binary)doc.get((Object)"fdata1")).getData();
            if (content == null || content.length == 0) continue;
            contentEntries.add(new AbstractMap.SimpleEntry<String, byte[]>(key, content));
        }
        System.out.println("tiles:" + contentEntries.size());
        System.out.println("query edge data:" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        List collect = contentEntries.parallelStream().flatMap(contentEntry -> {
            String key = (String)contentEntry.getKey();
            byte[] content = (byte[])contentEntry.getValue();
            FeatureTile featureTile = null;
            try {
                featureTile = new FeatureTile(content);
            }
            catch (IOException e) {
                throw new ServerException(e.getMessage());
            }
            Geometry extentIntersectRegion = ((ExtentGeometry)intersectsMap.get(key)).getGeometry();
            RtreeJtsGeometry rgeom = new RtreeJtsGeometry(extentIntersectRegion);
            List<GeoFeature> features = featureTile.search(rgeom);
            ArrayList<AbstractMap.SimpleEntry<String, GeoFeature>> subEntries = new ArrayList<AbstractMap.SimpleEntry<String, GeoFeature>>(features.size());
            for (GeoFeature feature : features) {
                subEntries.add(new AbstractMap.SimpleEntry<String, GeoFeature>(key, feature));
            }
            return subEntries.stream();
        }).map(entry -> {
            String key = (String)entry.getKey();
            GeoFeature feature = (GeoFeature)entry.getValue();
            Object[] props = feature.getProperty();
            int propLen = props.length;
            double[] bbox = feature.getBbox();
            Geometry bboxGeometry = geometryFactory.toGeometry(new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]));
            Geometry extentIntersectsGeom = ((ExtentGeometry)intersectsMap.get(key)).getGeometry();
            double standardArea = Double.valueOf((String)props[propLen - 1]);
            if (bboxGeometry.coveredBy(extentIntersectsGeom)) {
                return new ObjectArrayMetricsHolder(standardArea, ArrayUtils.subarray((Object[])props, (int)0, (int)groupFieldsNum));
            }
            Geometry feaGeo = feature.getGeometry();
            if (feaGeo.coveredBy(extentIntersectsGeom)) {
                return new ObjectArrayMetricsHolder(standardArea, ArrayUtils.subarray((Object[])props, (int)0, (int)groupFieldsNum));
            }
            Geometry intersection = feaGeo.intersection(extentIntersectsGeom);
            if (!intersection.isEmpty()) {
                double area = CTerranArea.CalculateTerranArea(intersection);
                if (featureTileInfo.getAreaField() != null) {
                    double totalArea = Double.valueOf((String)props[propLen - 2]);
                    area = area / totalArea * standardArea;
                }
                return new ObjectArrayMetricsHolder(area, ArrayUtils.subarray((Object[])props, (int)0, (int)groupFieldsNum));
            }
            return null;
        }).collect(Collectors.toList());
        System.out.println("calculate edge data:" + (System.currentTimeMillis() - start));
        System.out.println("features:" + collect.size());
        collect = collect.stream().filter(c -> c != null).collect(Collectors.toList());
        BucketHolder dataRoot = null;
        if (collect != null && !collect.isEmpty()) {
            dataRoot = BucketHolder.createBucket((IMetricsHolder)collect.get(0));
            int size = collect.size();
            if (size > 1) {
                for (int i = 1; i < size; ++i) {
                    BucketHolder.mergeBuckets(dataRoot, (IMetricsHolder)collect.get(i));
                }
            }
        }
        return dataRoot;
    }

    private List<ExtentGeometry> getRootExtentByEnv(Geometry geometry, IGridSystem grid, int level) throws Exception {
        Geometry env = geometry.getEnvelope();
        ArrayList<ExtentGeometry> rootMaps = new ArrayList<ExtentGeometry>(4);
        double envArea = env.getArea();
        Integer rootLevel = this.getLevelByArea(envArea, level);
        double[][] points = GeometryUtils.getPointsFromGeometry(env);
        ScanLine scanLine = new ScanLine(Integer.valueOf(1), new Integer[]{rootLevel}, grid);
        scanLine.calculate(points);
        Set set = (Set)scanLine.getExtents().get(rootLevel);
        if (geometry.getCoordinates().length > 1000000) {
            set.parallelStream().forEach(colrow -> {
                int x = Integer.valueOf(colrow.split("_")[0]);
                int y = Integer.valueOf(colrow.split("_")[1]);
                GridExtent extent = grid.getExtent(rootLevel.intValue(), x, y);
                Geometry extentGeom = this.getGeometryByExtent(extent);
                Geometry intersection = this.getIntersectionWithExtent(geometry, extentGeom);
                if (intersection != null && !intersection.isEmpty()) {
                    rootMaps.add(new ExtentGeometry(extent, intersection, false));
                }
            });
        } else {
            for (String colrow2 : set) {
                int x = Integer.valueOf(colrow2.split("_")[0]);
                int y = Integer.valueOf(colrow2.split("_")[1]);
                GridExtent extent = grid.getExtent(rootLevel.intValue(), x, y);
                Geometry extentGeom = this.getGeometryByExtent(extent);
                Geometry intersection = this.getIntersectionWithExtent(geometry, extentGeom);
                if (intersection == null || intersection.isEmpty()) continue;
                rootMaps.add(new ExtentGeometry(extent, intersection, false));
            }
        }
        return rootMaps;
    }

    private List<ExtentGeometry> getExtentByRoot(List<ExtentGeometry> rootMaps, Integer rootLevel, Integer startLevel, Integer endLevel, IGridSystem grid) {
        ArrayList<ExtentGeometry> nextLevelExtents = null;
        ArrayList<ExtentGeometry> startLevelExtents = new ArrayList<ExtentGeometry>();
        List<GridExtent> sub = null;
        while (rootLevel < endLevel) {
            nextLevelExtents = new ArrayList<ExtentGeometry>(rootMaps.size() * 4);
            for (ExtentGeometry holder : rootMaps) {
                if (holder.getExtent().getLevel() < endLevel && holder.isFull()) {
                    startLevelExtents.add(holder);
                    continue;
                }
                sub = this.buildDownArray(holder.getExtent(), grid);
                for (GridExtent subExtent : sub) {
                    if (holder.isFull()) {
                        nextLevelExtents.add(new ExtentGeometry(subExtent, this.getGeometryByExtent(subExtent), true));
                        continue;
                    }
                    Geometry extentGeom = this.getGeometryByExtent(subExtent);
                    Geometry intersection = this.getIntersectionWithExtent(holder.getGeometry(), extentGeom);
                    if (intersection == null || intersection.isEmpty()) continue;
                    boolean isFull = extentGeom.coveredBy(intersection);
                    ExtentGeometry subHolder = new ExtentGeometry(subExtent, intersection, isFull);
                    if (subExtent.getLevel() < endLevel && isFull) {
                        startLevelExtents.add(subHolder);
                        continue;
                    }
                    nextLevelExtents.add(subHolder);
                }
            }
            rootMaps = nextLevelExtents;
            Integer n = rootLevel;
            Integer n2 = rootLevel = Integer.valueOf(rootLevel + 1);
        }
        nextLevelExtents.addAll(startLevelExtents);
        return nextLevelExtents;
    }

    private List<ExtentGeometry> getExtentByRoot(List<ExtentGeometry> extents, Integer endLevel, IGridSystem grid) {
        ForkJoinPool pool = this.getForkJoinPool();
        ArrayList<ExtentGeometry> all = new ArrayList<ExtentGeometry>();
        extents.stream().map(extent -> new ExtentGeometryForkTask((ExtentGeometry)extent, grid, endLevel)).map(t -> pool.submit(t)).forEach(f -> {
            try {
                all.addAll((Collection)f.get());
            }
            catch (InterruptedException e) {
                throw new ServerException(e.getMessage());
            }
            catch (ExecutionException e) {
                throw new ServerException(e.getMessage());
            }
        });
        return all;
    }

    private List<GridExtent> buildDownArray(GridExtent extent, IGridSystem grid) {
        ArrayList<GridExtent> list = new ArrayList<GridExtent>();
        int x = extent.getX();
        int y = extent.getY();
        int l = extent.getLevel() + 1;
        GridExtent extent0 = grid.getExtent(l, x * 2, y * 2);
        GridExtent extent1 = grid.getExtent(l, x * 2 + 1, y * 2);
        GridExtent extent2 = grid.getExtent(l, x * 2, y * 2 + 1);
        GridExtent extent3 = grid.getExtent(l, x * 2 + 1, y * 2 + 1);
        list.add(extent0);
        list.add(extent1);
        list.add(extent2);
        list.add(extent3);
        return list;
    }

    private Integer getLevelByArea(double area, int level) {
        for (int i = 0; i < level; ++i) {
            if (!(area > areas[i])) continue;
            return i;
        }
        return level;
    }

    private Geometry getIntersectionWithExtent(Geometry geometry, Geometry extentGeom) {
        OverlayOp op = new OverlayOp(extentGeom, geometry);
        Geometry intersectArea = null;
        try {
            intersectArea = op.getResultGeometry(1);
        }
        catch (Exception e) {
            geometry = GeometryFixer.fix((Geometry)geometry);
            op = new OverlayOp(extentGeom, geometry);
            intersectArea = op.getResultGeometry(1);
        }
        return intersectArea;
    }

    private Geometry getGeometryByExtent(GridExtent extent) {
        double[] points = GeometryUtils.getDoubleArrayFromExtent4Point(extent.getBBoxCoordinates());
        return GeometryUtils.getPolygonFromPoints(points);
    }

    private ForkJoinPool getForkJoinPool() {
        ForkJoinPool pool = forkLocal.get();
        if (pool == null) {
            pool = new ForkJoinPool();
        }
        return pool;
    }

    private IDataSet getDataSet(String dataLayerName, Integer level, IVectorService service) {
        ILayer layer = (ILayer)service.getLayerMap().get(dataLayerName);
        if (layer == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u56fe\u5c42 : " + dataLayerName);
        }
        IDataSet dataSet = level == null ? ((ILayerLevel)layer.getLevelMap().values().iterator().next()).getDataSet() : ((ILayerLevel)layer.getLevelMap().get(level)).getDataSet();
        return dataSet;
    }
}

