/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell;

import com.geoway.vtile.commons.util.DoubleBuilderL;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.ScanLine;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.bean.ExtentGeometry;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.abstractclass.AbstractLayerTileCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.dataholder.metrics.ObjectArrayMetricsHolder;
import com.geoway.vtile.transform.enums.TILE_TYPE;
import com.geoway.vtile.transform.tools.CTerranArea;
import com.geoway.vtile.transform.utils.GeometryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlay.OverlayOp;

public class AreaStatisCell
extends AbstractLayerTileCell
implements ITileCutterCell<Object[], Map<String, ObjectArrayMetricsHolder>> {
    protected String[] groupFields;
    protected String areaField;
    protected TILE_TYPE tileType = TILE_TYPE.vector_tile;
    private final IGridSystem grid;
    public static final double[] areas = new double[]{518400.0, 129600.0, 32400.0, 8100.0, 2025.0, 506.25, 126.5625, 31.640625, 7.91015625, 1.9775390625, 0.494384765625, 0.12359619140625, 0.0308990478515625, 0.007724761962890625, 0.0019311904907226562, 4.8279762268066406E-4, 1.2069940567016602E-4, 3.0174851417541504E-5, 7.543712854385376E-6, 1.885928213596344E-6};

    public AreaStatisCell(ILayer layer, IGridSystem grid, String[] groupFields, String areaField, Integer level) {
        this.layer = layer;
        this.groupFields = groupFields;
        this.areaField = areaField;
        this.mainLevel = level;
        this.grid = grid;
    }

    @Override
    public void init() {
    }

    @Override
    public Map<String, ObjectArrayMetricsHolder> cut(Object[] data, TileCutOptions options) throws Exception {
        if (data == null) {
            return null;
        }
        HashMap<String, ObjectArrayMetricsHolder> resultMap = new HashMap<String, ObjectArrayMetricsHolder>();
        int fieldsNum = data.length;
        int spatialIndex = fieldsNum - 1;
        GeoBuffer geo = ((Geom)data[fieldsNum - 1]).toGeoBuffer();
        if (this.isCancel()) {
            return null;
        }
        Geometry geometry = geo.toJTSGeometry();
        List<ExtentGeometry> extents = this.getRootExtentByEnv(geometry);
        Integer rootLevel = extents.get(0).getExtent().getLevel();
        if (rootLevel != this.mainLevel) {
            extents = this.getExtentByRoot(extents, rootLevel, this.mainLevel);
        }
        data = ArrayUtils.remove((Object[])data, (int)spatialIndex);
        for (ExtentGeometry holder : extents) {
            Geometry intersectArea = holder.getGeometry();
            double area = CTerranArea.CalculateTerranArea(intersectArea);
            resultMap.put(holder.getExtent().getKey(), new ObjectArrayMetricsHolder(area, ArrayUtils.subarray((Object[])data, (int)0, (int)this.groupFields.length)));
        }
        return resultMap;
    }

    private List<ExtentGeometry> getExtentByRoot(List<ExtentGeometry> rootMaps, Integer rootLevel, Integer targetLevel) {
        ArrayList<ExtentGeometry> nextLevelExtents = null;
        List<GridExtent> sub = null;
        while (rootLevel < targetLevel) {
            nextLevelExtents = new ArrayList<ExtentGeometry>(rootMaps.size() * 4);
            for (ExtentGeometry holder : rootMaps) {
                sub = this.buildDownArray(holder.getExtent());
                for (GridExtent subExtent : sub) {
                    if (holder.isFull()) {
                        nextLevelExtents.add(new ExtentGeometry(subExtent, this.getGeometryByExtent(subExtent), true));
                        continue;
                    }
                    Geometry extentGeom = this.getGeometryByExtent(subExtent);
                    Geometry intersectArea = this.getIntersectionWithExtent(holder.getGeometry(), extentGeom);
                    if (intersectArea == null || intersectArea.isEmpty()) continue;
                    boolean isFull = extentGeom.coveredBy(intersectArea);
                    nextLevelExtents.add(new ExtentGeometry(subExtent, intersectArea, isFull));
                }
            }
            rootMaps = nextLevelExtents;
            Integer n = rootLevel;
            Integer n2 = rootLevel = Integer.valueOf(rootLevel + 1);
        }
        return nextLevelExtents;
    }

    private List<GridExtent> buildDownArray(GridExtent extent) {
        ArrayList<GridExtent> list = new ArrayList<GridExtent>();
        int x = extent.getX();
        int y = extent.getY();
        int l = extent.getLevel() + 1;
        GridExtent extent0 = this.grid.getExtent(l, x * 2, y * 2);
        GridExtent extent1 = this.grid.getExtent(l, x * 2 + 1, y * 2);
        GridExtent extent2 = this.grid.getExtent(l, x * 2, y * 2 + 1);
        GridExtent extent3 = this.grid.getExtent(l, x * 2 + 1, y * 2 + 1);
        list.add(extent0);
        list.add(extent1);
        list.add(extent2);
        list.add(extent3);
        return list;
    }

    private List<ExtentGeometry> getRootExtentByEnv(Geometry geometry) throws Exception {
        Geometry env = geometry.getEnvelope();
        ArrayList<ExtentGeometry> rootMaps = new ArrayList<ExtentGeometry>(4);
        double envArea = env.getArea();
        Integer rootLevel = this.getLevelByArea(envArea);
        double[][] points = GeometryUtils.getPointsFromGeometry(env);
        ScanLine scanLine = new ScanLine(Integer.valueOf(1), new Integer[]{rootLevel}, this.grid);
        scanLine.calculate(points);
        Set set = (Set)scanLine.getExtents().get(rootLevel);
        for (String colrow : set) {
            int x = Integer.valueOf(colrow.split("_")[0]);
            int y = Integer.valueOf(colrow.split("_")[1]);
            GridExtent extent = this.grid.getExtent(rootLevel.intValue(), x, y);
            Geometry extentGeom = this.getGeometryByExtent(extent);
            Geometry intersection = this.getIntersectionWithExtent(geometry, extentGeom);
            if (intersection == null || intersection.isEmpty()) continue;
            rootMaps.add(new ExtentGeometry(extent, intersection, false));
        }
        return rootMaps;
    }

    private Geometry getIntersectionWithExtent(Geometry geometry, Geometry extentGeom) {
        OverlayOp op = new OverlayOp(extentGeom, geometry);
        Geometry intersectArea = op.getResultGeometry(1);
        return intersectArea;
    }

    private Geometry getGeometryByExtent(GridExtent extent) {
        double[] points = this.addPoints(extent);
        return GeometryUtils.getPolygonFromPoints(points);
    }

    private double[] addPoints(GridExtent extent) {
        double x;
        double y;
        double[] points = GeometryUtils.getDoubleArrayFromExtent4Point(extent.getBBoxCoordinates());
        double res = extent.getGrid().getResolution(extent.getLevel());
        double meter = res * 512.0 * 110000.0;
        double len = extent.getRight() - extent.getLeft();
        double interval = len / (meter / 70.0);
        DoubleBuilderL doubleBuilder = new DoubleBuilderL();
        doubleBuilder.append(extent.getLeft());
        doubleBuilder.append(extent.getBottom());
        for (y = extent.getBottom() + interval; y < extent.getTop(); y += interval) {
            doubleBuilder.append(extent.getLeft());
            doubleBuilder.append(y);
        }
        doubleBuilder.append(extent.getLeft());
        doubleBuilder.append(extent.getTop());
        for (x = extent.getLeft() + interval; x < extent.getRight(); x += interval) {
            doubleBuilder.append(x);
            doubleBuilder.append(extent.getTop());
        }
        doubleBuilder.append(extent.getRight());
        doubleBuilder.append(extent.getTop());
        for (y = extent.getTop() - interval; y > extent.getBottom(); y -= interval) {
            doubleBuilder.append(extent.getRight());
            doubleBuilder.append(y);
        }
        doubleBuilder.append(extent.getRight());
        doubleBuilder.append(extent.getBottom());
        for (x = extent.getRight() - interval; x > extent.getLeft(); x -= interval) {
            doubleBuilder.append(x);
            doubleBuilder.append(extent.getBottom());
        }
        doubleBuilder.append(extent.getLeft());
        doubleBuilder.append(extent.getBottom());
        doubleBuilder.trimToSize();
        return doubleBuilder.toArray();
    }

    private Integer getLevelByArea(double area) {
        for (int i = 0; i < this.mainLevel; ++i) {
            if (!(area > areas[i])) continue;
            return i;
        }
        return this.mainLevel;
    }

    public String[] getGroupFields() {
        return this.groupFields;
    }

    public void setGroupFields(String[] groupFields) {
        this.groupFields = groupFields;
    }
}

