/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.vtile.model.vector_service.utfgrid.IUtfgridInfo;
import com.geoway.vtile.service.mapserver.MapServerAccess;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtfGridCell
implements ITileCutterCell<GridExtent, List<Object[]>> {
    private static Logger logger = LoggerFactory.getLogger(UtfGridCell.class);
    public static final String createMergeGridUrl = "%s/%s/build/mergeGrid?x=%s&y=%s&l=%s";
    public static final String createUtfGridUrl = "%s/%s/build/createGrid?x=%s&y=%s&l=%s";
    private String serverName;
    private String tilesize;
    private String sampling;
    private Integer beginLevel;
    private Integer endLevel;
    private String mergefields;
    private MapServerAccess syncMapServerGet;
    boolean isBuild = true;
    private boolean cancel = false;
    Long timestamp;
    boolean removeOldTile = true;
    String ignoreLayer;

    public UtfGridCell(String serverName, IUtfgridInfo utfGrid, MapServerAccess syncMapServerGet, boolean isBuild) {
        this.syncMapServerGet = syncMapServerGet;
        this.tilesize = "512";
        this.sampling = String.valueOf(utfGrid.getSampling());
        this.beginLevel = utfGrid.getStartLevel();
        this.endLevel = utfGrid.getEndLevel();
        this.mergefields = utfGrid.getMergeFields();
        this.serverName = serverName;
        this.mergefields = "";
        this.isBuild = isBuild;
        this.ignoreLayer = utfGrid.getBean().getIgnoreLayer();
    }

    public Boolean createGridIn(GridExtent extent) throws Exception {
        String url = this.buildUrl(extent, "createUtfGrid");
        Boolean success = null;
        String returnStr = null;
        JSONObject m = null;
        try {
            returnStr = this.syncMapServerGet.sendHttpGet(url);
            if (StringUtils.isEmpty((CharSequence)returnStr)) {
                throw new RuntimeException("\u8bf7\u6c42Mapserver\u5f15\u64ce\u51fa\u9519\uff0c\u5efa\u8bae\u68c0\u67e5\u6e32\u67d3\u5f15\u64ce\u662f\u5426\u53ef\u4ee5\u8bbf\u95ee\u3002");
            }
            m = JSON.parseObject((String)returnStr);
            success = m.getBoolean("success");
        }
        catch (Exception e) {
            throw new Exception("UTFGrid\u6e32\u67d3\u62a5\u9519: " + e.getMessage() + ", url: " + url);
        }
        if (success == null) {
            String message = m.getString("message");
            throw new Exception("\u540e\u7aefutf\u6e32\u67d3\u62a5\u9519\uff1a" + message + "; \u5f15\u64ceurl: " + url);
        }
        String id = m.getString("id");
        String message = m.getString("message");
        if (id == null) {
            throw new Exception("\u540e\u7aefutf\u6e32\u67d3\u62a5\u9519\uff1a" + message + "; \u5f15\u64ceurl: " + url);
        }
        return success;
    }

    public Boolean mergeGridIn(GridExtent extent) throws Exception {
        String url = this.buildUrl(extent, "mergeGrid");
        String returnStr = this.syncMapServerGet.sendHttpGet(url);
        JSONObject m = JSON.parseObject((String)returnStr);
        Boolean success = m.getBoolean("success");
        if (success == null || !success.booleanValue()) {
            throw new RuntimeException("\u521b\u5efautfgrid\u9519\u8bef, \u5f15\u64ce\u8bf7\u6c42\u5931\u8d25: " + url);
        }
        String id = m.getString("id");
        if (id == null) {
            throw new RuntimeException("\u521b\u5efautfgrid\u9519\u8bef");
        }
        return success;
    }

    private String buildUrl(GridExtent extent, String type) {
        String x = String.valueOf(extent.getX());
        String y = String.valueOf(extent.getY());
        String l = String.valueOf(extent.getLevel());
        String urlTemplate = null;
        if (type.equalsIgnoreCase("mergeGrid")) {
            urlTemplate = createMergeGridUrl;
        }
        if (type.equalsIgnoreCase("createUtfGrid")) {
            urlTemplate = createUtfGridUrl;
        }
        if (this.timestamp != null) {
            urlTemplate = urlTemplate + "&_t__=" + this.timestamp;
        }
        if (!this.removeOldTile) {
            urlTemplate = urlTemplate + "&removeOldTile=" + this.removeOldTile;
        }
        if (StringUtils.isNotBlank((CharSequence)this.ignoreLayer)) {
            urlTemplate = urlTemplate + "&ignoreLayer=" + this.ignoreLayer;
        }
        String str = String.format(urlTemplate, this.syncMapServerGet.getUrlPrifix(), this.serverName, x, y, l, this.sampling, this.tilesize, this.mergefields);
        return str;
    }

    public Integer getBeginLevel() {
        return this.beginLevel;
    }

    public Integer getEndLevel() {
        return this.endLevel;
    }

    @Override
    public void setDown(int down) {
    }

    @Override
    public Integer getDown() {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public List<Object[]> cut(GridExtent extent, TileCutOptions options) throws Exception {
        if (this.isCancel()) {
            return null;
        }
        Boolean isOk = this.cutWithRetry(extent, true);
        if (null == isOk || !isOk.booleanValue()) {
            return null;
        }
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        Boolean[] arr = new Boolean[]{isOk};
        ret.add(arr);
        return ret;
    }

    private Boolean cutWithRetry(GridExtent extent, boolean canRetry) throws Exception {
        if (canRetry) {
            Boolean isOk = null;
            try {
                isOk = this.isBuild ? this.createGridIn(extent) : this.mergeGridIn(extent);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                isOk = false;
            }
            if (!isOk.booleanValue()) {
                logger.warn("10s\u540e\u91cd\u8bd5\u751f\u6210UTFGrid\u7f51\u683c\uff1a{}", (Object)extent.getCodeXYL());
                Thread.sleep(10000L);
                isOk = this.cutWithRetry(extent, false);
            }
            return isOk;
        }
        if (this.isBuild) {
            return this.createGridIn(extent);
        }
        return this.mergeGridIn(extent);
    }

    @Override
    public void setMainLevel(Integer mainLevel) {
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean isCancel() {
        return this.cancel;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setRemoveOldTile(boolean removeOldTile) {
        this.removeOldTile = removeOldTile;
    }
}

