/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cellv4;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.vtile.diagnose.GlobalMetrics;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.Constants;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.dataset.DataSetShell;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.Label;
import com.geoway.vtile.model.vector_service.layer.LayerBean;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.cellv4.LayerTileBuilderCell;
import com.geoway.vtile.transform.cellv4.TileOptimizer;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import com.geoway.vtile.transform.enums.TILE_TYPE;
import com.geoway.vtile.transform.enums.TILE_VERSION_ENUM;
import com.geoway.vtile.transform.writer.Writer;
import com.geoway.vtile.transform.writer.WriterManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTileBuilderUnit
implements ITileCutterCell<GridExtent, List<Object[]>> {
    private static Logger logger = LoggerFactory.getLogger(MapTileBuilderUnit.class);
    private static final int TIME_OUT = 7200;
    protected IVectorService mapService;
    protected ExecutorService tpool;
    protected TILE_VERSION_ENUM tileVersion = TILE_VERSION_ENUM.v2_0;
    protected TILE_TYPE tileType = TILE_TYPE.vector_tile;
    protected LAYER_TYPE cutType = LAYER_TYPE.all;
    protected Map<String, ITileCutterCell<GridExtent, List<Object[]>>> cellMap = new HashMap<String, ITileCutterCell<GridExtent, List<Object[]>>>();
    protected Integer mainLevel;
    protected int down = 0;
    private boolean withStyleFilter = false;
    protected boolean returnWriter = false;
    private boolean cancel = false;
    private TileOptimizer optimizer;
    private final AtomicLong nSkippedGrids = new AtomicLong(0L);

    public MapTileBuilderUnit(IVectorService mapService, ExecutorService cutThreadPool) {
        this.mapService = mapService;
        this.tpool = cutThreadPool;
        if (this.tpool == null) {
            throw new RuntimeException("\u7f3a\u5c11\u6267\u884c\u4efb\u52a1\u9700\u8981\u7684\u7ebf\u7a0b\u6c60");
        }
        if (this.tpool.isShutdown() || this.tpool.isTerminated()) {
            throw new RuntimeException("\u63d0\u4f9b\u7684\u7ebf\u7a0b\u6c60\u4e0d\u53ef\u7528");
        }
    }

    public MapTileBuilderUnit(IVectorService mapService, ExecutorService cutThreadPool, LAYER_TYPE type) {
        this(mapService, cutThreadPool);
        this.cutType = type;
    }

    @Override
    public void setMainLevel(Integer mainLevel) {
        this.mainLevel = mainLevel;
    }

    public void setHasStyle(boolean hasStyle) {
        this.withStyleFilter = hasStyle;
    }

    @Override
    public void setDown(int down) {
        this.down = down;
    }

    @Override
    public Integer getDown() {
        return this.down;
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.cellMap.values().forEach(lyrCell -> lyrCell.cancel());
    }

    @Override
    public boolean isCancel() {
        return this.cancel;
    }

    public void setReturnWriter(boolean returnWriter) {
        this.returnWriter = returnWriter;
    }

    public void setOptimizer(TileOptimizer optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public void init() {
        logger.info(">>> {} \u521d\u59cb\u5316 {} \u7ea7\u74e6\u7247\u5904\u7406\u5355\u5143", this.mapService.getId(), (Object)this.mainLevel);
        try {
            this.mapService.getLayerMap().values().forEach(layer -> {
                boolean isLabelVisibleAtLevel;
                boolean isLayerVisible;
                String layerName = layer.getId();
                Boolean hasLabel = layer.isHaveLabel();
                Label layerLabel = layer.getLabel();
                Map levelMap = layer.getLevelMap();
                if (!(levelMap.containsKey(this.mainLevel) || layer.getBeginLevel() <= this.mainLevel + this.down && layer.getEndLevel() >= this.mainLevel)) {
                    logger.info("\u56fe\u5c42 {} \u4e0d\u5728\u74e6\u7247\u9884\u70ed\u5c42\u7ea7\u8303\u56f4 {}~{} \u5185", new Object[]{layer.getId(), this.mainLevel, this.mainLevel + this.down});
                    return;
                }
                ILayerLevel llevel = (ILayerLevel)layer.getLevelMap().get(this.mainLevel);
                String currLevelFilter = llevel.getFilterExpression();
                String currLevelLabelFilter = null;
                if (hasLabel.booleanValue() && null != layerLabel) {
                    currLevelLabelFilter = layerLabel.getFilterAtLevel(this.mainLevel.toString());
                }
                if ("1 = 2".equals(currLevelFilter)) {
                    logger.debug("\u4e0d\u53ef\u89c1\u56fe\u5c42\uff1a{}", (Object)layerName);
                    return;
                }
                boolean bl = isLayerVisible = null != currLevelFilter;
                if (isLayerVisible) {
                    logger.debug("\u6dfb\u52a0\u5e95\u56fe\u5c42\uff1a{}", (Object)layerName);
                    this.cellMap.put(layerName, new LayerTileBuilderCell((ILayer)layer, LAYER_TYPE.layer, currLevelFilter));
                }
                boolean bl2 = isLabelVisibleAtLevel = hasLabel != false && null != currLevelLabelFilter && null != layerLabel && Constants.LABEL_TYPE.point != layerLabel.getType();
                if (!this.withStyleFilter) {
                    isLabelVisibleAtLevel = hasLabel;
                }
                if (isLabelVisibleAtLevel) {
                    logger.debug("\u6dfb\u52a0\u6ce8\u8bb0\u5c42\uff1a{}", (Object)(layerName + LayerBean.LABEL_SUFFIX));
                    this.cellMap.put(layerName + LayerBean.LABEL_SUFFIX, new LayerTileBuilderCell((ILayer)layer, LAYER_TYPE.label, currLevelLabelFilter));
                }
                logger.debug("\u68c0\u67e5\u6570\u636e\u670d\u52a1\u8fc7\u6ee4\u6761\u4ef6");
                this.validateDatasetFilter((ILayer)layer);
            });
            this.cellMap.values().forEach(lcell -> {
                lcell.setMainLevel(this.mainLevel);
                lcell.init();
            });
        }
        catch (Exception ex) {
            logger.error("MapTileBuilderUnit\u521d\u59cb\u5316\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }

    private void validateDatasetFilter(ILayer layer) {
        try {
            ILayerLevel layerLevel = (ILayerLevel)layer.getLevelMap().get(this.mainLevel);
            IDataSet datset = layerLevel.getDataSet();
            String dsFilter = datset.getFilter();
            if (StringUtils.isNotEmpty((CharSequence)dsFilter) && dsFilter.contains("\"")) {
                dsFilter = dsFilter.replace("\"", "'");
                ((DataSetShell)datset).getDataSet().setFilter(dsFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<Object[]> cut(GridExtent extent, TileCutOptions options) throws Exception {
        if (this.cellMap.isEmpty()) {
            return null;
        }
        if (this.isCancel()) {
            throw new RuntimeException("\u5730\u56fe\u9884\u70ed\u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88.");
        }
        if (this.willBeEmpty(extent)) {
            if (Log4jUtil.isDiagnoseEnable()) {
                logger.info("\u8df3\u8fc7\u7a7a\u7f51\u683c\uff1a{} ", (Object)extent.getCodeXYL());
                this.nSkippedGrids.incrementAndGet();
            }
            return null;
        }
        CompletableFuture<List<Object[]>> allData = this.cutAsync(extent, options);
        allData.exceptionally(e -> {
            throw new RuntimeException();
        });
        allData.join();
        List<Object[]> tilesList = allData.get();
        if (null == tilesList || tilesList.isEmpty()) {
            this.recordEmptyGrids(extent);
            if (Log4jUtil.isDiagnoseEnable()) {
                this.nSkippedGrids.incrementAndGet();
            }
            return null;
        }
        return tilesList;
    }

    private void recordEmptyGrids(GridExtent extent) {
        if (extent.getLevel() > 15) {
            return;
        }
        this.optimizer.registerEmptyGrid(extent);
        int from = extent.getLevel();
        int to = this.mainLevel + this.down;
        if (0 == this.down) {
            to = this.mapService.getStorageInfo().getEndLevel();
        }
        if (to > 15) {
            to = 15;
        }
        if (from >= to) {
            return;
        }
        boolean isSame = this.optimizer.isSameFilterAtLevels(from, to);
        if (isSame) {
            for (int i = from + 1; i <= to; ++i) {
                List subGrids = extent.getChildrenAt(i);
                subGrids.forEach(g -> this.optimizer.registerEmptyGrid((GridExtent)g));
            }
        }
    }

    private boolean willBeEmpty(GridExtent extent) {
        if (this.optimizer.containsEmptyGrid(extent)) {
            return true;
        }
        int myLevel = extent.getLevel();
        return this.optimizer.isSameFilterAtLevels(myLevel - 1, myLevel) && this.optimizer.isGridParentEmpty(extent);
    }

    public CompletableFuture<List<Object[]>> cutAsync(GridExtent extent, TileCutOptions options) throws Exception {
        String extraSqlFilter;
        if (this.cutType == null) {
            throw new Exception("not support type named:" + (Object)((Object)this.cutType));
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            int l = extent.getLevel();
            if (this.down > 0) {
                logger.info("\u5f00\u59cb\u5904\u7406\u7f51\u683c\uff1a{} \u74e6\u7247\u9884\u70ed{}~{}\u7ea7", new Object[]{extent.getCodeXYL(), l, l + this.down});
            } else {
                logger.info("\u5f00\u59cb\u5904\u7406\u7f51\u683c\uff1a{} \u74e6\u7247\u9884\u70ed", (Object)extent.getCodeXYL());
            }
        }
        HashMap filter = (extraSqlFilter = options.getExtraSqlFilter()) != null ? (HashMap)JSON.parseObject((String)extraSqlFilter, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]) : null;
        Integer level = extent.getLevel();
        Stream stream = this.mapService.getLayerMap().entrySet().stream();
        CompletableFuture[] promiseArr = (CompletableFuture[])stream.filter(entry -> MapTileBuilderUnit.isLayerNeedCut(filter, entry)).flatMap(entry -> {
            ILayer layer = (ILayer)entry.getValue();
            if (this.cutType == LAYER_TYPE.layer && layer.getLabelOnly().booleanValue()) {
                return null;
            }
            if (this.cutType == LAYER_TYPE.label && !layer.isHaveLabel()) {
                return null;
            }
            if (level + this.down < layer.getBeginLevel()) {
                return null;
            }
            String layerKey = (String)entry.getKey();
            String filterStrForLayer = null;
            Stream<Object> promiseStream = Stream.empty();
            if (filter != null && "all".equalsIgnoreCase(filterStrForLayer = (String)filter.get(layerKey))) {
                filterStrForLayer = null;
            }
            TileCutOptions layerOptions = options.clone();
            layerOptions.setExtraSqlFilter(filterStrForLayer);
            CompletableFuture<List<Object[]>> promise = this.cutLayer(extent, layer, this.cutType, layerOptions);
            promiseStream = Stream.of(promise);
            if (layer.getLabel() != null && layer.getLabel().getType() != Constants.LABEL_TYPE.point && this.cutType != LAYER_TYPE.layer) {
                if (filter != null && "all".equalsIgnoreCase(filterStrForLayer = (String)filter.get(layerKey + LayerBean.LABEL_SUFFIX))) {
                    filterStrForLayer = null;
                }
                layerOptions.setExtraSqlFilter(filterStrForLayer);
                promise = this.cutLayer(extent, layer, LAYER_TYPE.label, layerOptions);
                promiseStream = Stream.concat(promiseStream, Stream.of(promise));
            }
            return promiseStream;
        }).filter(p -> p != null).toArray(CompletableFuture[]::new);
        if (promiseArr.length == 0) {
            return null;
        }
        CompletableFuture.allOf(promiseArr);
        CompletableFuture<List<Object[]>> allData = CompletableFuture.supplyAsync(() -> {
            List<Object[]> result = this.dataUnion(promiseArr, extent);
            return result;
        });
        return allData;
    }

    private static boolean isLayerNeedCut(HashMap<String, Object> filter, Map.Entry<String, ILayer> entry) {
        if (filter == null) {
            return true;
        }
        String layerKey = entry.getKey();
        return filter.get(layerKey) != null || filter.get(layerKey + LayerBean.LABEL_SUFFIX) != null;
    }

    protected CompletableFuture<List<Object[]>> cutLayer(GridExtent extent, ILayer layer, LAYER_TYPE type, TileCutOptions options) {
        String finalLayerId;
        ITileCutterCell<GridExtent, List<Object[]>> cell;
        String layerId = layer.getId();
        if (layer.getLabel() != null && layer.getLabel().getType() != Constants.LABEL_TYPE.point && type == LAYER_TYPE.label) {
            layerId = layerId + LayerBean.LABEL_SUFFIX;
        }
        if ((cell = this.cellMap.get(finalLayerId = layerId)) == null || this.isCancel()) {
            return CompletableFuture.supplyAsync(() -> null);
        }
        cell.setDown(this.down);
        CompletableFuture<List<Object[]>> promise = CompletableFuture.supplyAsync(() -> {
            List gridList = null;
            List grid = null;
            try {
                grid = (List)cell.cut(extent, options);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            if (grid == null || grid.isEmpty()) {
                return null;
            }
            try {
                gridList = grid.stream().map(objArr -> new Object[]{finalLayerId, objArr[0], ((Object[])objArr).length > 1 ? objArr[1] : null, objArr[2]}).collect(Collectors.toList());
                return gridList;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }, this.tpool);
        promise.exceptionally(e -> {
            throw new RuntimeException((Throwable)e);
        });
        return promise;
    }

    protected List<Object[]> dataUnion(CompletableFuture<List<Object[]>>[] promiseArr, GridExtent extent) {
        LinkedHashMap<GridExtent, Writer> writerMap = new LinkedHashMap<GridExtent, Writer>();
        if (this.isCancel()) {
            throw new RuntimeException("\u5730\u56fe\u9884\u70ed\u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88");
        }
        for (int i = 0; i < promiseArr.length; ++i) {
            List<Object[]> o = null;
            try {
                if (this.isCancel()) {
                    return null;
                }
                o = promiseArr[i].get(7200L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                logger.error(Log4jUtil.MARKER_DIAG, "\u670d\u52a1\u7f51\u683c {}({}) \u74e6\u7247\u9884\u70ed\u8d85\u65f6", this.mapService.getId(), (Object)extent.getCodeXYL());
                o = null;
                GlobalMetrics.Current.getnGridTimeoutTimes().incrementAndGet();
            }
            catch (Exception e) {
                logger.error(Log4jUtil.MARKER_DIAG, "\u670d\u52a1\u7f51\u683c {}({}) \u74e6\u7247\u9884\u70ed\u5f02\u5e38\uff01", this.mapService.getId(), (Object)extent.getCodeXYL());
                throw new RuntimeException(e);
            }
            if (o == null) continue;
            int len = o.size();
            if (len > 0 && Log4jUtil.isDiagnoseEnable()) {
                String layerName = (String)o.get(0)[0];
                logger.info("\u51c6\u5907\u4fdd\u5b58\u56fe\u5c42 {} {} \u7684\u74e6\u7247 {} \u4e2a", new Object[]{i + 1, layerName, len});
            }
            Object[] objArr = null;
            GridExtent subExtent = null;
            String layerId = null;
            byte[] info = null;
            Boolean isExceed = null;
            for (int j = 0; j < len; ++j) {
                objArr = o.get(j);
                layerId = (String)objArr[0];
                subExtent = (GridExtent)objArr[1];
                info = (byte[])objArr[2];
                isExceed = (Boolean)objArr[3];
                if (info == null || info.length == 0) continue;
                Writer writer2 = null;
                if (!writerMap.containsKey(subExtent)) {
                    writer2 = WriterManager.getWriter(this.tileType, this.tileVersion);
                    writerMap.put(subExtent, writer2);
                } else {
                    writer2 = (Writer)writerMap.get(subExtent);
                }
                writer2.addLayer(layerId, info);
                if (!isExceed.booleanValue()) continue;
                writer2.setExceed(isExceed);
            }
        }
        if (this.isCancel()) {
            if (Log4jUtil.isDiagnoseEnable()) {
                logger.error("\u5df2\u53d6\u6d88\u7f51\u683c\uff1a{} \u74e6\u7247\u9884\u70ed\u3002\u53ef\u80fd\u5b58\u5728\u4e0d\u5b8c\u6574\u7684\u74e6\u7247\uff0c\u56e0\u6b64\u9700\u8981\u653e\u5f03\u4fdd\u5b58\u5f53\u524d\u74e6\u7247\uff01", (Object)extent.getCodeXYL());
            }
            return null;
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (this.returnWriter) {
            writerMap.forEach((subextent, writer) -> result.add(new Object[]{subextent, writer}));
        } else {
            writerMap.forEach((subextent, writer) -> result.add(new Object[]{subextent, writer.getData()}));
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u5df2\u5b8c\u6210\u7f51\u683c\u9884\u70ed\uff1a{} ", (Object)extent.getCodeXYL());
        }
        return result;
    }

    public void summarize() {
        if (!Log4jUtil.isDiagnoseEnable()) {
            return;
        }
        long nEmptyGrids = this.nSkippedGrids.get();
        if (nEmptyGrids > 0L) {
            logger.info("\u5df2\u8df3\u8fc7\u7a7a\u7f51\u683c\u603b\u4e2a\u6570\uff1a{}", (Object)nEmptyGrids);
        }
    }

    public int getMainLevel() {
        return this.mainLevel;
    }
}

