/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.Constants;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.dataset.DataSetShell;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.LayerBean;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.LayerTileCutterCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import com.geoway.vtile.transform.enums.TILE_TYPE;
import com.geoway.vtile.transform.enums.TILE_VERSION_ENUM;
import com.geoway.vtile.transform.writer.Writer;
import com.geoway.vtile.transform.writer.WriterManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTileCutterCell
implements ITileCutterCell<GridExtent, List<Object[]>> {
    private static Logger logger = LoggerFactory.getLogger(ServerTileCutterCell.class);
    protected IVectorService server;
    protected ExecutorService executorService;
    protected TILE_VERSION_ENUM tileVersion = TILE_VERSION_ENUM.v2_0;
    protected TILE_TYPE tileType = TILE_TYPE.vector_tile;
    protected LAYER_TYPE cutType = LAYER_TYPE.all;
    protected Map<String, ITileCutterCell<GridExtent, List<Object[]>>> cellMap = new HashMap<String, ITileCutterCell<GridExtent, List<Object[]>>>();
    private static final int TIME_OUT = 60000;
    protected int down = 0;
    protected boolean returnWriter = false;
    protected Integer mainLevel;
    private boolean cancel = false;

    public ServerTileCutterCell(IVectorService server, ExecutorService executorService) {
        this.server = server;
        if (executorService == null) {
            throw new RuntimeException("\u7f3a\u5c11\u6267\u884c\u4efb\u52a1\u9700\u8981\u7684\u7ebf\u7a0b\u6c60");
        }
        if (executorService.isShutdown() || executorService.isTerminated()) {
            throw new RuntimeException("\u63d0\u4f9b\u7684\u7ebf\u7a0b\u6c60\u4e0d\u53ef\u7528");
        }
        this.executorService = executorService;
    }

    public ServerTileCutterCell(IVectorService server, ExecutorService executorService, LAYER_TYPE type) {
        this(server, executorService);
        this.cutType = type;
    }

    public CompletableFuture<List<Object[]>> cutAsync(GridExtent extent, TileCutOptions options) throws Exception {
        String extraSqlFilter;
        if (this.cutType == null) {
            throw new Exception("not support type named:" + (Object)((Object)this.cutType));
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            int l = extent.getLevel();
            if (this.down > 0) {
                logger.info("\u5f00\u59cb\u5904\u7406\u7f51\u683c\uff1a{}_{}_{} \u74e6\u7247\u9884\u70ed{}~{}\u7ea7", new Object[]{extent.getX(), extent.getY(), l, l, l + this.down});
            } else {
                logger.info("\u5f00\u59cb\u5904\u7406\u7f51\u683c\uff1a{}_{}_{} \u74e6\u7247\u9884\u70ed", new Object[]{extent.getX(), extent.getY(), extent.getLevel()});
            }
        }
        HashMap filter = (extraSqlFilter = options.getExtraSqlFilter()) != null ? (HashMap)JSON.parseObject((String)extraSqlFilter, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]) : null;
        Integer level = extent.getLevel();
        Stream stream = this.server.getLayerMap().entrySet().stream();
        CompletableFuture[] promiseArr = (CompletableFuture[])stream.filter(entry -> ServerTileCutterCell.isLayerNeedCut(filter, entry)).flatMap(entry -> {
            ILayer layer = (ILayer)entry.getValue();
            if (this.cutType == LAYER_TYPE.layer && layer.getLabelOnly().booleanValue()) {
                return null;
            }
            if (this.cutType == LAYER_TYPE.label && !layer.isHaveLabel()) {
                return null;
            }
            if (level + this.down < layer.getBeginLevel()) {
                return null;
            }
            String layerKey = (String)entry.getKey();
            String filterStrForLayer = null;
            Stream<Object> promiseStream = Stream.empty();
            if (filter != null && "all".equalsIgnoreCase(filterStrForLayer = (String)filter.get(layerKey))) {
                filterStrForLayer = null;
            }
            TileCutOptions layerOptions = options.clone();
            layerOptions.setExtraSqlFilter(filterStrForLayer);
            CompletableFuture<List<Object[]>> promise = this.cutLayer(extent, layer, this.cutType, layerOptions);
            promiseStream = Stream.of(promise);
            if (layer.getLabel() != null && layer.getLabel().getType() != Constants.LABEL_TYPE.point && this.cutType != LAYER_TYPE.layer) {
                if (filter != null && "all".equalsIgnoreCase(filterStrForLayer = (String)filter.get(layerKey + LayerBean.LABEL_SUFFIX))) {
                    filterStrForLayer = null;
                }
                layerOptions.setExtraSqlFilter(filterStrForLayer);
                promise = this.cutLayer(extent, layer, LAYER_TYPE.label, layerOptions);
                promiseStream = Stream.concat(promiseStream, Stream.of(promise));
            }
            return promiseStream;
        }).filter(p -> p != null).toArray(CompletableFuture[]::new);
        if (promiseArr.length == 0) {
            return null;
        }
        CompletableFuture.allOf(promiseArr);
        CompletableFuture<List<Object[]>> allData = CompletableFuture.supplyAsync(() -> {
            List<Object[]> result = this.dataUnion(promiseArr, extent);
            return result;
        });
        return allData;
    }

    private static boolean isLayerNeedCut(HashMap<String, Object> filter, Map.Entry<String, ILayer> entry) {
        if (filter == null) {
            return true;
        }
        String layerKey = entry.getKey();
        return filter.get(layerKey) != null || filter.get(layerKey + LayerBean.LABEL_SUFFIX) != null;
    }

    @Override
    public void setMainLevel(Integer mainLevel) {
        this.mainLevel = mainLevel;
    }

    protected CompletableFuture<List<Object[]>> cutLayer(GridExtent extent, ILayer layer, LAYER_TYPE type, TileCutOptions options) {
        String finalLayerId;
        ITileCutterCell<GridExtent, List<Object[]>> cell;
        String layerId = layer.getId();
        if (layer.getLabel() != null && layer.getLabel().getType() != Constants.LABEL_TYPE.point && type == LAYER_TYPE.label) {
            layerId = layerId + LayerBean.LABEL_SUFFIX;
        }
        if ((cell = this.cellMap.get(finalLayerId = layerId)) == null || this.isCancel()) {
            return this.getEmptyPromise();
        }
        cell.setDown(this.down);
        CompletableFuture<List<Object[]>> promise = CompletableFuture.supplyAsync(() -> {
            List gridList = null;
            List grid = null;
            try {
                grid = (List)cell.cut(extent, options);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            if (grid == null || grid.isEmpty()) {
                return null;
            }
            try {
                gridList = grid.stream().map(objArr -> new Object[]{finalLayerId, objArr[0], ((Object[])objArr).length > 1 ? objArr[1] : null, objArr[2]}).collect(Collectors.toList());
                return gridList;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }, this.executorService);
        promise.exceptionally(e -> {
            throw new RuntimeException((Throwable)e);
        });
        return promise;
    }

    protected List<Object[]> dataUnion(CompletableFuture<List<Object[]>>[] promiseArr, GridExtent extent) {
        LinkedHashMap<GridExtent, Writer> writerMap = new LinkedHashMap<GridExtent, Writer>();
        for (int i = 0; i < promiseArr.length; ++i) {
            List<Object[]> o = null;
            try {
                if (this.isCancel()) {
                    return null;
                }
                o = promiseArr[i].get(60000L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                logger.error(Log4jUtil.MARKER_DIAG, "\u670d\u52a1\u7f51\u683c {}({}_{}_{}) \u74e6\u7247\u9884\u70ed\u8d85\u65f6", new Object[]{this.server.getId(), extent.getX(), extent.getY(), extent.getLevel()});
                o = null;
            }
            catch (Exception e) {
                logger.error(Log4jUtil.MARKER_DIAG, "\u670d\u52a1\u7f51\u683c {}({}_{}_{}) \u74e6\u7247\u9884\u70ed\u5f02\u5e38\uff01", new Object[]{this.server.getId(), extent.getX(), extent.getY(), extent.getLevel()});
                throw new RuntimeException(e);
            }
            if (o == null) {
                if (!Log4jUtil.isDiagnoseEnable()) continue;
                logger.info("\u7f51\u683c {}_{}_{} \u74e6\u7247\u9884\u70ed\u7ed3\u679c\u4e3a\u7a7a", new Object[]{extent.getX(), extent.getY(), extent.getLevel()});
                continue;
            }
            int len = o.size();
            if (Log4jUtil.isDiagnoseEnable()) {
                logger.info("\u51c6\u5907\u4fdd\u5b58\u56fe\u5c42 {} \u7684\u74e6\u7247 {} \u4e2a", (Object)(i + 1), (Object)len);
            }
            Object[] objArr = null;
            GridExtent subExtent = null;
            String layerId = null;
            byte[] info = null;
            Boolean isExceed = null;
            for (int j = 0; j < len; ++j) {
                objArr = o.get(j);
                layerId = (String)objArr[0];
                subExtent = (GridExtent)objArr[1];
                info = (byte[])objArr[2];
                isExceed = (Boolean)objArr[3];
                if (info == null || info.length == 0) continue;
                Writer writer2 = null;
                if (!writerMap.containsKey(subExtent)) {
                    writer2 = WriterManager.getWriter(this.tileType, this.tileVersion);
                    writerMap.put(subExtent, writer2);
                } else {
                    writer2 = (Writer)writerMap.get(subExtent);
                }
                writer2.addLayer(layerId, info);
                if (!isExceed.booleanValue()) continue;
                writer2.setExceed(isExceed);
            }
        }
        if (this.isCancel()) {
            if (Log4jUtil.isDiagnoseEnable()) {
                logger.error("\u5df2\u653e\u5f03\u7f51\u683c\uff1a{} \u74e6\u7247\u9884\u70ed\u3002\u53ef\u80fd\u5b58\u5728\u4e0d\u5b8c\u6574\u7684\u74e6\u7247\uff0c\u56e0\u6b64\u9700\u8981\u653e\u5f03\u4fdd\u5b58\u5f53\u524d\u74e6\u7247\uff01", (Object)extent.getCodeXYL());
            }
            return null;
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (this.returnWriter) {
            writerMap.forEach((subextent, writer) -> result.add(new Object[]{subextent, writer}));
        } else {
            writerMap.forEach((subextent, writer) -> result.add(new Object[]{subextent, writer.getData()}));
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u5df2\u5b8c\u6210\u7f51\u683c\uff1a{}_{}_{} \u74e6\u7247\u9884\u70ed", new Object[]{extent.getX(), extent.getY(), extent.getLevel()});
        }
        return result;
    }

    @Override
    public void setDown(int down) {
        this.down = down;
    }

    @Override
    public Integer getDown() {
        return this.down;
    }

    public Map<String, ITileCutterCell<GridExtent, List<Object[]>>> getCellMap() {
        return this.cellMap;
    }

    @Override
    public void init() {
        for (ILayer layer : this.server.getLayerMap().values()) {
            if (!this.isLayerVisible(layer)) continue;
            this.validateDatasetFilter(layer);
            if (!layer.getLabelOnly().booleanValue()) {
                this.cellMap.put(layer.getId(), new LayerTileCutterCell(layer, LAYER_TYPE.layer));
            }
            if (layer.getLabel() == null || layer.getLabel().getType() == Constants.LABEL_TYPE.point) continue;
            this.cellMap.put(layer.getId() + LayerBean.LABEL_SUFFIX, new LayerTileCutterCell(layer, LAYER_TYPE.label));
        }
    }

    private void validateDatasetFilter(ILayer layer) {
        try {
            ILayerLevel layerLevel = (ILayerLevel)layer.getLevelMap().get(this.mainLevel);
            IDataSet datset = layerLevel.getDataSet();
            String dsFilter = datset.getFilter();
            if (StringUtils.isNotEmpty((CharSequence)dsFilter) && dsFilter.contains("\"")) {
                dsFilter = dsFilter.replace("\"", "'");
                ((DataSetShell)datset).getDataSet().setFilter(dsFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isLayerVisible(ILayer layer) {
        int start = this.mainLevel;
        int end = this.mainLevel + this.down;
        for (int i = start; i <= end; ++i) {
            Map levelMap = layer.getLevelMap();
            if (!levelMap.containsKey(i)) {
                if (layer.getBeginLevel() > end || layer.getEndLevel() < start) {
                    logger.info("\u56fe\u5c42 {} \u4e0d\u5728\u74e6\u7247\u9884\u70ed\u5c42\u7ea7\u8303\u56f4 {}~{} \u5185", new Object[]{layer.getId(), start, end});
                    return false;
                }
                return true;
            }
            String currLevelFilter = ((ILayerLevel)layer.getLevelMap().get(i)).getFilterExpression();
            if ("1 = 2".equals(currLevelFilter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object[]> cut(GridExtent extent, TileCutOptions options) throws Exception {
        CompletableFuture<List<Object[]>> allData = this.cutAsync(extent, options);
        if (allData == null) {
            return null;
        }
        allData.exceptionally(e -> {
            throw new RuntimeException();
        });
        allData.join();
        return allData.get();
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.cellMap.values().forEach(tileCutterCell -> tileCutterCell.cancel());
    }

    public IVectorService getServer() {
        return this.server;
    }

    @Override
    public boolean isCancel() {
        return this.cancel;
    }

    public boolean isReturnWriter() {
        return this.returnWriter;
    }

    public void setReturnWriter(boolean returnWriter) {
        this.returnWriter = returnWriter;
    }

    protected CompletableFuture<List<Object[]>> getEmptyPromise() {
        CompletableFuture<List<Object[]>> promise = CompletableFuture.supplyAsync(() -> null);
        return promise;
    }
}

