/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.utils;

import com.geoway.vtile.exception.ServerException;
import com.geoway.vtile.spatial.grid.extent.Extent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public class GeometryUtils {
    static final ThreadLocal<WKTReader> wktReaderLocal = new ThreadLocal();
    static final ThreadLocal<WKBReader> wkbReaderLocal = new ThreadLocal();
    static GeometryFactory factory = new GeometryFactory();

    public static Geometry getGeometryFromWkt(String source) {
        if (source == null || "".equals(source)) {
            return null;
        }
        Geometry geom = null;
        try {
            geom = GeometryUtils.getWktReader().read(source);
        }
        catch (ParseException e) {
            throw new ServerException(e.getMessage());
        }
        return geom;
    }

    public static Geometry getGeometryFromWkb(byte[] wkb) {
        if (wkb == null || wkb.length == 0) {
            return null;
        }
        Geometry geom = null;
        try {
            geom = GeometryUtils.getWkbReader().read(wkb);
        }
        catch (ParseException e) {
            throw new ServerException(e.getMessage());
        }
        return geom;
    }

    public static double[] getDoubleArrayFromExtent4Point(Extent.Extent4Point extent4Point) {
        double[] arr = new double[]{extent4Point.left_top.x, extent4Point.left_top.y, extent4Point.right_top.x, extent4Point.right_top.y, extent4Point.right_bottom.x, extent4Point.right_bottom.y, extent4Point.left_bottom.x, extent4Point.left_bottom.y, extent4Point.left_top.x, extent4Point.left_top.y};
        return arr;
    }

    public static Geometry getPolygonFromPoints(double[] points) {
        if (points == null) {
            return null;
        }
        int size = points.length / 2;
        Coordinate[] coordinates = new Coordinate[size];
        Coordinate coordinate = null;
        for (int i = 0; i < size; ++i) {
            coordinates[i] = coordinate = new Coordinate(points[i * 2], points[i * 2 + 1]);
        }
        CoordinateArraySequence cs = new CoordinateArraySequence(coordinates);
        return factory.createPolygon((CoordinateSequence)cs);
    }

    public static double[][] getPointsFromGeometry(Geometry geometry) {
        double[][] darr = new double[1][];
        for (int i = 0; i < 1; ++i) {
            Coordinate[] cc = geometry.getCoordinates();
            int cclength = cc.length;
            double[] subArr = new double[cclength * 2];
            for (int j = 0; j < cclength; ++j) {
                Coordinate c = cc[j];
                subArr[j * 2] = c.x;
                subArr[j * 2 + 1] = c.y;
            }
            darr[i] = subArr;
        }
        return darr;
    }

    public static WKTReader getWktReader() {
        WKTReader reader = wktReaderLocal.get();
        if (reader == null) {
            reader = new WKTReader();
            wktReaderLocal.set(reader);
        }
        return reader;
    }

    public static WKBReader getWkbReader() {
        WKBReader reader = wkbReaderLocal.get();
        if (reader == null) {
            reader = new WKBReader();
            wkbReaderLocal.set(reader);
        }
        return reader;
    }
}

