/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cellv4;

import com.geoway.vtile.commons.util.StringUtility;
import com.geoway.vtile.resources.MongodbDao;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cellv4.LayerFilterSchema;
import com.mongodb.client.FindIterable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileOptimizer {
    private static Logger logger = LoggerFactory.getLogger(TileOptimizer.class);
    private static final String F_X = "fx";
    private static final String F_Y = "fy";
    private static final String F_LEVEL = "flevel";
    private static final String F_DATA = "fdata1";
    private MongodbDao mogoDao;
    private Map<Integer, Map<String, Boolean>> emptyGridMap;
    private Map<String, LayerFilterSchema> layerFilters;
    private boolean _bBatchLevel = false;
    private boolean _allLayerSameFilter = false;

    public Map<String, LayerFilterSchema> getLayerFilters() {
        return this.layerFilters;
    }

    public void setLayerFilters(Map<String, LayerFilterSchema> layerFilters) {
        this.layerFilters = layerFilters;
    }

    public boolean isEnableBatchLevel() {
        return this._bBatchLevel;
    }

    public void setEnableBatchLevel(boolean isEnable) {
        this._bBatchLevel = isEnable;
    }

    public boolean isAllLayerSameFilter() {
        return this._allLayerSameFilter;
    }

    public void setAllLayerSameFilter(boolean _allLayerSameFilter) {
        this._allLayerSameFilter = _allLayerSameFilter;
    }

    public TileOptimizer(MongodbDao tileDao) {
        this.mogoDao = tileDao;
    }

    public TileOptimizer(String mgtileDBUrl, String tableName) {
        MongodbDataSource mongodbDataSource = new MongodbDataSource(mgtileDBUrl);
        this.mogoDao = mongodbDataSource.factory().getDao(tableName);
    }

    public boolean hasTileAtLevel(int level) {
        return this.getTilesCountAtLevel(level) >= 1L;
    }

    public boolean existsTile(String x_y_z) {
        String[] args = x_y_z.split("_", 3);
        return this.existsTile(Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]));
    }

    public boolean existsTile(int x, int y, int level) {
        try {
            Document query = new Document(F_LEVEL, (Object)level).append(F_X, (Object)x).append(F_Y, (Object)y);
            Document outfileds = new Document("_id", (Object)1);
            Document one = this.mogoDao.findone((Bson)query, (Bson)outfileds);
            return one != null;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("\u74e6\u7247\u5e93\u67e5\u8be2\u51fa\u9519\uff1a" + ex.getMessage());
        }
    }

    public Long getTilesCountAtLevel(int level) {
        try {
            Document data = new Document(F_LEVEL, (Object)level);
            return this.mogoDao.count((Bson)data);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return -1L;
        }
    }

    public Set<String> loadTileKeys(int level) {
        try {
            Document query = new Document(F_LEVEL, (Object)level);
            Document outfileds = new Document("_id", (Object)0).append(F_X, (Object)1).append(F_Y, (Object)1).append(F_LEVEL, (Object)1);
            FindIterable resultIter = this.mogoDao.findCollection((Bson)query, (Bson)outfileds);
            if (null == resultIter) {
                return null;
            }
            HashSet<String> keyset = new HashSet<String>();
            for (Document doc : resultIter) {
                String tileKey = String.format("%d_%d_%d", doc.get((Object)F_X), doc.get((Object)F_Y), doc.get((Object)F_LEVEL));
                keyset.add(tileKey);
            }
            return keyset;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("\u74e6\u7247\u5e93\u67e5\u8be2\u51fa\u9519\uff1a" + ex.getMessage());
        }
    }

    public TileOptimizer registerEmptyGrid(GridExtent tileGrid) {
        Integer l;
        Map<String, Boolean> mapOfLevel;
        if (null == this.emptyGridMap) {
            this.emptyGridMap = new HashMap<Integer, Map<String, Boolean>>();
        }
        if (null == (mapOfLevel = this.emptyGridMap.get(l = Integer.valueOf(tileGrid.getLevel())))) {
            mapOfLevel = new HashMap<String, Boolean>();
            this.emptyGridMap.put(l, mapOfLevel);
        }
        mapOfLevel.put(tileGrid.getCodeXYL(), false);
        return this;
    }

    public boolean containsEmptyGrid(GridExtent extent) {
        if (null == this.emptyGridMap) {
            return false;
        }
        Integer l = extent.getLevel();
        return this.emptyGridMap.containsKey(l) && this.emptyGridMap.get(l).containsKey(extent.getCodeXYL());
    }

    public boolean isGridParentEmpty(GridExtent extent) {
        if (null == extent) {
            return false;
        }
        if (null == this.emptyGridMap) {
            return false;
        }
        int x = extent.getX();
        int y = extent.getY();
        int level = extent.getLevel();
        int parentX = x / 2;
        int parentY = y / 2;
        int parentL = level - 1;
        String key = String.format("%d_%d_%d", parentX, parentY, parentL);
        return this.emptyGridMap.containsKey(parentL) && this.emptyGridMap.get(parentL).containsKey(key);
    }

    public boolean isSameFilterAtLevels(int beginLevel, int endLevel) {
        if (null == this.layerFilters || 0 == this.layerFilters.size() || endLevel < beginLevel) {
            return false;
        }
        if (beginLevel == endLevel) {
            return true;
        }
        if (this._allLayerSameFilter) {
            return true;
        }
        for (String layerName : this.layerFilters.keySet()) {
            LayerFilterSchema lsc = this.layerFilters.get(layerName);
            for (int i = beginLevel + 1; i <= endLevel; ++i) {
                if (!StringUtility.equals((String)lsc.baseFilters[i], (String)lsc.baseFilters[beginLevel]).booleanValue()) {
                    return false;
                }
                if (StringUtility.equals((String)lsc.labelFilters[i], (String)lsc.labelFilters[beginLevel]).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public void clearAll() {
        if (null != this.layerFilters) {
            this.layerFilters.clear();
        }
        if (null != this.emptyGridMap) {
            for (Integer key : this.emptyGridMap.keySet()) {
                Map<String, Boolean> subMap = this.emptyGridMap.get(key);
                if (null == subMap) continue;
                subMap.clear();
            }
            this.emptyGridMap.clear();
        }
    }
}

