/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.abstractclass;

import com.geoway.vtile.model.vector_service.layer.LayerLevelBean;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.dataholder.ExtentDataHolder;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import com.geoway.vtile.transform.writer.Writer;
import java.util.HashMap;
import java.util.Map;

public abstract class ExtentDataHolderArrayImpl
implements ExtentDataHolderArray {
    protected GridExtent mainGridExtent;
    protected int downLevel;
    protected ExtentDataHolder[] extentDataHolderArr;
    protected Map<Integer, Boolean> saveMap = null;
    protected Map<Integer, Boolean> ignoreOnePointFeatureMap = null;
    protected Map<Integer, Double> simplifyMap = null;
    protected ExtentDataHolder mainHolder;
    protected int beginLevel;
    protected int endLevel;
    protected Class<? extends Writer> writerClazz;

    public ExtentDataHolderArrayImpl(GridExtent mainGridExtent, int downLevel, Class<? extends Writer> writerClazz) {
        this.mainGridExtent = mainGridExtent;
        this.downLevel = downLevel;
        this.writerClazz = writerClazz;
        this.buildExtentArray(mainGridExtent, downLevel);
    }

    protected abstract void buildExtentArray(GridExtent var1, int var2);

    @Override
    public int getDownLevel() {
        return this.downLevel;
    }

    @Override
    public GridExtent getMainGridExtent() {
        return this.mainGridExtent;
    }

    @Override
    public void begin() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.begin();
        }
    }

    @Override
    public void boxsetReset() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.boxsetReset();
        }
    }

    @Override
    public void next() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.next();
        }
    }

    @Override
    public void end() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.end();
        }
    }

    @Override
    public void beginFeature() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.beginFeature();
        }
    }

    @Override
    public void endFeature() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.endFeature();
        }
    }

    public ExtentDataHolder[] getExtentDataHolderArr() {
        return this.extentDataHolderArr;
    }

    @Override
    public Boolean isSave(Integer level) {
        return this.saveMap.get(level);
    }

    public int getBeginLevel() {
        return this.beginLevel;
    }

    @Override
    public void resetProcessedCache() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.resetProcessedCache();
        }
    }

    @Override
    public Double getSimplify(Integer level) {
        Double simplify = this.simplifyMap.get(level);
        if (simplify == null) {
            return LayerLevelBean.DEFAULT_SIMPLIFY_VALUE;
        }
        return simplify;
    }

    @Override
    public Boolean isIgnoreOnePointFeature(Integer level) {
        return this.ignoreOnePointFeatureMap.get(level);
    }

    @Override
    public ExtentDataHolder getMainHolder() {
        return this.mainHolder;
    }

    @Override
    public void featureMunltiGeometryNextPart() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.featureMunltiGeometryNextPart();
        }
    }

    @Override
    public void setPropertys(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        Object part = this.getMainHolder().getWriter().createPropertysPart(geoType, propertyFields, propertyObject);
        if (null == part) {
            for (ExtentDataHolder holder : this.extentDataHolderArr) {
                holder.setPropertys(geoType, propertyFields, propertyObject);
            }
        } else {
            for (ExtentDataHolder holder : this.extentDataHolderArr) {
                holder.setGeoType(geoType);
                holder.setPropertysPart(part);
            }
        }
    }

    protected Map<Integer, Double> createEmptySimplifyMap(GridExtent mainGridExtent, int downLevel, Double defaultSimplify) {
        int beginLevel = mainGridExtent.getLevel();
        HashMap<Integer, Double> simplifyMap = new HashMap<Integer, Double>();
        int size = beginLevel + downLevel;
        for (int level = beginLevel; level <= size; ++level) {
            simplifyMap.put(level, defaultSimplify);
        }
        return simplifyMap;
    }

    protected Map<Integer, Boolean> createEmptySaveMap(GridExtent mainGridExtent, int downLevel) {
        int beginLevel = mainGridExtent.getLevel();
        HashMap<Integer, Boolean> saveMap = new HashMap<Integer, Boolean>();
        int size = beginLevel + downLevel;
        for (int level = beginLevel; level <= size; ++level) {
            saveMap.put(level, true);
        }
        return saveMap;
    }

    protected Map<Integer, Boolean> createEmptyIgnoreOnePointFeatureMap(GridExtent mainGridExtent, int downLevel) {
        int beginLevel = mainGridExtent.getLevel();
        HashMap<Integer, Boolean> ignoreOnePointFeature = new HashMap<Integer, Boolean>();
        int size = beginLevel + downLevel;
        for (int level = beginLevel; level <= size; ++level) {
            ignoreOnePointFeature.put(level, true);
        }
        return ignoreOnePointFeature;
    }

    @Override
    public void setSaveMap(Map<Integer, Boolean> saveMap) {
        this.saveMap = saveMap == null ? this.createEmptySaveMap(this.mainGridExtent, this.downLevel) : saveMap;
    }

    @Override
    public void setSimplifyMap(Map<Integer, Double> simplifyMap) {
        this.simplifyMap = simplifyMap == null ? this.createEmptySimplifyMap(this.mainGridExtent, this.downLevel, 0.1) : simplifyMap;
    }

    @Override
    public void setIgnoreOnePointFeatureMap(Map<Integer, Boolean> ignoreOnePointFeatureMap) {
        this.ignoreOnePointFeatureMap = this.simplifyMap == null ? this.createEmptyIgnoreOnePointFeatureMap(this.mainGridExtent, this.downLevel) : ignoreOnePointFeatureMap;
    }

    @Override
    public void setCutOutScreen(Boolean cutOutScreen) {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.setCutOutScreen(cutOutScreen);
        }
    }

    @Override
    public void beginPath() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.beginPath();
        }
    }

    @Override
    public void endPath() {
        for (ExtentDataHolder holder : this.extentDataHolderArr) {
            holder.endPath();
        }
    }

    @Override
    public void setExtentDataHolderArr(ExtentDataHolder[] extentDataHolderArr) {
        this.extentDataHolderArr = extentDataHolderArr;
    }
}

