/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell.process;

import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.process.AbstractProcesser;
import com.geoway.vtile.transform.cell.process.IProcesser;
import com.geoway.vtile.transform.dataholder.bucket.BucketHolder;
import com.geoway.vtile.transform.dataholder.metrics.ObjectArrayMetricsHolder;
import com.geoway.vtile.transform.tools.CTerranArea;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.overlay.OverlayOp;

public class AreaStatisProcesser
extends AbstractProcesser<GeoBuffer>
implements IProcesser<GeoBuffer> {
    String[] groupFields;
    BucketHolder bucketHolder;
    GridExtent extent;
    String wkt;

    public AreaStatisProcesser(ITileCutterCell cell, ILayer layer, String[] groupFields, BucketHolder bucketHolder, GridExtent extent) {
        super(cell, layer);
        this.bucketHolder = bucketHolder;
        this.groupFields = groupFields;
        this.extent = extent;
        this.wkt = extent.getWkt();
    }

    @Override
    public void process(List<Object[]> dataArr, String[] propertyFields, int idIndex, int spatialIndex) {
        propertyFields = (String[])ArrayUtils.remove((Object[])propertyFields, (int)spatialIndex);
        ArrayList<ObjectArrayMetricsHolder> list = new ArrayList<ObjectArrayMetricsHolder>(dataArr.size());
        for (Object[] data : dataArr) {
            if (this.cell.isCancel()) {
                return;
            }
            GeoBuffer geo = ((Geom)data[spatialIndex]).toGeoBuffer();
            data = ArrayUtils.remove((Object[])data, (int)spatialIndex);
            WKTReader wktReader = new WKTReader();
            Geometry extentGeom = null;
            try {
                extentGeom = wktReader.read(this.wkt);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Geometry geometry = geo.toJTSGeometry();
            OverlayOp op = new OverlayOp(extentGeom, geometry);
            Geometry intersectArea = op.getResultGeometry(1);
            double area = CTerranArea.CalculateTerranArea(intersectArea);
            list.add(new ObjectArrayMetricsHolder(area, data));
        }
    }
}

