/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.task;

import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.bean.ExtentGeometry;
import com.geoway.vtile.transform.utils.GeometryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.RecursiveTask;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlay.OverlayOp;

public class ExtentGeometryForkTask
extends RecursiveTask<List<ExtentGeometry>> {
    public static final double[] areas = new double[]{518400.0, 129600.0, 32400.0, 8100.0, 2025.0, 506.25, 126.5625, 31.640625, 7.91015625, 1.9775390625, 0.494384765625, 0.12359619140625, 0.0308990478515625, 0.007724761962890625, 0.0019311904907226562, 4.8279762268066406E-4, 1.2069940567016602E-4, 3.0174851417541504E-5, 7.543712854385376E-6, 1.885928213596344E-6};
    ExtentGeometry holder;
    IGridSystem grid;
    Integer endLevel;

    public ExtentGeometryForkTask(ExtentGeometry eg, IGridSystem grid, Integer endLevel) {
        this.holder = eg;
        this.grid = grid;
        this.endLevel = endLevel;
    }

    @Override
    protected List compute() {
        if (this.holder.getExtent().getLevel() < this.endLevel && this.holder.isFull()) {
            ArrayList<ExtentGeometry> l = new ArrayList<ExtentGeometry>(1);
            l.add(this.holder);
            return l;
        }
        ArrayList<ExtentGeometry> result = new ArrayList<ExtentGeometry>();
        Integer subLevel = this.holder.getExtent().getLevel() + 1;
        if (this.endLevel - subLevel < 4) {
            ArrayList<ExtentGeometry> currentLevelExtents = new ArrayList<ExtentGeometry>(1);
            currentLevelExtents.add(this.holder);
            for (int currentSubLevel = subLevel.intValue(); currentSubLevel <= this.endLevel; ++currentSubLevel) {
                ArrayList<ExtentGeometry> nextLevelExtents = new ArrayList<ExtentGeometry>(4);
                for (ExtentGeometry extentGeometry : currentLevelExtents) {
                    List<GridExtent> sub = ExtentGeometryForkTask.buildDownArray(extentGeometry.getExtent(), this.grid);
                    for (GridExtent subExtent : sub) {
                        if (extentGeometry.isFull()) {
                            result.add(new ExtentGeometry(subExtent, ExtentGeometryForkTask.getGeometryByExtent(subExtent), true));
                            continue;
                        }
                        Geometry extentGeom = ExtentGeometryForkTask.getGeometryByExtent(subExtent);
                        Geometry intersection = ExtentGeometryForkTask.getIntersectionWithExtent(extentGeometry.getGeometry(), extentGeom);
                        if (intersection == null || intersection.isEmpty()) continue;
                        boolean isFull = extentGeom.coveredBy(intersection);
                        ExtentGeometry subHolder = new ExtentGeometry(subExtent, intersection, isFull);
                        if (isFull) {
                            result.add(subHolder);
                            continue;
                        }
                        nextLevelExtents.add(subHolder);
                    }
                }
                currentLevelExtents = nextLevelExtents;
            }
            result.addAll(currentLevelExtents);
        } else {
            List<GridExtent> sub = ExtentGeometryForkTask.buildDownArray(this.holder.getExtent(), this.grid);
            ArrayList<ExtentGeometryForkTask> tasks = new ArrayList<ExtentGeometryForkTask>(4);
            for (GridExtent subExtent : sub) {
                Geometry extentGeom = ExtentGeometryForkTask.getGeometryByExtent(subExtent);
                Geometry intersection = ExtentGeometryForkTask.getIntersectionWithExtent(this.holder.getGeometry(), extentGeom);
                if (intersection == null || intersection.isEmpty()) continue;
                boolean isFull = extentGeom.coveredBy(intersection);
                ExtentGeometry subHolder = new ExtentGeometry(subExtent, intersection, isFull);
                if (subExtent.getLevel() < this.endLevel && isFull) {
                    result.add(subHolder);
                    continue;
                }
                if (subExtent.getLevel() == this.endLevel.intValue()) {
                    result.add(subHolder);
                    continue;
                }
                ExtentGeometryForkTask forkTask = new ExtentGeometryForkTask(subHolder, this.grid, this.endLevel);
                tasks.add(forkTask);
                forkTask.fork();
            }
            for (ExtentGeometryForkTask forkTask : tasks) {
                result.addAll((Collection)forkTask.join());
            }
        }
        return result;
    }

    private static List<GridExtent> buildDownArray(GridExtent extent, IGridSystem grid) {
        ArrayList<GridExtent> list = new ArrayList<GridExtent>();
        int x = extent.getX();
        int y = extent.getY();
        int l = extent.getLevel() + 1;
        GridExtent extent0 = grid.getExtent(l, x * 2, y * 2);
        GridExtent extent1 = grid.getExtent(l, x * 2 + 1, y * 2);
        GridExtent extent2 = grid.getExtent(l, x * 2, y * 2 + 1);
        GridExtent extent3 = grid.getExtent(l, x * 2 + 1, y * 2 + 1);
        list.add(extent0);
        list.add(extent1);
        list.add(extent2);
        list.add(extent3);
        return list;
    }

    private static Integer getLevelByArea(double area, int level) {
        for (int i = 0; i < level; ++i) {
            if (!(area > areas[i])) continue;
            return i;
        }
        return level;
    }

    private static Geometry getIntersectionWithExtent(Geometry geometry, Geometry extentGeom) {
        OverlayOp op = new OverlayOp(extentGeom, geometry);
        Geometry intersectArea = op.getResultGeometry(1);
        return intersectArea;
    }

    private static Geometry getGeometryByExtent(GridExtent extent) {
        double[] points = GeometryUtils.getDoubleArrayFromExtent4Point(extent.getBBoxCoordinates());
        return GeometryUtils.getPolygonFromPoints(points);
    }
}

