/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.shovel.label;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.geofeature.GeoPart;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.transform.ScreenLoction;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import com.geoway.vtile.transform.dataholder.shovel.label.AbstractLineLoction;

public class ScreenLoctionLineLabel
extends AbstractLineLoction
implements ScreenLoction {
    public ScreenLoctionLineLabel(IGridSystem grid, int beginLevel, int endLevel, int minCutPixel, int minCutPoint, int base) {
        super(grid, beginLevel, endLevel, minCutPixel, minCutPoint, base);
    }

    @Override
    public void toScreenLoction(GeoBuffer geo, ExtentDataHolderArray holderArray, String[] propertyFields, Object[] propertyObject, int idIndex) {
        this.featureBegin(holderArray);
        switch (geo.getGeoType()) {
            case POINT: {
                this.doError();
                break;
            }
            case LINESTRING: {
                this.dealWithLineString(geo, holderArray);
                break;
            }
            case POLYGON: {
                this.doError();
                break;
            }
            case MULTIPOINT: {
                this.doError();
                break;
            }
            case MULTILINESTRING: {
                this.dealWithMultiLine(geo, holderArray);
                break;
            }
            case MULTIPOLYGON: {
                this.doError();
                break;
            }
            default: {
                this.doError();
            }
        }
        this.setPropertys(geo.getGeoType(), holderArray, propertyFields, propertyObject);
        this.featureEnd(holderArray);
    }

    private void dealWithLineString(GeoBuffer geo, ExtentDataHolderArray gridArray) {
        DoubleBuilder doubleBuilder = ((GeoPart)geo.getPartList().get(0)).getDoubleBuilder();
        this.dealWithLine(doubleBuilder, gridArray);
    }

    private void dealWithMultiLine(GeoBuffer geo, ExtentDataHolderArray gridArray) {
        geo.getPartList().forEach(part -> {
            DoubleBuilder doubleBuilder = part.getDoubleBuilder();
            if (doubleBuilder.size() == 2) {
                return;
            }
            this.dealWithLine(doubleBuilder, gridArray);
        });
    }
}

