/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.spatial.tool.SimpleGISTool;
import java.util.ArrayList;
import java.util.List;

public class Boxset {
    public static final int ZONE_L = 1;
    public static final int ZONE_LB = 2;
    public static final int ZONE_B = 3;
    public static final int ZONE_RB = 4;
    public static final int ZONE_R = 5;
    public static final int ZONE_RT = 6;
    public static final int ZONE_T = 7;
    public static final int ZONE_LT = 8;
    public static final int ZONE_IN = 9;
    public static final int ASSERT_SAVE = 1;
    public static final int ASSERT_QUESTION = 2;
    public static final int IN = 1;
    public static final int OUT = 2;
    private static final int NONE = 0;
    boolean[][] ASSERT_CROSS_TABLE = new boolean[][]{{false, false, true, true, true, true, true, false, true}, {false, false, false, false, true, true, true, false, true}, {true, false, false, false, true, true, true, true, true}, {true, false, false, false, false, false, true, true, true}, {true, true, true, false, false, false, true, true, true}, {true, true, true, false, false, false, false, false, true}, {true, true, true, true, true, false, false, false, true}, {false, false, true, true, true, false, false, false, true}, {true, true, true, true, true, true, true, true, true}};
    private GridExtent extent;
    private final double left;
    private final double bottom;
    private final double right;
    private final double top;
    private final double[] topLine;
    private final double[] bottomLine;
    private final double[] leftLine;
    private final double[] rightLine;
    private boolean include = true;
    public Node _first = new Node();
    public Node _previous = new Node();
    public Node _now = new Node();
    private Node _question = new Node();

    public double getLeft() {
        return this.left;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getRight() {
        return this.right;
    }

    public double getTop() {
        return this.top;
    }

    public Boolean getInclude() {
        return this.include;
    }

    public GridExtent getExtent() {
        return this.extent;
    }

    public Boxset(GridExtent extent, Integer bufferPercent) {
        if (bufferPercent == null) {
            bufferPercent = 5;
        }
        double buffer = extent.getBuffer(bufferPercent.intValue());
        this.left = extent.getLeft() - buffer;
        this.right = extent.getRight() + buffer;
        this.bottom = extent.getBottom() - buffer;
        this.top = extent.getTop() + buffer;
        this.topLine = new double[]{this.left, this.top, this.right, this.top};
        this.bottomLine = new double[]{this.left, this.bottom, this.right, this.bottom};
        this.leftLine = new double[]{this.left, this.bottom, this.left, this.top};
        this.rightLine = new double[]{this.right, this.bottom, this.right, this.top};
        this.extent = extent;
    }

    public boolean in(double x, double y) {
        if (x < this.left || x > this.right) {
            return false;
        }
        return !(y < this.bottom) && !(y > this.top);
    }

    public boolean on(double x, double y) {
        return x == this.left || x == this.right || y == this.bottom || y == this.top;
    }

    public boolean onEdge(double x, double y, double[] edge) {
        if (Boxset.doubleEqual(x, edge[0])) {
            return edge[1] < y && y < edge[3];
        }
        if (Boxset.doubleEqual(y, edge[1])) {
            return edge[0] < x && x < edge[2];
        }
        return false;
    }

    public void reset() {
        this._previous.reset();
        this._question.reset();
        this._now.reset();
        this._first.reset();
    }

    public int passrule(int priorZone, int nowZone) {
        if (priorZone < 1 || nowZone < 1) {
            return 1;
        }
        boolean flag = this.ASSERT_CROSS_TABLE[priorZone - 1][nowZone - 1];
        return flag ? 1 : 2;
    }

    public static int zoneOf(double x, double y, Boxset bs) {
        if (x < bs.left) {
            if (y > bs.top) {
                return 8;
            }
            if (y < bs.bottom) {
                return 2;
            }
            return 1;
        }
        if (x > bs.right) {
            if (y > bs.top) {
                return 6;
            }
            if (y < bs.bottom) {
                return 4;
            }
            return 5;
        }
        if (y > bs.top) {
            return 7;
        }
        if (y < bs.bottom) {
            return 3;
        }
        return 9;
    }

    public static boolean isEmpty(double[] array) {
        if (array == null) {
            return true;
        }
        return array[0] == Double.MAX_VALUE && array[1] == Double.MAX_VALUE;
    }

    public static double[] createEmptyDoubleArray() {
        return new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
    }

    public double[] push(double x, double y, DoubleBuilder xPointCoords) {
        this._now.assign(x, y, Boxset.zoneOf(x, y, this));
        boolean previousEmpty = this._previous.isEmpty();
        boolean questionEmpty = this._question.isEmpty();
        if (previousEmpty && questionEmpty) {
            if (this._now.zone == 9) {
                this._previous.assignWith(this._now);
                return new double[]{this._now.x, this._now.y};
            }
            this._first.assignWith(this._now);
            this._question.assignWith(this._now);
            return null;
        }
        if (previousEmpty && !questionEmpty) {
            if (1 == this.passrule(this._question.zone, this._now.zone)) {
                return this.handleFirstQuestionAndNow(xPointCoords);
            }
            if (1 == this.passrule(this._first.zone, this._now.zone)) {
                return this.handleFirstQuestionAndNow(xPointCoords);
            }
            this._question.assignWith(this._now);
            return null;
        }
        if (1 == this.passrule(this._previous.zone, this._now.zone)) {
            if (!questionEmpty) {
                return this.handlePriorQuestionAndNow(xPointCoords);
            }
            double[] returnPoint = this.calcIntersections(this._previous, this._now, xPointCoords);
            this._previous.assignWith(this._now);
            return returnPoint;
        }
        if (!questionEmpty && 1 == this.passrule(this._question.zone, this._now.zone)) {
            return this.handlePriorQuestionAndNow(xPointCoords);
        }
        this._question.assignWith(this._now);
        return null;
    }

    private double[] handlePriorQuestionAndNow(DoubleBuilder xPointCoords) {
        double[] crossPoint_Previous_Question = this.calcIntersections(this._previous, this._question, xPointCoords);
        double[] crossPoint_Question_Now = this.calcIntersections(this._question, this._now, xPointCoords);
        double[] returnPoint = null;
        returnPoint = crossPoint_Previous_Question == null ? crossPoint_Question_Now : (crossPoint_Question_Now == null ? crossPoint_Previous_Question : Boxset.combineDoubleArray(crossPoint_Previous_Question, crossPoint_Question_Now));
        this._question.reset();
        this._previous.assignWith(this._now);
        return returnPoint;
    }

    private double[] handleFirstQuestionAndNow(DoubleBuilder xPointCoords) {
        double[] crossPoint_frist_question = this.calcIntersections(this._first, this._question, xPointCoords);
        double[] crossPoint_question_now = this.calcIntersections(this._question, this._now, xPointCoords);
        double[] returnPoint = Boxset.combineDoubleArray(crossPoint_frist_question, crossPoint_question_now);
        this._question.reset();
        this._previous.assignWith(this._now);
        return returnPoint;
    }

    private double[] calcIntersections(Node a, Node b, DoubleBuilder xPointCoords) {
        double[] xret = this.calculate(a.zone, b.zone, a, b);
        if (null == xret) {
            return xret;
        }
        if (null == xPointCoords || 0 == xPointCoords.size()) {
            return xret;
        }
        int len = xPointCoords.size();
        double ppX = xPointCoords.get(len - 2);
        double ppY = xPointCoords.get(len - 1);
        double newpX = xret[0];
        double newpY = xret[1];
        if (2 == a.zone) {
            if (this.onEdge(ppX, ppY, this.leftLine) && this.onEdge(newpX, newpY, this.bottomLine) || this.onEdge(newpX, newpY, this.leftLine) && this.onEdge(ppX, ppY, this.bottomLine)) {
                xret = Boxset.combineDoubleArray(new double[]{this.left, this.bottom}, xret);
            }
        } else if (4 == a.zone) {
            if (this.onEdge(ppX, ppY, this.bottomLine) && this.onEdge(newpX, newpY, this.rightLine) || this.onEdge(newpX, newpY, this.bottomLine) && this.onEdge(ppX, ppY, this.rightLine)) {
                xret = Boxset.combineDoubleArray(new double[]{this.right, this.bottom}, xret);
            }
        } else if (6 == a.zone) {
            if (this.onEdge(ppX, ppY, this.rightLine) && this.onEdge(newpX, newpY, this.topLine) || this.onEdge(newpX, newpY, this.rightLine) && this.onEdge(ppX, ppY, this.topLine)) {
                xret = Boxset.combineDoubleArray(new double[]{this.right, this.top}, xret);
            }
        } else if (8 == a.zone && (this.onEdge(ppX, ppY, this.topLine) && this.onEdge(newpX, newpY, this.leftLine) || this.onEdge(newpX, newpY, this.topLine) && this.onEdge(ppX, ppY, this.leftLine))) {
            xret = Boxset.combineDoubleArray(new double[]{this.left, this.top}, xret);
        }
        return xret;
    }

    private double[] calculate(int firstQuadrant, int secondQuadrant, Node first, Node second) {
        switch (firstQuadrant) {
            case 1: {
                switch (secondQuadrant) {
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return new double[]{this.left, this.bottom};
                    }
                    case 3: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.bottomLine, null);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.bottom};
                    }
                    case 4: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.bottomLine, this.rightLine);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.bottom, this.right, this.bottom};
                    }
                    case 5: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.rightLine, null);
                        return crossPoints;
                    }
                    case 6: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.topLine, this.rightLine);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.top, this.right, this.top};
                    }
                    case 7: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.topLine, null);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.top};
                    }
                    case 8: {
                        return new double[]{this.left, this.top};
                    }
                    case 9: {
                        this.include = false;
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, null, null);
                        if (crossPoints == null) {
                            throw new RuntimeException("\u9519\u8bef");
                        }
                        return new double[]{crossPoints[0], crossPoints[1], second.x, second.y};
                    }
                }
                break;
            }
            case 2: {
                switch (secondQuadrant) {
                    case 2: {
                        return null;
                    }
                    case 3: {
                        return new double[]{this.left, this.bottom};
                    }
                    case 4: {
                        return new double[]{this.left, this.bottom, this.right, this.bottom};
                    }
                    case 5: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.rightLine, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.rightLine, null);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.bottom, this.right, this.bottom};
                    }
                    case 6: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.topLine, this.rightLine);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.rightLine, this.topLine);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        double[] dArray = new double[]{first.x, this.bottom, second.x, this.bottom};
                        double[] tmpLine = dArray;
                        crossPoints = this.getCrossPoint(first, second, tmpLine, null, null);
                        if (crossPoints[0] > this.right) {
                            return new double[]{this.left, this.bottom, this.right, this.bottom, this.right, this.top};
                        }
                        if (crossPoints[0] < this.left) {
                            return new double[]{this.left, this.bottom, this.left, this.top, this.right, this.top};
                        }
                        throw new RuntimeException("\u9519\u8bef");
                    }
                    case 7: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.topLine, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.topLine, null);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.bottom, this.left, this.top};
                    }
                    case 8: {
                        return new double[]{this.left, this.bottom, this.left, this.top};
                    }
                    case 1: {
                        return new double[]{this.left, this.bottom};
                    }
                    case 9: {
                        this.include = false;
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, null, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.bottomLine, null, null);
                        }
                        if (crossPoints == null) {
                            throw new RuntimeException("error");
                        }
                        return new double[]{this.left, this.bottom, crossPoints[0], crossPoints[1], second.x, second.y};
                    }
                }
                break;
            }
            case 3: {
                switch (secondQuadrant) {
                    case 3: {
                        return null;
                    }
                    case 4: {
                        return new double[]{this.right, this.bottom};
                    }
                    case 5: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.rightLine, null);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.bottom};
                    }
                    case 6: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.rightLine, this.topLine);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.bottom, this.right, this.top};
                    }
                    case 7: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.topLine, null);
                        return crossPoints;
                    }
                    case 8: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.leftLine, this.topLine);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.bottom, this.left, this.top};
                    }
                    case 1: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.leftLine, null);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.bottom};
                    }
                    case 2: {
                        return new double[]{this.left, this.bottom};
                    }
                    case 9: {
                        this.include = false;
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, null, null);
                        if (crossPoints == null) {
                            throw new RuntimeException("\u9519\u8bef");
                        }
                        return new double[]{crossPoints[0], crossPoints[1], second.x, second.y};
                    }
                }
                break;
            }
            case 4: {
                switch (secondQuadrant) {
                    case 4: {
                        return null;
                    }
                    case 5: {
                        return new double[]{this.right, this.bottom};
                    }
                    case 6: {
                        return new double[]{this.right, this.bottom, this.right, this.top};
                    }
                    case 7: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.topLine, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.topLine, null);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.bottom, this.right, this.top};
                    }
                    case 8: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.topLine, this.leftLine);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.topLine, this.leftLine);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        double[] dArray = new double[]{first.x, this.bottom, second.x, this.bottom};
                        double[] tmpLine = dArray;
                        crossPoints = this.getCrossPoint(first, second, tmpLine, null, null);
                        if (crossPoints[0] > this.right) {
                            return new double[]{this.right, this.bottom, this.right, this.top, this.left, this.top};
                        }
                        if (crossPoints[0] < this.left) {
                            return new double[]{this.right, this.bottom, this.left, this.bottom, this.left, this.top};
                        }
                        throw new RuntimeException("\u9519\u8bef");
                    }
                    case 1: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.leftLine, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.bottomLine, this.leftLine, null);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.bottom, this.left, this.bottom};
                    }
                    case 2: {
                        return new double[]{this.right, this.bottom, this.left, this.bottom};
                    }
                    case 3: {
                        return new double[]{this.right, this.bottom};
                    }
                    case 9: {
                        this.include = false;
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, null, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.rightLine, null, null);
                        }
                        if (crossPoints == null) {
                            throw new RuntimeException("error");
                        }
                        return new double[]{this.right, this.bottom, crossPoints[0], crossPoints[1], second.x, second.y};
                    }
                }
                break;
            }
            case 5: {
                switch (secondQuadrant) {
                    case 5: {
                        return null;
                    }
                    case 6: {
                        return new double[]{this.right, this.top};
                    }
                    case 7: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.topLine, null);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.top};
                    }
                    case 8: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.topLine, this.leftLine);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.top, this.left, this.top};
                    }
                    case 1: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.leftLine, null);
                        return crossPoints;
                    }
                    case 2: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.leftLine, this.bottomLine);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.bottom, this.left, this.bottom};
                    }
                    case 3: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.bottomLine, null);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.bottom};
                    }
                    case 4: {
                        return new double[]{this.right, this.bottom};
                    }
                    case 9: {
                        this.include = false;
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, null, null);
                        if (crossPoints == null) {
                            throw new RuntimeException("\u9519\u8bef");
                        }
                        return new double[]{crossPoints[0], crossPoints[1], second.x, second.y};
                    }
                }
                break;
            }
            case 6: {
                switch (secondQuadrant) {
                    case 6: {
                        return null;
                    }
                    case 7: {
                        return new double[]{this.right, this.top};
                    }
                    case 8: {
                        return new double[]{this.right, this.top, this.left, this.top};
                    }
                    case 1: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, this.leftLine, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.rightLine, this.leftLine, null);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.top, this.left, this.top};
                    }
                    case 2: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, this.bottomLine, this.leftLine);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.topLine, this.leftLine, this.bottomLine);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        double[] dArray = new double[]{first.x, this.bottom, second.x, this.bottom};
                        double[] tmpLine = dArray;
                        crossPoints = this.getCrossPoint(first, second, tmpLine, null, null);
                        if (crossPoints[0] > this.right) {
                            return new double[]{this.right, this.top, this.right, this.bottom, this.left, this.bottom};
                        }
                        if (crossPoints[0] < this.left) {
                            return new double[]{this.right, this.top, this.left, this.top, this.left, this.bottom};
                        }
                        throw new RuntimeException("\u9519\u8bef");
                    }
                    case 3: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, this.bottomLine, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.rightLine, this.bottomLine, null);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.top, this.right, this.bottom};
                    }
                    case 4: {
                        return new double[]{this.right, this.top, this.right, this.bottom};
                    }
                    case 5: {
                        return new double[]{this.right, this.top};
                    }
                    case 9: {
                        this.include = false;
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, null, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.rightLine, null, null);
                        }
                        if (crossPoints == null) {
                            throw new RuntimeException("error");
                        }
                        return new double[]{this.right, this.top, crossPoints[0], crossPoints[1], second.x, second.y};
                    }
                }
                break;
            }
            case 7: {
                switch (secondQuadrant) {
                    case 7: {
                        return null;
                    }
                    case 8: {
                        return new double[]{this.left, this.top};
                    }
                    case 1: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, this.leftLine, null);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.top};
                    }
                    case 2: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, this.leftLine, this.bottomLine);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.top, this.left, this.bottom};
                    }
                    case 3: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, this.bottomLine, null);
                        return crossPoints;
                    }
                    case 4: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, this.rightLine, this.bottomLine);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.top, this.right, this.bottom};
                    }
                    case 5: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, this.rightLine, null);
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.right, this.top};
                    }
                    case 6: {
                        return new double[]{this.right, this.top};
                    }
                    case 9: {
                        this.include = false;
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, null, null);
                        if (crossPoints == null) {
                            throw new RuntimeException("\u9519\u8bef");
                        }
                        return new double[]{crossPoints[0], crossPoints[1], second.x, second.y};
                    }
                }
                break;
            }
            case 8: {
                switch (secondQuadrant) {
                    case 8: {
                        return null;
                    }
                    case 1: {
                        return new double[]{this.left, this.top};
                    }
                    case 2: {
                        return new double[]{this.left, this.top, this.left, this.bottom};
                    }
                    case 3: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.bottomLine, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.topLine, this.bottomLine, null);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.top, this.left, this.bottom};
                    }
                    case 4: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, this.rightLine, this.bottomLine);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.leftLine, this.rightLine, this.bottomLine);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        double[] dArray = new double[]{first.x, this.bottom, second.x, this.bottom};
                        double[] tmpLine = dArray;
                        crossPoints = this.getCrossPoint(first, second, tmpLine, null, null);
                        if (crossPoints[0] > this.right) {
                            return new double[]{this.left, this.top, this.right, this.top, this.right, this.bottom};
                        }
                        if (crossPoints[0] < this.left) {
                            return new double[]{this.left, this.top, this.left, this.bottom, this.right, this.bottom};
                        }
                        throw new RuntimeException("\u9519\u8bef");
                    }
                    case 5: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, this.rightLine, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.topLine, this.rightLine, null);
                        }
                        if (crossPoints != null) {
                            return crossPoints;
                        }
                        return new double[]{this.left, this.top, this.right, this.top};
                    }
                    case 6: {
                        return new double[]{this.left, this.top, this.right, this.top};
                    }
                    case 7: {
                        return new double[]{this.left, this.top};
                    }
                    case 9: {
                        this.include = false;
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, null, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.leftLine, null, null);
                        }
                        if (crossPoints == null) {
                            throw new RuntimeException("error");
                        }
                        return new double[]{this.left, this.top, crossPoints[0], crossPoints[1], second.x, second.y};
                    }
                }
                break;
            }
            case 9: {
                this.include = false;
                switch (secondQuadrant) {
                    case 1: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, null, null);
                        return crossPoints;
                    }
                    case 2: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.leftLine, null, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.bottomLine, null, null);
                        }
                        return crossPoints;
                    }
                    case 3: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, null, null);
                        return crossPoints;
                    }
                    case 4: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.bottomLine, null, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.rightLine, null, null);
                        }
                        return crossPoints;
                    }
                    case 5: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, null, null);
                        return crossPoints;
                    }
                    case 6: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.rightLine, null, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.topLine, null, null);
                        }
                        return crossPoints;
                    }
                    case 7: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, null, null);
                        return crossPoints;
                    }
                    case 8: {
                        double[] crossPoints = this.getCrossPoint(first, second, this.topLine, null, null);
                        if (crossPoints == null) {
                            crossPoints = this.getCrossPoint(first, second, this.leftLine, null, null);
                        }
                        return crossPoints;
                    }
                    case 9: {
                        return new double[]{second.x, second.y};
                    }
                }
            }
        }
        throw new RuntimeException("\u9519\u8bef");
    }

    private double[] getCrossPoint(Node first, Node second, double[] line1, double[] line2, double[] line3) {
        double[] crossPoints = new double[4];
        double[] crossPoint = SimpleGISTool.LINEINTERSECTS((double)first.x, (double)first.y, (double)second.x, (double)second.y, (double)line1[0], (double)line1[1], (double)line1[2], (double)line1[3]);
        if (crossPoint == null) {
            return null;
        }
        this.include = false;
        crossPoints[0] = crossPoint[0];
        crossPoints[1] = crossPoint[1];
        if (line2 == null) {
            return new double[]{crossPoints[0], crossPoints[1]};
        }
        crossPoint = SimpleGISTool.LINEINTERSECTS((double)first.x, (double)first.y, (double)second.x, (double)second.y, (double)line2[0], (double)line2[1], (double)line2[2], (double)line2[3]);
        if (crossPoint != null) {
            if (crossPoints[0] == crossPoint[0] && crossPoints[1] == crossPoint[1]) {
                return new double[]{crossPoints[0], crossPoints[1]};
            }
            crossPoints[2] = crossPoint[0];
            crossPoints[3] = crossPoint[1];
            return crossPoints;
        }
        if (line3 == null) {
            return new double[]{crossPoints[0], crossPoints[1]};
        }
        crossPoint = SimpleGISTool.LINEINTERSECTS((double)first.x, (double)first.y, (double)second.x, (double)second.y, (double)line3[0], (double)line3[1], (double)line3[2], (double)line3[3]);
        if (crossPoint != null) {
            if (crossPoints[0] == crossPoint[0] && crossPoints[1] == crossPoint[1]) {
                return new double[]{crossPoints[0], crossPoints[1]};
            }
            crossPoints[2] = crossPoint[0];
            crossPoints[3] = crossPoint[1];
            return crossPoints;
        }
        return new double[]{crossPoints[0], crossPoints[1]};
    }

    public Boolean isFull(DoubleBuilder doubleBuilder) {
        double[][] poly = new double[][]{doubleBuilder.toArray()};
        double x = this.extent.getLeft();
        double y = this.extent.getTop();
        double x1 = this.extent.getRight();
        double y1 = this.extent.getBottom();
        if (SimpleGISTool.pointInPolygon((double)x, (double)y, (double[][])poly) && SimpleGISTool.pointInPolygon((double)x1, (double)y1, (double[][])poly)) {
            return true;
        }
        return false;
    }

    private double[] getCrossPoint(double[] firstPoint, double[] secondPoint, int position) {
        switch (position) {
            case 7: {
                return SimpleGISTool.LINEINTERSECTS((double)firstPoint[0], (double)firstPoint[1], (double)secondPoint[0], (double)secondPoint[1], (double)this.topLine[0], (double)this.topLine[1], (double)this.topLine[2], (double)this.topLine[3]);
            }
            case 5: {
                return SimpleGISTool.LINEINTERSECTS((double)firstPoint[0], (double)firstPoint[1], (double)secondPoint[0], (double)secondPoint[1], (double)this.rightLine[0], (double)this.rightLine[1], (double)this.rightLine[2], (double)this.rightLine[3]);
            }
            case 3: {
                return SimpleGISTool.LINEINTERSECTS((double)firstPoint[0], (double)firstPoint[1], (double)secondPoint[0], (double)secondPoint[1], (double)this.bottomLine[0], (double)this.bottomLine[1], (double)this.bottomLine[2], (double)this.bottomLine[3]);
            }
            case 1: {
                return SimpleGISTool.LINEINTERSECTS((double)firstPoint[0], (double)firstPoint[1], (double)secondPoint[0], (double)secondPoint[1], (double)this.leftLine[0], (double)this.leftLine[1], (double)this.leftLine[2], (double)this.leftLine[3]);
            }
        }
        throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
    }

    private List<double[]> getCrossPoints(double[] firstPoint, double[] secondPoint, int[] mayCross) {
        ArrayList<double[]> list = new ArrayList<double[]>();
        for (int cross : mayCross) {
            double[] crossPoint = this.getCrossPoint(firstPoint, secondPoint, cross);
            if (crossPoint != null) {
                list.add(crossPoint);
            }
            if (list.size() == 2) break;
        }
        return list;
    }

    public List<double[]> getCrossPoints(double[] firstPoint, double[] secondPoint) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        int quadrant = Boxset.zoneOf(firstPoint[0], firstPoint[1], this);
        int quadrant1 = Boxset.zoneOf(secondPoint[0], secondPoint[1], this);
        switch (quadrant) {
            case 8: {
                switch (quadrant1) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return result;
                    }
                    case 9: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 1});
                    }
                    case 5: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 1, 5});
                    }
                    case 3: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 1, 3});
                    }
                    case 4: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 1, 3, 5});
                    }
                }
            }
            case 7: {
                switch (quadrant1) {
                    case 6: 
                    case 7: 
                    case 8: {
                        return result;
                    }
                    case 1: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 1});
                    }
                    case 9: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7});
                    }
                    case 5: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 5});
                    }
                    case 2: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 1, 3});
                    }
                    case 3: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 3});
                    }
                    case 4: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 5, 3});
                    }
                }
            }
            case 6: {
                switch (quadrant1) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return result;
                    }
                    case 1: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 5, 1});
                    }
                    case 9: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 5});
                    }
                    case 2: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 5, 1, 3});
                    }
                    case 3: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{7, 5, 3});
                    }
                }
            }
            case 1: {
                switch (quadrant1) {
                    case 1: 
                    case 2: 
                    case 8: {
                        return result;
                    }
                    case 7: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 7});
                    }
                    case 6: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 5, 7});
                    }
                    case 9: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1});
                    }
                    case 5: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 5});
                    }
                    case 3: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 3});
                    }
                    case 4: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 3, 5});
                    }
                }
            }
            case 9: {
                switch (quadrant1) {
                    case 9: {
                        return result;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{quadrant1});
                    }
                    case 2: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 3});
                    }
                    case 4: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 5});
                    }
                    case 6: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{5, 7});
                    }
                    case 8: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 7});
                    }
                }
            }
            case 5: {
                switch (quadrant1) {
                    case 4: 
                    case 5: 
                    case 6: {
                        return result;
                    }
                    case 8: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{5, 1, 7});
                    }
                    case 7: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{5, 7});
                    }
                    case 1: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{5, 1});
                    }
                    case 9: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{5});
                    }
                    case 2: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{5, 1, 3});
                    }
                    case 3: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{5, 3});
                    }
                }
            }
            case 2: {
                switch (quadrant1) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 8: {
                        return result;
                    }
                    case 7: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 3, 7});
                    }
                    case 6: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 3, 5, 7});
                    }
                    case 9: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 3});
                    }
                    case 5: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{1, 3, 5});
                    }
                }
            }
            case 3: {
                switch (quadrant1) {
                    case 2: 
                    case 3: 
                    case 4: {
                        return result;
                    }
                    case 8: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 1, 7});
                    }
                    case 7: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 7});
                    }
                    case 6: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 5, 7});
                    }
                    case 1: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 1});
                    }
                    case 9: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3});
                    }
                    case 5: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 5});
                    }
                }
            }
            case 4: {
                switch (quadrant1) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return result;
                    }
                    case 8: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 5, 1, 7});
                    }
                    case 7: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 5, 7});
                    }
                    case 1: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 5, 1});
                    }
                    case 9: {
                        return this.getCrossPoints(firstPoint, secondPoint, new int[]{3, 5});
                    }
                }
            }
        }
        throw new RuntimeException("\u74e6\u7247\u548c\u7ebf\u5173\u7cfb\u8ba1\u7b97\u9519\u8bef");
    }

    public static boolean doubleEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static double[] combineDoubleArray(double[] left, double[] right) {
        if (null == left || 0 == left.length) {
            return right;
        }
        if (null == right || 0 == right.length) {
            return left;
        }
        double[] returnPoint = new double[left.length + right.length];
        System.arraycopy(left, 0, returnPoint, 0, left.length);
        System.arraycopy(right, 0, returnPoint, left.length, right.length);
        return returnPoint;
    }

    static class Node {
        public double x;
        public double y;
        public int zone;

        public Node() {
            this.y = Double.MAX_VALUE;
            this.x = Double.MAX_VALUE;
            this.zone = 0;
        }

        public Node(double px, double py, int nzone) {
            this.assign(px, py, nzone);
        }

        public Node assign(double px, double py, int nzone) {
            this.x = px;
            this.y = py;
            this.zone = nzone;
            return this;
        }

        public Node assignWith(Node other) {
            this.assign(other.x, other.y, other.zone);
            return this;
        }

        public void reset() {
            this.y = Double.MAX_VALUE;
            this.x = Double.MAX_VALUE;
            this.zone = 0;
        }

        public boolean isEmpty() {
            return this.x == Double.MAX_VALUE && this.y == Double.MAX_VALUE;
        }

        public int zoneOf(Boxset bs) {
            this.zone = Boxset.zoneOf(this.x, this.y, bs);
            return this.zone;
        }
    }
}

