/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell;

import com.geoway.vtile.manager.node.INodeManager;
import com.geoway.vtile.model.node.NodeQuery;
import com.geoway.vtile.model.node.NodeType;
import com.geoway.vtile.service.mapserver.MapServerAccess;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ImgCacheCell
implements ITileCutterCell<GridExtent, List<Object[]>> {
    private String serverName;
    private String styleId;
    private Integer tileSize;
    private Integer ratio;
    private MapServerAccess.ImgCacheType cacheType;
    private INodeManager nodeManager;
    private MapServerAccess mapServerAccess;
    private static AtomicInteger requestIndex;

    public ImgCacheCell(String serverName, String styleId, Integer tileSize, Integer ratio, MapServerAccess mapServerAccess, INodeManager nodeManager, MapServerAccess.ImgCacheType cacheType) {
        this.mapServerAccess = mapServerAccess;
        this.nodeManager = nodeManager;
        this.cacheType = cacheType;
        this.serverName = serverName;
        this.tileSize = tileSize;
        this.styleId = styleId;
        this.ratio = ratio;
    }

    public <T> String createCache(GridExtent extent) throws Exception {
        String[] urls = null;
        try {
            NodeQuery query = new NodeQuery();
            query.setType(NodeType.Mapserver);
            query.setActive(Boolean.valueOf(true));
            List nodeServiceList = this.nodeManager.list(query);
            if (nodeServiceList.isEmpty()) {
                throw new Exception("\u65e0\u53ef\u7528\u6e32\u67d3\u5f15\u64ce\u8282\u70b9\uff0c\u8bf7\u6392\u67e5\u8282\u70b9\u72b6\u6001\uff01");
            }
            String mapserverUrl = this.mapServerAccess.getUrlPrifix();
            for (String url : urls = this.buildUrl(extent, mapserverUrl)) {
                this.mapServerAccess.sendHttpGet(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u521b\u5efa\u56fe\u7247\u7f13\u5b58\u9519\u8bef;\u6e32\u67d3\u62a5\u9519" + e.getMessage() + ";\u6e32\u67d3url:" + Arrays.toString(urls));
        }
        return null;
    }

    private String[] buildUrl(GridExtent extent, String mapServerUrl) {
        int x = extent.getX();
        int y = extent.getY();
        int l = extent.getLevel();
        String urlTemplate = this.cacheType.getTemplateUrl();
        String[] urls = null;
        urls = this.tileSize == 256 ? new String[]{mapServerUrl + String.format(urlTemplate, this.serverName, this.styleId, this.tileSize, x * 2, y * 2, l, this.ratio), mapServerUrl + String.format(urlTemplate, this.serverName, this.styleId, this.tileSize, x * 2 + 1, y * 2, l, this.ratio), mapServerUrl + String.format(urlTemplate, this.serverName, this.styleId, this.tileSize, x * 2, y * 2 + 1, l, this.ratio), mapServerUrl + String.format(urlTemplate, this.serverName, this.styleId, this.tileSize, x * 2 + 1, y * 2 + 1, l, this.ratio)} : new String[]{mapServerUrl + String.format(urlTemplate, this.serverName, this.styleId, this.tileSize, x, y, l, this.ratio)};
        return urls;
    }

    @Override
    public void setDown(int down) {
    }

    @Override
    public Integer getDown() {
        return null;
    }

    @Override
    public void init() {
        requestIndex = new AtomicInteger(0);
    }

    @Override
    public List<Object[]> cut(GridExtent extent, TileCutOptions options) throws Exception {
        this.createCache(extent);
        return null;
    }

    @Override
    public void setMainLevel(Integer mainLevel) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isCancel() {
        return false;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Integer getTileSize() {
        return this.tileSize;
    }

    public Integer getRatio() {
        return this.ratio;
    }

    public String getImgCacheType() {
        return this.cacheType.toString();
    }
}

