/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DynamicByteBuffer {
    private int blockContentSize = 100;
    private List<ByteBuffer> bufList = new ArrayList<ByteBuffer>();
    private ByteBuffer all;
    private int blockIndex = 0;

    public DynamicByteBuffer() {
        this.bufList.add(ByteBuffer.allocate(this.blockContentSize));
    }

    public void put(byte[] bytes) {
        this.put(ByteBuffer.wrap(bytes));
    }

    public List<ByteBuffer> getListBuffer() {
        return this.bufList;
    }

    public void put(DynamicByteBuffer dbBuffer) {
        for (ByteBuffer byteBuffer : dbBuffer.getListBuffer()) {
            this.put(byteBuffer);
        }
    }

    private void createBlock(int size) {
        this.blockContentSize += (int)((double)this.blockContentSize * 1.5);
        this.blockContentSize = this.blockContentSize > size ? this.blockContentSize : size;
        this.getListBuffer().add(ByteBuffer.allocate(this.blockContentSize));
        ++this.blockIndex;
    }

    public void put(ByteBuffer buf) {
        ByteBuffer lastBlock = this.getListBuffer().get(this.blockIndex);
        int position = this.getListBuffer().get(this.blockIndex).position();
        for (int i = 0; i < buf.limit(); ++i) {
            if (position < lastBlock.capacity()) {
                ++position;
            } else {
                this.createBlock(buf.limit() - i);
                lastBlock = this.getListBuffer().get(this.blockIndex);
                position = this.getListBuffer().get(this.blockIndex).position();
            }
            lastBlock.put(buf.get(i));
        }
    }

    public void putDouble(double number) {
        ByteBuffer lastBlock = this.getListBuffer().get(this.blockIndex);
        int position = this.getListBuffer().get(this.blockIndex).position();
        if (position + 8 < lastBlock.capacity()) {
            lastBlock.putDouble(number);
        } else {
            byte[] dbytes = DynamicByteBuffer.double2Bytes(number);
            this.put(dbytes);
        }
    }

    public void putLong(long number) {
        ByteBuffer lastBlock = this.getListBuffer().get(this.blockIndex);
        int position = this.getListBuffer().get(this.blockIndex).position();
        if (position + 8 < lastBlock.capacity()) {
            lastBlock.putLong(number);
            position += 8;
        } else {
            byte[] dbytes = DynamicByteBuffer.long2Bytes(number);
            this.put(dbytes);
        }
    }

    public void put(ByteBuffer buf, int offset, int length) {
        ByteBuffer lastBlock = this.getListBuffer().get(this.blockIndex);
        int position = this.getListBuffer().get(this.blockIndex).position();
        for (int i = offset; i < length; ++i) {
            if (position < lastBlock.capacity()) {
                ++position;
            } else {
                this.createBlock(buf.limit() - i);
                lastBlock = this.getListBuffer().get(this.blockIndex);
                position = this.getListBuffer().get(this.blockIndex).position();
            }
            lastBlock.put(buf.get(i));
        }
    }

    public void putInt(int value) {
        byte[] intBytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        this.put(intBytes);
    }

    public ByteBuffer getBuffer() {
        if (this.bufList.isEmpty()) {
            return null;
        }
        int size = this.limit();
        this.all = ByteBuffer.allocate(size);
        for (ByteBuffer buf : this.bufList) {
            this.all.put(buf);
        }
        this.all.flip();
        return this.all;
    }

    public byte[] getByteArray() {
        int length = this.limit();
        byte[] bytes = new byte[length];
        int byteindex = 0;
        for (int i = 0; i < this.bufList.size(); ++i) {
            ByteBuffer tmp = this.bufList.get(i);
            int blockLength = tmp.limit();
            for (int j = 0; j < blockLength; ++j) {
                bytes[byteindex] = tmp.get(j);
                ++byteindex;
            }
        }
        return bytes;
    }

    public void reset() {
        for (ByteBuffer buf : this.bufList) {
            buf.reset();
        }
    }

    public void flip() {
        for (ByteBuffer buf : this.bufList) {
            buf.flip();
        }
    }

    public int position() {
        int position = 0;
        for (ByteBuffer byteBuffer : this.bufList) {
            position += byteBuffer.position();
        }
        return position;
    }

    public int limit() {
        int limit = 0;
        for (ByteBuffer byteBuffer : this.bufList) {
            limit += byteBuffer.limit();
        }
        return limit;
    }

    public static byte[] double2Bytes(double d) {
        long value = Double.doubleToRawLongBits(d);
        byte[] byteRet = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byteRet[7 - i] = (byte)(value >> 8 * i & 0xFFL);
        }
        return byteRet;
    }

    public static byte[] long2Bytes(long value) {
        byte[] byteRet = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byteRet[i] = (byte)(value >> 8 * i & 0xFFL);
        }
        return byteRet;
    }

    public static double bytes2Double(byte[] arr) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)(arr[i] & 0xFF) << 8 * i;
        }
        return Double.longBitsToDouble(value);
    }

    public static void main(String[] args) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(200);
        byte[] b = DynamicByteBuffer.double2Bytes(122.1111112345);
        byteBuffer.put(b);
        byteBuffer.flip();
        System.out.println(byteBuffer.getDouble());
    }
}

