/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.shovel;

import com.geoway.vtile.model.data_service.DataServiceAdvancedOptions;
import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.ScreenLoction;
import com.geoway.vtile.transform.dataholder.shovel.label.ScreenLoctionLineLabel;
import com.geoway.vtile.transform.dataholder.shovel.label.ScreenLoctionPolygonLabel;
import com.geoway.vtile.transform.dataholder.shovel.vector.ScreenLoctionVector;
import com.geoway.vtile.transform.enums.LAYER_TYPE;

public class ScreenLoctionManager {
    public static ScreenLoction getScreenLoction(ILayer layer, LAYER_TYPE type, Constants.GEO_TYPE geometryType, GridExtent extent, Integer downLevel) {
        DataServiceAdvancedOptions advancedOptions;
        Integer beginLevel = extent.getLevel();
        Integer endLevel = beginLevel + downLevel;
        int level = extent.getLevel();
        ILayerLevel layerLevel = (ILayerLevel)layer.getLevelMap().get(level);
        while (layerLevel == null && level < extent.getLevel() + downLevel) {
            layerLevel = (ILayerLevel)layer.getLevelMap().get(++level);
        }
        DataServiceAdvancedOptions dataServiceAdvancedOptions = advancedOptions = layerLevel == null ? null : ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions();
        if (type == LAYER_TYPE.label && (geometryType == Constants.GEO_TYPE.LINESTRING || geometryType == Constants.GEO_TYPE.MULTILINESTRING)) {
            Integer minCutPixel = layerLevel.getMinCutPixel();
            Integer minCutPoint = layerLevel.getMinCutPoint();
            Integer base = advancedOptions.getLineCutBase();
            return new ScreenLoctionLineLabel(extent.getGrid(), beginLevel, endLevel, minCutPixel, minCutPoint, base);
        }
        if (type == LAYER_TYPE.label && (geometryType == Constants.GEO_TYPE.POLYGON || geometryType == Constants.GEO_TYPE.MULTIPOLYGON)) {
            return new ScreenLoctionPolygonLabel(advancedOptions.getSinglePolygonLabelLevel());
        }
        return new ScreenLoctionVector();
    }
}

