/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.shovel.vector;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.commons.util.BuilderCreator;
import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.geofeature.GeoPart;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.spatial.tool.Simplify;
import com.geoway.vtile.transform.dataholder.ExtentDataHolder;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import com.geoway.vtile.transform.dataholder.shovel.AbstractShovel;
import com.geoway.vtile.transform.tools.Boxset;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScreenLoction
extends AbstractShovel {
    protected final int base_times = 10;
    protected Constants.GEO_TYPE featrueType;
    private static Logger logger = LoggerFactory.getLogger(AbstractScreenLoction.class);
    public static final int POLY_NORMAL = 0;
    public static final int POLY_ONE_PIXEL = 1;
    public static final int POLY_4X4_PIXEL = 2;
    public static final int LEFT_DOWN = 0;
    public static final int LEFT_TOP = 1;
    public static final int RIGHT_TOP = 2;
    public static final int RIGHT_DOWN = 3;
    public static PrecisionModel PM_9DIGIT = new PrecisionModel(1.0E10);

    protected void _dealWithLine(ExtentDataHolderArray arr, ExtentDataHolder holder, double times) {
        Boolean cutOutScreen = holder.getCutOutScreen();
        double[] bbox = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        DoubleBuilder data = null;
        data = holder.getParent() != null ? holder.getParent().getProcessedCache() : holder.getProcessedCache();
        if (data == null) {
            return;
        }
        if (data.size() == 0) {
            holder.setProcessedCache(null);
            return;
        }
        Boxset boxset = holder.getBoxset();
        DoubleBuilder newData = this.cutData(data, boxset, false);
        if (newData.size() == 0) {
            holder.setProcessedCache(null);
            return;
        }
        if (!cutOutScreen.booleanValue() && (newData = data).size() == 2 && !boxset.in(newData.get(0), newData.get(1))) {
            holder.setProcessedCache(null);
            return;
        }
        holder.setProcessedCache(newData);
        double simplify = arr.getSimplify(holder.getLevel());
        GridExtent extent = holder.getExtent();
        DoubleBuilder doubleBuilderSimplify = this.simplify(newData, extent, simplify, times, bbox);
        Boolean ignoreOnePointFeature = arr.isIgnoreOnePointFeature(holder.getLevel());
        if (ignoreOnePointFeature.booleanValue() && doubleBuilderSimplify.size() <= 2) {
            return;
        }
        holder.savePoints(doubleBuilderSimplify, times, null);
    }

    private DoubleBuilder cutData(DoubleBuilder data, Boxset boxset, boolean isClose) {
        int len = data.size();
        if (len % 2 != 0) {
            --len;
        }
        DoubleBuilder newData = BuilderCreator.createDouble();
        for (int index = 0; index < len; index += 2) {
            double x = data.get(index);
            double y = data.get(index + 1);
            this.onePoint(x, y, boxset, newData, isClose);
        }
        return newData;
    }

    private Geometry accurateX(DoubleBuilder data, Boxset boxset, boolean isClose) {
        GeometryFactory gf = new GeometryFactory(PM_9DIGIT, 0);
        double[] coords = data.toArray();
        Geometry shp = AbstractScreenLoction.makeJtsGeom(gf, coords, isClose);
        coords = new double[]{boxset.getLeft(), boxset.getBottom(), boxset.getRight(), boxset.getBottom(), boxset.getRight(), boxset.getTop(), boxset.getLeft(), boxset.getTop(), boxset.getLeft(), boxset.getBottom()};
        Geometry box = AbstractScreenLoction.makeJtsGeom(gf, coords, true);
        Geometry intersectArea = null;
        OverlayOp op = new OverlayOp(box, shp);
        try {
            intersectArea = op.getResultGeometry(1);
        }
        catch (Exception e) {
            Geometry fixGeo = GeometryFixer.fix((Geometry)shp);
            op = new OverlayOp(box, fixGeo);
            intersectArea = op.getResultGeometry(1);
        }
        return intersectArea;
    }

    private static Geometry makeJtsGeom(GeometryFactory gf, double[] coords, boolean isPolygon) {
        int pointNum = coords.length / 2;
        Coordinate[] shell = new Coordinate[pointNum];
        for (int i = 0; i < pointNum; ++i) {
            shell[i] = new CoordinateXY(coords[2 * i], coords[2 * i + 1]);
        }
        if (isPolygon) {
            return gf.createPolygon(shell);
        }
        return gf.createLineString(shell);
    }

    private static DoubleBuilder concatMultiPolygons(Geometry xshp, Boxset boxset) {
        int num = xshp.getNumGeometries();
        logger.info("\u7ed3\u679c\u51e0\u4f55\u4e2a\u6570\uff1a" + num);
        logger.info("L-B-R-T: [{},{},\n\t{},{}]", new Object[]{boxset.getLeft(), boxset.getBottom(), boxset.getRight(), boxset.getTop()});
        DoubleBuilder dbuilder = BuilderCreator.createDouble();
        Coordinate priorCood = null;
        for (int i = 0; i < num; ++i) {
            Geometry g = xshp.getGeometryN(i);
            Coordinate coord = g.getCoordinates()[0];
            logger.info("\u9996\u70b9-{}\uff1a {}, {}", new Object[]{i + 1, coord.x, coord.y});
            if (null != priorCood) {
                AbstractScreenLoction.interpolateBoundPoints(dbuilder, boxset, priorCood, coord);
            }
            DoubleBuilder geoN = AbstractScreenLoction.convertGeometry2Doubles(g);
            dbuilder.append(geoN.toArray(), 0, geoN.size());
            priorCood = coord;
        }
        return dbuilder;
    }

    private static void interpolateBoundPoints(DoubleBuilder dbuilder, Boxset boxset, Coordinate priorCood, Coordinate coord) {
        double left = boxset.getLeft();
        double right = boxset.getRight();
        double bottom = boxset.getBottom();
        double top = boxset.getTop();
        if (Boxset.doubleEqual(top, priorCood.y)) {
            if (Boxset.doubleEqual(top, coord.y)) {
                return;
            }
            if (Boxset.doubleEqual(bottom, coord.y)) {
                dbuilder.append(right).append(top).append(right).append(bottom);
            } else if (Boxset.doubleEqual(left, coord.x)) {
                dbuilder.append(left).append(top);
            } else if (Boxset.doubleEqual(right, coord.x)) {
                dbuilder.append(right).append(top);
            }
        } else if (Boxset.doubleEqual(bottom, priorCood.y)) {
            if (Boxset.doubleEqual(top, coord.y)) {
                dbuilder.append(right).append(bottom).append(right).append(top);
            } else {
                if (Boxset.doubleEqual(bottom, coord.y)) {
                    return;
                }
                if (Boxset.doubleEqual(left, coord.x)) {
                    dbuilder.append(left).append(bottom);
                } else if (Boxset.doubleEqual(right, coord.x)) {
                    dbuilder.append(right).append(bottom);
                }
            }
        } else if (Boxset.doubleEqual(left, priorCood.x)) {
            if (Boxset.doubleEqual(top, coord.y)) {
                dbuilder.append(left).append(top);
            } else if (Boxset.doubleEqual(bottom, coord.y)) {
                dbuilder.append(left).append(top);
            } else {
                if (Boxset.doubleEqual(left, coord.x)) {
                    return;
                }
                if (Boxset.doubleEqual(right, coord.x)) {
                    dbuilder.append(left).append(top).append(right).append(top);
                }
            }
        } else if (Boxset.doubleEqual(right, priorCood.x)) {
            if (Boxset.doubleEqual(top, coord.y)) {
                dbuilder.append(right).append(top);
            } else if (Boxset.doubleEqual(bottom, coord.y)) {
                dbuilder.append(right).append(bottom);
            } else if (Boxset.doubleEqual(left, coord.x)) {
                dbuilder.append(right).append(top).append(left).append(top);
            } else if (Boxset.doubleEqual(right, coord.x)) {
                return;
            }
        }
    }

    private static DoubleBuilder convertGeometry2Doubles(Geometry geo) {
        Coordinate[] jtsCoords = geo.getCoordinates();
        DoubleBuilder dbuilder = BuilderCreator.createDouble();
        for (Coordinate coord : jtsCoords) {
            dbuilder.append(coord.getX()).append(coord.getY());
        }
        return dbuilder;
    }

    private Boolean inBox(double[] onePoint, double baseTileSize) {
        double offset = baseTileSize * 5.0 / 100.0;
        if (onePoint[0] < 0.0 - offset || onePoint[0] > baseTileSize + offset) {
            return false;
        }
        if (onePoint[1] < 0.0 - offset || onePoint[1] > baseTileSize + offset) {
            return false;
        }
        return true;
    }

    protected void _dealWithCloseLine(ExtentDataHolderArray arr, ExtentDataHolder holder, double times, GeoPart.RING_TYPE ringType) throws Exception {
        int limit = -1;
        if (holder.getExtent().getGrid().getBaseTileSize() == 512) {
            limit = 514;
        } else if (holder.getExtent().getGrid().getBaseTileSize() == 256) {
            limit = 258;
        } else if (holder.getExtent().getGrid().getBaseTileSize() == 1024) {
            limit = 1026;
        } else {
            throw new RuntimeException("\u5207\u5272\u6a21\u5757\u4e0d\u652f\u6301\u7684\u7f51\u683c\u5355\u5143\u5927\u5c0fBaseTileSize:" + holder.getExtent().getGrid().getBaseTileSize());
        }
        Boolean cutOutScreen = holder.getCutOutScreen();
        DoubleBuilder data = null;
        double[] bbox = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        if (holder.isMainHolder().booleanValue()) {
            data = holder.getProcessedCache();
        } else {
            ExtentDataHolder pscreenExtent = holder.getParent();
            if (pscreenExtent != null && pscreenExtent.isFull() && GeoPart.RING_TYPE.outside == ringType) {
                holder.full(pscreenExtent.getClockwise());
                holder.setFull();
                return;
            }
            data = holder.getParent().getProcessedCache();
            if (data == null) {
                return;
            }
            if (data.size() == 0) {
                holder.setProcessedCache(null);
                return;
            }
        }
        Boxset boxset = holder.getBoxset();
        DoubleBuilder newData = null;
        Boolean couldBeFull = false;
        boolean isJtsAccurateX = data.size() / 2 < 100 && GlobalTileSettings.bAccurateCut && boxset.getExtent().getLevel() > 12 && (this.featrueType == Constants.GEO_TYPE.POLYGON || this.featrueType == Constants.GEO_TYPE.MULTIPOLYGON);
        boolean isXOK = true;
        if (isJtsAccurateX) {
            try {
                Geometry xshp = this.accurateX(data, boxset, true);
                if (1 != xshp.getNumGeometries()) {
                    this.processMultiPolygonsReturn(xshp, boxset, holder, arr, times, ringType);
                    return;
                }
                newData = AbstractScreenLoction.convertGeometry2Doubles(xshp);
                if (10 == newData.size()) {
                    double boxExpand = boxset.getRight() - boxset.getLeft();
                    double[] coords = newData.toArray();
                    double[] buffer = new double[]{Math.abs(coords[0] - coords[4]), Math.abs(coords[1] - coords[5]), Math.abs(coords[2] - coords[6]), Math.abs(coords[3] - coords[7])};
                    couldBeFull = Boxset.doubleEqual(boxExpand, buffer[0]) && Boxset.doubleEqual(boxExpand, buffer[1]) && Boxset.doubleEqual(boxExpand, buffer[2]) && Boxset.doubleEqual(boxExpand, buffer[3]);
                }
            }
            catch (Exception ex) {
                logger.error("\u7cbe\u786e\u76f8\u4ea4\u8ba1\u7b97\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
                isXOK = false;
            }
        }
        if (!isJtsAccurateX || !isXOK) {
            newData = this.cutData(data, boxset, true);
            if ((holder.isMainHolder().booleanValue() || holder.getParent().getBoxset().getInclude().booleanValue()) && boxset.getInclude().booleanValue()) {
                couldBeFull = true;
            }
            if (newData.size() != 0 && newData.size() != 2) {
                double x = newData.get(0);
                double y = newData.get(1);
                this.onePoint(x, y, boxset, newData, true);
            }
        }
        if (null == newData || newData.size() == 0) {
            holder.setProcessedCache(null);
            return;
        }
        if (!cutOutScreen.booleanValue() && (newData = data).size() == 2 && !boxset.in(newData.get(0), newData.get(1))) {
            holder.setProcessedCache(null);
            return;
        }
        if (couldBeFull.booleanValue()) {
            if (isJtsAccurateX || boxset.isFull(newData).booleanValue()) {
                if (GeoPart.RING_TYPE.outside == ringType) {
                    Boolean clockwise = this.isClockwise(newData);
                    newData.destroy();
                    holder.full(clockwise);
                    holder.setFull();
                    return;
                }
                holder.setProcessedCache(null);
            }
        } else {
            holder.setProcessedCache(newData);
        }
        GridExtent extent = holder.getExtent();
        double simplify = arr.getSimplify(holder.getLevel());
        DoubleBuilder doubleBuilderSimplify = this.simplify(newData, extent, simplify, times, bbox);
        Boolean ignoreOnePointFeature = arr.isIgnoreOnePointFeature(holder.getLevel());
        int polyType = this.checkPolyTypeByBBox(bbox);
        double[] onePoint = new double[2];
        double[] fPoint = new double[4];
        int[] onePointInt = new int[2];
        if (ignoreOnePointFeature.booleanValue() && (polyType == 1 || polyType == 2)) {
            if (polyType == 1) {
                double baseTileSize = extent.getGrid().getBaseTileSize();
                onePoint[0] = (bbox[2] + bbox[0]) / 2.0;
                onePoint[1] = (bbox[3] + bbox[1]) / 2.0;
                onePointInt = new int[]{(int)Math.round(onePoint[0]), (int)Math.round(onePoint[1])};
                if (!this.inBox(onePoint, baseTileSize).booleanValue()) {
                    return;
                }
                Boolean saveOnePointFeature = this.isSaveOnePointFeature(holder, onePointInt[0], onePointInt[1], holder.getExtent().getGrid().getBaseTileSize());
                if (!saveOnePointFeature.booleanValue()) {
                    return;
                }
            }
            if (polyType == 2) {
                doubleBuilderSimplify = this.processPoly4X4Pixel(doubleBuilderSimplify, bbox);
                int[] quadrantPoint = new int[doubleBuilderSimplify.size()];
                for (int i = 0; i < doubleBuilderSimplify.size(); ++i) {
                    quadrantPoint[i] = (int)doubleBuilderSimplify.get(i);
                }
                Boolean saveFeature = this.isSave4X4Feature(holder, quadrantPoint, limit, holder.getExtent().getGrid().getBaseTileSize());
                if (!saveFeature.booleanValue()) {
                    return;
                }
            }
        }
        holder.savePoints(doubleBuilderSimplify, times, ringType);
    }

    private void processMultiPolygonsReturn(Geometry xshp, Boxset boxset, ExtentDataHolder holder, ExtentDataHolderArray arr, double times, GeoPart.RING_TYPE ringType) {
        GridExtent extent = holder.getExtent();
        double simplifyParam = arr.getSimplify(holder.getLevel());
        int num = xshp.getNumGeometries();
        for (int i = 0; i < num; ++i) {
            Geometry g = xshp.getGeometryN(i);
            DoubleBuilder geoN = AbstractScreenLoction.convertGeometry2Doubles(g);
            DoubleBuilder geoSimplify = this.simplify(geoN, extent, simplifyParam, times, null);
            holder.savePoints(geoSimplify, times, ringType);
        }
    }

    private Boolean isSave4X4Feature(ExtentDataHolder holder, int[] quadrantPoint, int limit, int baseTileSize) {
        int y;
        int x;
        int i;
        int offsetX = 1;
        int offsetY = 1;
        byte[][] check = holder.getPixelCheckBuffer();
        boolean isSave = false;
        for (i = 0; i < quadrantPoint.length / 2; ++i) {
            x = quadrantPoint[i * 2];
            y = quadrantPoint[i * 2 + 1];
            if (!this.onePointIsNotIn(check, x, y, offsetX, offsetY, baseTileSize).booleanValue()) continue;
            isSave = true;
            break;
        }
        if (isSave) {
            for (i = 0; i < quadrantPoint.length / 2; ++i) {
                x = quadrantPoint[i * 2];
                y = quadrantPoint[i * 2 + 1];
                if (x < 0 || x > baseTileSize || y < 0 || y > baseTileSize) continue;
                check[x + offsetX][y + offsetY] = 1;
            }
        }
        return isSave;
    }

    private DoubleBuilder processPoly4X4Pixel(DoubleBuilder doubleBuilderSimplify, double[] bbox) {
        int quadrant = -1;
        double[] leftDownPoint = new double[]{Double.NaN, Double.NaN};
        double[] leftTopPoint = new double[]{Double.NaN, Double.NaN};
        double[] rightTopPoint = new double[]{Double.NaN, Double.NaN};
        double[] rightDownPoint = new double[]{Double.NaN, Double.NaN};
        for (int i = 0; i < doubleBuilderSimplify.size() / 2; ++i) {
            double x = doubleBuilderSimplify.get(i * 2);
            double y = doubleBuilderSimplify.get(i * 2 + 1);
            int xInt = (int)Math.round(x);
            int yInt = (int)Math.round(y);
            quadrant = xInt == (int)Math.round(bbox[0]) ? (yInt == (int)bbox[1] ? 0 : 1) : (yInt == (int)Math.round(bbox[1]) ? 3 : 2);
            if (quadrant == 0) {
                if (Double.isNaN(leftDownPoint[0]) || leftDownPoint[0] > x) {
                    leftDownPoint[0] = x;
                }
                if (Double.isNaN(leftDownPoint[1]) || leftDownPoint[1] > y) {
                    leftDownPoint[1] = y;
                }
            }
            if (quadrant == 1) {
                if (Double.isNaN(leftTopPoint[0]) || leftTopPoint[0] > x) {
                    leftTopPoint[0] = x;
                }
                if (Double.isNaN(leftTopPoint[1]) || leftTopPoint[1] < y) {
                    leftTopPoint[1] = y;
                }
            }
            if (quadrant == 2) {
                if (Double.isNaN(rightTopPoint[0]) || rightTopPoint[0] < x) {
                    rightTopPoint[0] = x;
                }
                if (Double.isNaN(rightTopPoint[1]) || rightTopPoint[1] < y) {
                    rightTopPoint[1] = y;
                }
            }
            if (quadrant != 3) continue;
            if (Double.isNaN(rightDownPoint[0]) || rightDownPoint[0] < x) {
                rightDownPoint[0] = x;
            }
            if (!Double.isNaN(rightDownPoint[1]) && !(rightDownPoint[1] > y)) continue;
            rightDownPoint[1] = y;
        }
        DoubleBuilder builder = BuilderCreator.createDouble();
        if (!Double.isNaN(leftDownPoint[0])) {
            builder.append(leftDownPoint[0]);
            builder.append(leftDownPoint[1]);
        }
        if (!Double.isNaN(leftTopPoint[0])) {
            builder.append(leftTopPoint[0]);
            builder.append(leftTopPoint[1]);
        }
        if (!Double.isNaN(rightTopPoint[0])) {
            builder.append(rightTopPoint[0]);
            builder.append(rightTopPoint[1]);
        }
        if (!Double.isNaN(rightDownPoint[0])) {
            builder.append(rightDownPoint[0]);
            builder.append(rightDownPoint[1]);
        }
        return builder;
    }

    private int checkPolyTypeByBBox(double[] bbox) {
        if (bbox[2] - bbox[0] <= 1.0 && bbox[3] - bbox[1] <= 1.0) {
            return 1;
        }
        if (bbox[2] - bbox[0] <= 2.0 && bbox[3] - bbox[1] <= 2.0) {
            return 2;
        }
        return 0;
    }

    private Boolean onePointIsNotIn(byte[][] check, int x, int y, int offsetX, int offsetY, int baseTileSize) {
        if (x < 0 || x > baseTileSize) {
            return false;
        }
        if (y < 0 || y > baseTileSize) {
            return false;
        }
        if (check[x += offsetX][y += offsetY] == 1) {
            return false;
        }
        return true;
    }

    private Boolean isSaveOnePointFeature(ExtentDataHolder holder, int x, int y, int baseTileSize) {
        int offsetX = 1;
        int offsetY = 1;
        byte[][] check = holder.getPixelCheckBuffer();
        boolean isSave = this.onePointIsNotIn(check, x, y, offsetX, offsetY, baseTileSize);
        if (isSave) {
            check[x + offsetX][y + offsetY] = 1;
        }
        return isSave;
    }

    protected void dealWithLine(DoubleBuilder doubleBuilder, ExtentDataHolderArray arr, Boolean isClose, GeoPart.RING_TYPE ringType) {
        arr.boxsetReset();
        double times = Math.pow(this.base_times, arr.getMainHolder().getAccuracy().intValue());
        ExtentDataHolder mainHolder = arr.getMainHolder();
        mainHolder.setProcessedCache(doubleBuilder);
        arr.beginPath();
        try {
            this._dealWithLine(mainHolder, arr, times, isClose, ringType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        arr.endPath();
    }

    protected void _dealWithLine(ExtentDataHolder holder, ExtentDataHolderArray arr, double times, Boolean isClose, GeoPart.RING_TYPE ringType) throws Exception {
        ExtentDataHolder[] children = holder.getChildren();
        if (!arr.isSave(holder.getLevel()).booleanValue()) {
            if (children != null) {
                for (ExtentDataHolder child : children) {
                    child.setProcessedCache(holder.getProcessedCache());
                }
            }
        } else if (isClose.booleanValue()) {
            this._dealWithCloseLine(arr, holder, times, ringType);
        } else {
            this._dealWithLine(arr, holder, times);
        }
        if (children == null) {
            return;
        }
        if (!(holder.isFull() || holder.getProcessedCache() != null && holder.getProcessedCache().size() != 0)) {
            return;
        }
        for (ExtentDataHolder child : children) {
            this._dealWithLine(child, arr, times, isClose, ringType);
        }
    }

    protected Boolean isClockwise(DoubleBuilder doubleBuilder) {
        int size = doubleBuilder.size();
        double d = 0.0;
        for (int i = 0; i < size - 2; i += 2) {
            d += 0.5 * (doubleBuilder.get(i + 3) + doubleBuilder.get(i + 1)) * (doubleBuilder.get(i + 2) - doubleBuilder.get(i));
        }
        if (d > 0.0) {
            return true;
        }
        return false;
    }

    protected double[] onePoint(double x, double y, Boxset boxset, DoubleBuilder doubleBuilder, boolean isClose) {
        double[] points = boxset.push(x, y, doubleBuilder);
        if (points != null) {
            for (int i = 0; i < points.length; ++i) {
                doubleBuilder.append(points[i]);
            }
        }
        return points;
    }

    protected DoubleBuilder simplify(DoubleBuilder doubleBuilder, GridExtent extent, double sqTolerance, double times, double[] bbox) {
        int size = doubleBuilder.size();
        double[] now = Boxset.createEmptyDoubleArray();
        double[] previous = Boxset.createEmptyDoubleArray();
        long[] groupNow = new long[2];
        DoubleBuilder tmpDoubleBuilderGroup = BuilderCreator.createDouble();
        DoubleBuilder pointsNew = BuilderCreator.createDouble();
        Boolean exactly = true;
        for (int i = 0; i < size / 2; ++i) {
            double x = doubleBuilder.get(i * 2);
            double y = doubleBuilder.get(i * 2 + 1);
            this.toExtentCoordinate(x, y, extent, now, times, bbox);
            this.savePrecision(previous, now, groupNow, pointsNew, tmpDoubleBuilderGroup, 50.0, exactly);
        }
        switch (this.featrueType) {
            case LINESTRING: {
                pointsNew = Simplify.simplifyDouglasPeucker((DoubleBuilder)pointsNew, (double)(sqTolerance / 5.0));
                break;
            }
            case MULTILINESTRING: {
                pointsNew = Simplify.simplifyDouglasPeucker((DoubleBuilder)pointsNew, (double)(sqTolerance / 5.0));
                break;
            }
            case POLYGON: {
                pointsNew = Simplify.simplifyRadialDist((DoubleBuilder)pointsNew, (double)sqTolerance);
                break;
            }
            case MULTIPOLYGON: {
                pointsNew = Simplify.simplifyRadialDist((DoubleBuilder)pointsNew, (double)sqTolerance);
                break;
            }
            default: {
                pointsNew = Simplify.simplifyDouglasPeucker((DoubleBuilder)pointsNew, (double)0.025);
            }
        }
        return pointsNew;
    }

    protected void savePrecision(double[] previous, double[] now, long[] groupNow, DoubleBuilder pointsNew, DoubleBuilder tmpDoubleBuilderGroup, Double buffer, Boolean exactly) {
        long nowX = Math.round(now[0]);
        long nowY = Math.round(now[1]);
        if (exactly.booleanValue()) {
            if (Boxset.isEmpty(previous)) {
                tmpDoubleBuilderGroup.append(now[0]);
                tmpDoubleBuilderGroup.append(now[1]);
                groupNow[0] = nowX;
                groupNow[1] = nowY;
                previous[0] = now[0];
                previous[1] = now[1];
                pointsNew.append(now[0]).append(now[1]);
                return;
            }
            if (nowX == groupNow[0] && nowY == groupNow[1]) {
                tmpDoubleBuilderGroup.append(now[0]);
                tmpDoubleBuilderGroup.append(now[1]);
                return;
            }
            if (tmpDoubleBuilderGroup.size() == 0) {
                this.pushIntoPointsNew(pointsNew, now[0], now[1]);
            } else if (tmpDoubleBuilderGroup.size() == 2) {
                this.pushIntoPointsNew(pointsNew, tmpDoubleBuilderGroup.get(0), tmpDoubleBuilderGroup.get(1));
            } else {
                double dx = (double)groupNow[0] - previous[0];
                double dy = (double)groupNow[1] - previous[1];
                boolean mark = false;
                if (dx * dx + dy * dy > buffer * buffer) {
                    this.pushIntoPointsNew(pointsNew, tmpDoubleBuilderGroup.get(0), tmpDoubleBuilderGroup.get(1));
                    mark = true;
                }
                dx = now[0] - (double)groupNow[0];
                dy = now[1] - (double)groupNow[1];
                int size = tmpDoubleBuilderGroup.size();
                if (dx * dx + dy * dy > buffer * buffer) {
                    this.pushIntoPointsNew(pointsNew, tmpDoubleBuilderGroup.get(size - 2), tmpDoubleBuilderGroup.get(size - 1));
                    mark = true;
                }
                if (!mark) {
                    this.pushIntoPointsNew(pointsNew, tmpDoubleBuilderGroup.get(size - 2), tmpDoubleBuilderGroup.get(size - 1));
                }
            }
            groupNow[0] = nowX;
            groupNow[1] = nowY;
            tmpDoubleBuilderGroup.reset();
            this.pushIntoPointsNew(pointsNew, now[0], now[1]);
        }
    }

    protected void pushIntoPointsNew(DoubleBuilder pointsNew, double x, double y) {
        if (pointsNew.get(pointsNew.size() - 2) != x || pointsNew.get(pointsNew.size() - 1) != y) {
            pointsNew.append(x).append(y);
        }
    }

    protected void toExtentCoordinate(double x, double y, GridExtent extent, double[] now, double times, double[] bbox) {
        double _x = (double)Math.round((x - extent.getLeft()) / extent.getResolution() * times) / times;
        double _y = (double)Math.round((extent.getTop() - y) / extent.getResolution() * times) / times;
        now[0] = _x;
        now[1] = _y;
        if (bbox != null) {
            if (Double.isNaN(bbox[0]) || bbox[0] > _x) {
                bbox[0] = _x;
            }
            if (Double.isNaN(bbox[1]) || bbox[1] > _y) {
                bbox[1] = _y;
            }
            if (Double.isNaN(bbox[2]) || bbox[2] < _x) {
                bbox[2] = _x;
            }
            if (Double.isNaN(bbox[3]) || bbox[3] < _y) {
                bbox[3] = _y;
            }
        }
    }

    protected void dealWithPoint(double x, double y, ExtentDataHolderArray array) {
        ExtentDataHolder[] holderArr = array.getExtentDataHolderArr();
        int times = this.base_times ^ array.getMainHolder().getAccuracy();
        for (ExtentDataHolder holder : holderArr) {
            if (!array.isSave(holder.getLevel()).booleanValue()) continue;
            GridExtent extent = holder.getExtent();
            Boxset boxset = holder.getBoxset();
            if (!boxset.in(x, y)) continue;
            double[] now = Boxset.createEmptyDoubleArray();
            this.toExtentCoordinate(x, y, extent, now, times, null);
            holder.savePoint(now[0], now[1], times);
        }
    }
}

