/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.shovel.vector;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.geofeature.GeoPart;
import com.geoway.vtile.transform.ScreenLoction;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import com.geoway.vtile.transform.dataholder.shovel.vector.AbstractScreenLoction;

public class ScreenLoctionVector
extends AbstractScreenLoction
implements ScreenLoction {
    @Override
    public void toScreenLoction(GeoBuffer geo, ExtentDataHolderArray holderArray, String[] propertyFields, Object[] propertyObject, int idIndex) {
        this.featureBegin(holderArray);
        this.featrueType = geo.getGeoType();
        switch (geo.getGeoType()) {
            case POINT: {
                this.dealWithPoint(geo, holderArray);
                break;
            }
            case LINESTRING: {
                this.dealWithLineString(geo, holderArray);
                break;
            }
            case POLYGON: {
                this.dealWithPolygon(geo, holderArray);
                break;
            }
            case MULTIPOINT: {
                this.dealWithMultiPoint(geo, holderArray);
                break;
            }
            case MULTILINESTRING: {
                this.dealWithMultiLine(geo, holderArray);
                break;
            }
            case MULTIPOLYGON: {
                this.dealWithMultiPolygon(geo, holderArray);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + geo.getGeoType().name());
            }
        }
        this.setPropertys(geo.getGeoType(), holderArray, propertyFields, propertyObject);
        this.featureEnd(holderArray);
    }

    protected void dealWithPoint(GeoBuffer geo, ExtentDataHolderArray array) {
        DoubleBuilder doubleBuilder = geo.getPart(Integer.valueOf(0)).getDoubleBuilder();
        double x = doubleBuilder.get(0);
        double y = doubleBuilder.get(1);
        this.dealWithPoint(x, y, array);
    }

    private void dealWithLineString(GeoBuffer geo, ExtentDataHolderArray array) {
        DoubleBuilder doubleBuilder = geo.getPart(Integer.valueOf(0)).getDoubleBuilder();
        this.dealWithLine(doubleBuilder, array, false, null);
    }

    private void dealWithPolygon(GeoBuffer geo, ExtentDataHolderArray array) {
        geo.getPartList().forEach(part -> {
            DoubleBuilder doubleBuilder = part.getDoubleBuilder();
            GeoPart.RING_TYPE ringType = part.getRingType();
            this.dealWithLine(doubleBuilder, array, true, ringType);
        });
    }

    protected void dealWithMultiPoint(GeoBuffer geo, ExtentDataHolderArray array) {
        int size = geo.getPartList().size();
        for (int i = 0; i < size; ++i) {
            GeoPart part = (GeoPart)geo.getPartList().get(i);
            DoubleBuilder doubleBuilder = part.getDoubleBuilder();
            double x = doubleBuilder.get(i * 2);
            double y = doubleBuilder.get(i * 2 + 1);
            this.dealWithPoint(x, y, array);
        }
    }

    private void dealWithMultiLine(GeoBuffer geo, ExtentDataHolderArray array) {
        geo.getPartList().forEach(part -> {
            DoubleBuilder doubleBuilder = part.getDoubleBuilder();
            this.dealWithLine(doubleBuilder, array, false, null);
        });
    }

    private void dealWithMultiPolygon(GeoBuffer geo, ExtentDataHolderArray array) {
        geo.getPartList().forEach(part -> {
            DoubleBuilder doubleBuilder = part.getDoubleBuilder();
            GeoPart.RING_TYPE ringType = part.getRingType();
            this.dealWithLine(doubleBuilder, array, true, ringType);
        });
    }
}

