/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.vtile.model.data_service.IDataService;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datasource.IDataSource;
import com.geoway.vtile.resources.datatable.FieldEncoder;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.resources.datatable.SpatialInfo;
import com.geoway.vtile.resources.datatable.dao.IMapDAO;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.transform.service.IDataSetService;
import com.geoway.vtile.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;

public class DataSetService
implements IDataSetService {
    @Override
    public byte[] getDataSetData(IVectorService service, String dataLayerName, String filterStr, String spatialFilter, String fields, String ids, Integer start, Integer limit, Integer level, Boolean withGeometry, Boolean withExtent, Boolean withCenter) throws Exception {
        String[] selectFieldsArr;
        boolean hasGeometryInSelect;
        String fieldsStr = fields;
        IDataSet dataSet = this.getDataSet(dataLayerName, level, service);
        if (dataSet == null) {
            throw new RuntimeException("\u6ca1\u6709\u5728\u670d\u52a1 " + (String)service.getId() + " \u4e2d\u627e\u5230\u56fe\u5c42 " + dataLayerName);
        }
        IDataSource dataSource = (IDataSource)dataSet.getDataSource().getBean();
        ITable oriTable = dataSet.getDataService().getTable();
        String[] allFields = oriTable.getTableOperator().getColumnNames();
        FieldEncoder fieldEncoder = this.getFieldEncoder(allFields);
        String[] aliasFields = (String[])Arrays.stream(allFields).map(f -> fieldEncoder.encode(f)).toArray(String[]::new);
        ITable table = dataSource.getTableOperator(dataSet.getDataService().getTableName()).getTable(fieldEncoder);
        SpatialInfo spatialInfo = oriTable.spatialInfo();
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = 100;
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldsStr) && (hasGeometryInSelect = Arrays.stream(selectFieldsArr = fieldsStr.split(",")).filter(f -> spatialInfo.getSpatialField().equals(f)).findFirst().isPresent())) {
            withGeometry = true;
        }
        if (!withGeometry.booleanValue() && !withExtent.booleanValue() && !withCenter.booleanValue() && StringUtils.isEmpty((CharSequence)fields)) {
            fieldsStr = Arrays.stream(aliasFields).filter(f -> !spatialInfo.getSpatialField().equals(f)).collect(Collectors.joining(","));
        }
        Type type = table.idFieldType();
        List<Object> inputIdList = this.transformIds(ids, type);
        List list = null;
        long startTime = System.currentTimeMillis();
        list = dataSource.getDataSourceType() == Constants.DATA_SOURCE_TYPE.spark ? this.queryFromSpark(dataSource, table, spatialInfo, fieldsStr, filterStr, spatialFilter, inputIdList, start, limit) : this.queryFromDB(dataSource, table, spatialInfo, fieldsStr, filterStr, spatialFilter, inputIdList, start, limit);
        System.out.println("query time\uff1a" + (System.currentTimeMillis() - startTime));
        if (list == null || list.isEmpty()) {
            return "[]".getBytes();
        }
        this.transformResult(list, spatialInfo, withGeometry, withExtent, withCenter);
        return JSON.toJSONStringWithDateFormat((Object)list, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}).getBytes("utf-8");
    }

    private List queryFromSpark(IDataSource dataSource, ITable table, SpatialInfo spatialInfo, String fieldsStr, String filterStr, String spatialFilter, List<Object> inputIdList, Integer start, Integer limit) throws Exception {
        QueryFilter filter = this.buildFilter(table, spatialInfo, filterStr, spatialFilter, fieldsStr, inputIdList, start, limit);
        IMapDAO dao = table.mapDao();
        List list = dao.query(filter, Integer.valueOf(1000));
        return list;
    }

    public List queryFromDB(IDataSource dataSource, ITable table, SpatialInfo spatialInfo, String fieldsStr, String filterStr, String spatialFilter, List<Object> inputIdList, Integer start, Integer limit) throws Exception {
        QueryFilter filter = this.buildFilter(table, spatialInfo, filterStr, spatialFilter, table.getIdField(), inputIdList, start, limit);
        IMapDAO dao = table.mapDao();
        filter.addSorted(table.getIdField());
        List idList = dao.queryArray(filter, Integer.valueOf(1000));
        List<Object> resultIdList = this.transformIds(idList);
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        QueryFilter dataFilter = this.buildFilter(table, null, null, null, fieldsStr, resultIdList, null, null);
        List list = null;
        int maxSize = 10000;
        if (dataSource.getDataSourceType() == Constants.DATA_SOURCE_TYPE.oracle) {
            maxSize = 1000;
        } else if (dataSource.getDataSourceType() == Constants.DATA_SOURCE_TYPE.spark) {
            maxSize = Integer.MAX_VALUE;
        }
        if (idList.size() > maxSize) {
            list = new ArrayList();
            for (int i = 0; i < idList.size(); i += maxSize) {
                int endIndex = i + maxSize < idList.size() ? i + maxSize : idList.size();
                dataFilter = this.buildFilter(table, null, null, null, fieldsStr, resultIdList.subList(i, endIndex), null, null);
                List tempList = dao.query(dataFilter, Integer.valueOf(1000));
                list.addAll(tempList);
            }
        } else {
            list = dao.query(dataFilter, Integer.valueOf(1000));
        }
        return list;
    }

    @Override
    public byte[] getDataSetDataCount(IVectorService service, String dataLayerName, String filterStr, String spatialFilter, String ids, Integer level) throws Exception {
        IDataSet dataSet = this.getDataSet(dataLayerName, level, service);
        if (dataSet == null) {
            throw new RuntimeException("\u6ca1\u6709\u5728\u670d\u52a1 " + (String)service.getId() + " \u4e2d\u627e\u5230\u56fe\u5c42 " + dataLayerName);
        }
        ITable table = dataSet.getDataService().getTable();
        SpatialInfo spatialInfo = table.spatialInfo();
        IMapDAO dao = table.mapDao();
        Type type = table.idFieldType();
        List<Object> inputIdList = this.transformIds(ids, type);
        QueryFilter filter = this.buildFilter(table, spatialInfo, filterStr, spatialFilter, null, inputIdList, null, null);
        filter.setOutputFieldNames(dataSet.getIdField());
        Long count = dao.count(filter);
        return String.valueOf(count).getBytes("utf-8");
    }

    @Override
    public byte[] getDataSetInfo(IVectorService service, String dataLayerName, Integer level) throws Exception {
        IDataSet dataSet = this.getDataSet(dataLayerName, level, service);
        if (dataSet == null) {
            throw new RuntimeException("\u6ca1\u6709\u5728\u670d\u52a1 " + (String)service.getId() + " \u4e2d\u627e\u5230\u56fe\u5c42 " + dataLayerName);
        }
        IDataService dataService = dataSet.getDataService();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("id", dataService.getIdField().getName());
        m.put("idType", dataService.getIdField().getType());
        m.put("spatial", dataService.getSpatialFieldName());
        ArrayList fieldsArr = new ArrayList();
        Map aliasMap = dataService.getAliasMap();
        dataService.getFieldMap().forEach((name, dbField) -> {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("type", dbField.getType().name());
            field.put("name", dbField.getFieldName());
            field.put("alias", aliasMap.getOrDefault(dbField.getFieldName(), dbField.getFieldName()));
            fieldsArr.add(field);
        });
        m.put("fields", fieldsArr);
        return JSON.toJSONString(m).getBytes("utf-8");
    }

    private QueryFilter buildFilter(ITable table, SpatialInfo spatial, String filterStr, String spatialFilter, String fields, List<Object> idArr, Integer start, Integer limit) {
        QueryFilter filter = new QueryFilter();
        if (limit != null) {
            filter.setStart(start);
            filter.setLimit(limit);
        }
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            filter.setOutputFieldNames(fields);
        }
        if (spatialFilter != null && !"".equalsIgnoreCase(spatialFilter)) {
            filter.setSRID(spatial.getSrid());
            filter.addFilter(spatial.getSpatialField(), Constants.OPERATION.INTERSECTS, new Object[]{spatialFilter});
        }
        if (idArr != null && !idArr.isEmpty()) {
            filter.addFilter(table.getIdField(), Constants.OPERATION.IN, idArr.stream().toArray());
        }
        if (StringUtils.isNotEmpty((CharSequence)filterStr) && !filterStr.startsWith("Q_")) {
            filter.addSQL(filterStr, Constants.RELATION.AND);
        }
        return filter;
    }

    private IDataSet getDataSet(String dataLayerName, Integer level, IVectorService service) {
        ILayer layer = (ILayer)service.getLayerMap().get(dataLayerName);
        if (layer == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u56fe\u5c42 : " + dataLayerName);
        }
        IDataSet dataSet = level == null ? ((ILayerLevel)layer.getLevelMap().values().iterator().next()).getDataSet() : ((ILayerLevel)layer.getLevelMap().get(level)).getDataSet();
        return dataSet;
    }

    private List<Object> transformIds(String ids, Type type) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return null;
        }
        String[] idsArr = ids.split(",");
        return Arrays.stream(idsArr).map(id -> {
            try {
                return type.strToType(id);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private List<Object> transformIds(List<Object[]> idList) {
        return idList.stream().map(id -> id[0]).collect(Collectors.toList());
    }

    private void transformResult(List<Map<String, Object>> list, SpatialInfo spatialInfo, Boolean withGeometry, Boolean withExtent, Boolean withCenter) {
        long start;
        if (withGeometry.booleanValue() || withExtent.booleanValue() || withCenter.booleanValue()) {
            start = System.currentTimeMillis();
            list.stream().forEach(item -> {
                Geom geom = (Geom)item.get(spatialInfo.getSpatialField());
                if (geom == null) {
                    return;
                }
                Geometry geometry = geom.toJTSGeometry();
                if (geometry.getNumPoints() > 1000) {
                    geometry = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)1.0E-5);
                }
                item.put(spatialInfo.getSpatialField(), geometry);
            });
            System.out.println("deserilize time : " + (System.currentTimeMillis() - start));
        }
        if (withExtent.booleanValue()) {
            WKTWriter writer = new WKTWriter();
            list.forEach(item -> {
                Geometry geometry = (Geometry)item.get(spatialInfo.getSpatialField());
                item.put("@extent", writer.write(geometry.getEnvelope()));
                if (!withGeometry.booleanValue()) {
                    item.remove(spatialInfo.getSpatialField());
                }
            });
        }
        if (withCenter.booleanValue()) {
            WKTWriter writer = new WKTWriter();
            list.forEach(item -> {
                Geometry geometry = (Geometry)item.get(spatialInfo.getSpatialField());
                item.put("@center", writer.write((Geometry)geometry.getCentroid()));
                if (!withGeometry.booleanValue()) {
                    item.remove(spatialInfo.getSpatialField());
                }
            });
        }
        if (withGeometry.booleanValue()) {
            start = System.currentTimeMillis();
            list.stream().forEach(item -> {
                Geometry geometry = (Geometry)item.get(spatialInfo.getSpatialField());
                item.put(spatialInfo.getSpatialField(), geometry.toText());
            });
            System.out.println("wkt time : " + (System.currentTimeMillis() - start));
        }
    }

    private FieldEncoder getFieldEncoder(String[] fields) {
        final Map<String, String> aliasMap = this.getAliasMap(fields);
        return new FieldEncoder(){

            public String encode(String fieldInDB) {
                return (String)aliasMap.get(fieldInDB.toLowerCase());
            }

            public String getFieldEncoderName() {
                return "";
            }
        };
    }

    public Map<String, String> getAliasMap(String[] fields) {
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        for (String field : fields) {
            String aliaseName = (String)aliasMap.get(field);
            if (aliaseName == null) {
                aliaseName = FieldEncoder.DEFAULT_ENCODER.encode(field);
            }
            aliasMap.put(field.toLowerCase(), aliaseName);
        }
        return aliasMap;
    }
}

