/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.writer;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.commons.util.IntBuilder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.transform.tools.DynamicByteBuffer;
import com.geoway.vtile.transform.tools.PropertyUtil;
import com.geoway.vtile.transform.tools.varint.EncodingVarint;
import com.geoway.vtile.transform.writer.Writer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.xerial.snappy.Snappy;

public class VarintWriter
implements Writer {
    protected StringBuilder feature;
    protected Integer accuracy = 1;
    protected DynamicByteBuffer coordinatesBuffer;
    protected IntBuilder offsetIndex;
    protected Map<String, ByteBuffer> layerMap = new LinkedHashMap<String, ByteBuffer>();
    protected Integer offset = 0;
    protected Constants.GEO_TYPE geoType;
    public static byte[] spacingBytes;
    private static byte[] headerArr;
    private static Properties pro;
    private static int precision;
    protected Boolean isNull = false;
    protected Boolean exceed = false;
    public static String featureSpace;
    protected static String encoding;

    public VarintWriter() {
        this.feature = new StringBuilder();
        this.coordinatesBuffer = new DynamicByteBuffer();
        this.offsetIndex = new IntBuilder();
    }

    @Override
    public void beginTile() {
    }

    @Override
    public void endTile() {
    }

    @Override
    public void featureNext() {
    }

    @Override
    public void beginFeature() {
        this.isNull = true;
    }

    @Override
    public void endFeature() {
        if (this.isNull.booleanValue()) {
            return;
        }
        int length = this.coordinatesBuffer.position() - this.offset;
        this.offsetIndex.add(this.offset.intValue());
        this.offsetIndex.add(length);
        this.offset = this.coordinatesBuffer.position();
    }

    @Override
    public void setPropertys(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        this.geoType = geoType;
    }

    @Override
    public void beginPath() {
    }

    @Override
    public void endPath() {
    }

    @Override
    public void addFull(Boolean clockwise) {
    }

    public Object createPropertysPart(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        this.geoType = geoType;
        StringBuilder sb = new StringBuilder();
        this.setPropertys(sb, propertyFields, propertyObject);
        return sb;
    }

    @Override
    public void setPropertysPart(Object part) {
        if (this.isNull.booleanValue()) {
            return;
        }
        this.feature.append(part).append(featureSpace);
    }

    @Override
    public void addCoordinates(DoubleBuilder points, double times) {
        int size = points.size();
        if (size == 0) {
            return;
        }
        this.isNull = false;
        if (this.coordinatesBuffer.position() != this.offset.intValue()) {
            this.coordinatesBuffer.put(spacingBytes);
        }
        int oldX = 0;
        int oldY = 0;
        for (int i = 0; i < size / 2; ++i) {
            int x = (int)(points.get(i * 2) * (double)precision);
            int y = (int)(points.get(i * 2 + 1) * (double)precision);
            this.coordinatesBuffer.put(EncodingVarint.int2Variant(x - oldX));
            this.coordinatesBuffer.put(EncodingVarint.int2Variant(y - oldY));
            oldX = x;
            oldY = y;
        }
    }

    @Override
    public void addCoordinates(double[] points, double times) {
        int size = points.length;
        if (size == 0) {
            return;
        }
        this.isNull = false;
        if (this.coordinatesBuffer.position() != this.offset.intValue()) {
            this.coordinatesBuffer.put(spacingBytes);
        }
        int oldX = 0;
        int oldY = 0;
        for (int i = 0; i < size / 2; ++i) {
            int x = (int)(points[i * 2] * (double)precision);
            int y = (int)(points[i * 2 + 1] * (double)precision);
            this.coordinatesBuffer.put(EncodingVarint.int2Variant(x - oldX));
            this.coordinatesBuffer.put(EncodingVarint.int2Variant(y - oldY));
            oldX = x;
            oldY = y;
        }
    }

    @Override
    public void addCoordinates(double x, double y, double times) {
        this.isNull = false;
        if (this.coordinatesBuffer.position() != this.offset.intValue()) {
            this.coordinatesBuffer.put(spacingBytes);
        }
        int xi = (int)(x * (double)precision);
        int yi = (int)(y * (double)precision);
        this.coordinatesBuffer.put(EncodingVarint.int2Variant(xi));
        this.coordinatesBuffer.put(EncodingVarint.int2Variant(yi));
    }

    protected ByteBuffer getOffsetByte() {
        ByteBuffer buffer = ByteBuffer.allocate(this.offsetIndex.size() * 4);
        for (int i = 0; i < this.offsetIndex.size(); ++i) {
            buffer.put(EncodingVarint.int2Variant(this.offsetIndex.get(i)));
        }
        return buffer;
    }

    public byte[] getData() {
        VarintWriter.headerArr[0] = this.isExceed() ? (byte)1 : 0;
        try {
            ByteBuffer buf;
            if (this.geoType != null) {
                if (this.feature.length() == 0) {
                    return new byte[0];
                }
                this.coordinatesBuffer.flip();
                ByteBuffer offsetIndexBuffer = this.getOffsetByte();
                offsetIndexBuffer.flip();
                byte[] snappyBytes = Snappy.compress((byte[])this.feature.toString().getBytes(encoding));
                int featureLength = snappyBytes.length;
                String headPro = "gType:" + this.geoType.name();
                byte[] headProByte = Snappy.compress((byte[])headPro.getBytes(encoding));
                int indexLength = offsetIndexBuffer.limit();
                int total = 12 + headerArr.length + headProByte.length + snappyBytes.length + offsetIndexBuffer.limit() + this.coordinatesBuffer.limit();
                ByteBuffer layerBuffer = ByteBuffer.allocate(total);
                layerBuffer.put(headerArr);
                layerBuffer.putInt(headProByte.length);
                layerBuffer.put(headProByte);
                layerBuffer.putInt(featureLength);
                layerBuffer.put(snappyBytes);
                layerBuffer.putInt(indexLength);
                layerBuffer.put(offsetIndexBuffer);
                layerBuffer.put(this.coordinatesBuffer.getByteArray());
                layerBuffer.flip();
                return layerBuffer.array();
            }
            if (this.layerMap.isEmpty()) {
                return new byte[0];
            }
            Iterator<String> it = this.layerMap.keySet().iterator();
            ByteBuffer indexBuf = ByteBuffer.allocate(this.layerMap.size() * 240);
            int length = 0;
            while (it.hasNext()) {
                String key = it.next();
                buf = this.layerMap.get(key);
                length = length + buf.limit() + 4 + key.getBytes(encoding).length;
            }
            ByteBuffer dataBuf = ByteBuffer.allocate(length);
            for (String key : this.layerMap.keySet()) {
                buf = this.layerMap.get(key);
                indexBuf.putInt(key.getBytes(encoding).length);
                indexBuf.put(key.getBytes(encoding));
                indexBuf.putInt(buf.limit());
                dataBuf.put(buf);
            }
            indexBuf.flip();
            dataBuf.flip();
            byte[] typeByte = "vector".getBytes(encoding);
            String headPro = "";
            byte[] headProByte = new byte[]{};
            int total = 12 + headerArr.length + typeByte.length + indexBuf.limit() + dataBuf.limit();
            ByteBuffer layerBuffer = ByteBuffer.allocate(total);
            layerBuffer.put(headerArr);
            layerBuffer.putInt(typeByte.length);
            layerBuffer.put(typeByte);
            layerBuffer.putInt(0);
            layerBuffer.putInt(indexBuf.limit());
            layerBuffer.put(indexBuf);
            layerBuffer.put(dataBuf);
            layerBuffer.flip();
            return layerBuffer.array();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Integer getAccuracy() {
        return this.accuracy;
    }

    @Override
    public void setGeoType(Constants.GEO_TYPE geoType) {
        this.geoType = geoType;
    }

    @Override
    public Constants.GEO_TYPE getGeoType() {
        return this.geoType;
    }

    protected void setPropertys(StringBuilder sbproperty, String[] propertyFields, Object[] propertyObject) {
        if (propertyFields == null || propertyFields.length == 0) {
            return;
        }
        Object o = null;
        String value = null;
        for (int i = 0; i < propertyObject.length; ++i) {
            o = propertyObject[i];
            value = o != null ? (o instanceof Date ? ((Date)o).getTime() + "" : o.toString()) : null;
            if (value == null || value.length() == 0) {
                sbproperty.append(featureSpace);
                continue;
            }
            sbproperty.append(featureSpace).append(value);
        }
        sbproperty.delete(0, 2);
    }

    @Override
    public void beginServerTile() {
    }

    @Override
    public void addLayer(String id, byte[] bytes) {
        this.layerMap.put(id, ByteBuffer.wrap(bytes));
    }

    @Override
    public void endServerTile() {
    }

    protected boolean isExceed() {
        return this.exceed;
    }

    @Override
    public void setExceed(boolean exceed) {
        this.exceed = exceed;
    }

    static {
        featureSpace = "#@";
        encoding = "utf-8";
        pro = PropertyUtil.readProperties("conf/varint.properties");
        precision = Integer.valueOf(pro.getProperty("precision"));
        String[] spacingArr = pro.getProperty("spacingArr").split(",");
        spacingBytes = new byte[spacingArr.length];
        for (int i = 0; i < spacingArr.length; ++i) {
            VarintWriter.spacingBytes[i] = Byte.valueOf(spacingArr[i]);
        }
        int headerSize = Integer.valueOf(pro.getProperty("headerSize"));
        headerArr = new byte[headerSize];
        Random random = new Random();
        for (int i = 0; i < headerSize; ++i) {
            VarintWriter.headerArr[i] = Byte.valueOf(random.nextInt(70) + 1 + "");
        }
    }
}

