/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.writer;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.commons.reflect.Bean;
import com.geoway.vtile.transform.enums.TILE_TYPE;
import com.geoway.vtile.transform.enums.TILE_VERSION_ENUM;
import com.geoway.vtile.transform.writer.ConcurrentVarintWriter;
import com.geoway.vtile.transform.writer.JsonWriterVersion1_0;
import com.geoway.vtile.transform.writer.VarintFeatureWriter;
import com.geoway.vtile.transform.writer.VarintWriter;
import com.geoway.vtile.transform.writer.Writer;

public class WriterManager {
    public static Class<? extends Writer> getWriterClass(TILE_TYPE tile_type, TILE_VERSION_ENUM tileVersion, boolean useMultiThread) {
        if (tile_type == TILE_TYPE.feature) {
            return VarintFeatureWriter.class;
        }
        if (GlobalTileSettings.DISABLE_INGRID_MULTITHREAD.booleanValue()) {
            useMultiThread = false;
        }
        if (useMultiThread) {
            return ConcurrentVarintWriter.class;
        }
        return VarintWriter.class;
    }

    public static Writer getWriter(TILE_TYPE tile_type, TILE_VERSION_ENUM tileVersion) {
        switch (tile_type) {
            case vector_tile: {
                if (tileVersion == TILE_VERSION_ENUM.v1_0) {
                    return (Writer)Bean.newInstance(JsonWriterVersion1_0.class);
                }
                if (tileVersion != TILE_VERSION_ENUM.v2_0) break;
                return (Writer)Bean.newInstance(VarintWriter.class);
            }
        }
        return null;
    }
}

