/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell.abstractclass;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.Label;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.resources.datatable.MoreThanOneSpatialField;
import com.geoway.vtile.resources.datatable.SpatialInfo;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayerTileCell {
    Logger logger = LoggerFactory.getLogger(AbstractLayerTileCell.class);
    protected boolean isInit = false;
    protected int down = 0;
    protected Integer mainLevel;
    protected ILayer layer;
    protected LAYER_TYPE isVectorCellOrLabelCell = LAYER_TYPE.layer;
    private boolean cancel = false;

    public QueryFilter buildFilter(IDataSet dataSet, ITable table, String wkt, GridExtent extent, String extraFilter, Integer start, Integer limit) {
        Label label;
        QueryFilter filter = new QueryFilter();
        if (limit != -1) {
            filter.setStart(start);
            filter.setLimit(limit);
        }
        SpatialInfo spatialInfo = null;
        try {
            spatialInfo = table.spatialInfo();
        }
        catch (MoreThanOneSpatialField moreThanOneSpatialField) {
            moreThanOneSpatialField.printStackTrace();
        }
        Integer srid = spatialInfo.getSrid() == null ? 0 : spatialInfo.getSrid();
        filter.setSRID(srid);
        if (dataSet.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.spark) {
            filter.setOutputFieldNames(dataSet.getFieldsArr());
        } else {
            filter.setOutputFieldNames(dataSet.getIdField());
        }
        Constants.OPERATION operation = Constants.OPERATION.MBR_INTERSECTS;
        if (dataSet.getDataSource().getDataSourceType() != Constants.DATA_SOURCE_TYPE.oracle && (dataSet.getGeometryType() == Constants.GEO_TYPE.LINESTRING || dataSet.getGeometryType() == Constants.GEO_TYPE.MULTILINESTRING)) {
            operation = Constants.OPERATION.INTERSECTS;
        }
        if (GlobalTileSettings.bAccurateIntersect) {
            operation = Constants.OPERATION.INTERSECTS;
        }
        if (Log4jUtil.isDiagnoseEnable() && 1 != limit) {
            this.logger.info("\u6784\u5efa\u7a7a\u95f4\u67e5\u8be2\u6761\u4ef6\uff1a\"{}\" {} '{}' ", new Object[]{spatialInfo.getSpatialField(), operation, wkt});
        }
        filter.addFilter(spatialInfo.getSpatialField(), operation, new Object[]{wkt});
        String dataFilterStr = dataSet.getFilter();
        if (StringUtils.isNotEmpty((CharSequence)dataFilterStr)) {
            if (dataFilterStr.startsWith("Q")) {
                filter.addQueryFilterStr(dataFilterStr, 1);
            } else {
                filter.addSQL(dataFilterStr);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)extraFilter)) {
            if (extraFilter.startsWith("Q")) {
                filter.addQueryFilterStr(extraFilter, 1);
            } else {
                if (extraFilter.indexOf("\\\"") != -1) {
                    extraFilter = extraFilter.replaceAll("\\\\\"", "\"");
                }
                filter.addSQL(extraFilter, Constants.RELATION.AND);
            }
        }
        if (this.isVectorCellOrLabelCell == LAYER_TYPE.label && (label = this.layer.getLabel()) != null && StringUtils.isNotBlank((CharSequence)label.getFilter())) {
            if (label.getFilter().startsWith("Q")) {
                filter.addQueryFilterStr(label.getFilter(), 1);
            } else {
                filter.addSQL(label.getFilter(), Constants.RELATION.AND);
            }
        }
        Integer mainLevel = this.mainLevel;
        if (this.mainLevel == null) {
            mainLevel = extent.getLevel();
        }
        this.addExtraLevelFilter(filter, mainLevel);
        String sortStr = dataSet.getSortFiled();
        if (sortStr != null && !"".equalsIgnoreCase(sortStr)) {
            filter.addSorted(sortStr, QueryFilter.SORT.valueOf((String)dataSet.getSort()));
        }
        return filter;
    }

    protected void addExtraLevelFilter(QueryFilter filter, int beginLevel) {
        String filterStr;
        Map levelMap = this.layer.getLevelMap();
        for (int i = beginLevel; i <= beginLevel + this.down; ++i) {
            ILayerLevel layerLevel = (ILayerLevel)levelMap.get(i);
            if (levelMap.get(i) == null || layerLevel.isVirtual().booleanValue() || !StringUtils.isEmpty((CharSequence)(filterStr = layerLevel.getFilterExpression()))) continue;
            return;
        }
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = beginLevel; i <= beginLevel + this.down; ++i) {
            if (levelMap.get(i) == null || "1 = 2".equals(filterStr = ((ILayerLevel)levelMap.get(i)).getFilterExpression())) continue;
            filters.add(filterStr);
        }
        if (!filters.isEmpty()) {
            String filterStr2 = StringUtils.join(filters, (String)" or ");
            filterStr2 = filterStr2.replace("\"", "'");
            filter.addSQL(filterStr2, Constants.RELATION.AND);
        }
    }

    public Integer getMainLevel() {
        return this.mainLevel;
    }

    public void setMainLevel(Integer mainLevel) {
        this.mainLevel = mainLevel;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean isCancel() {
        return this.cancel;
    }
}

