/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.bean;

import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.tools.CTerranArea;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class ExtentGeometry {
    GridExtent extent;
    Geometry geometry;
    double[] center;
    Double area;
    boolean isFull = false;

    public ExtentGeometry(GridExtent extent, Geometry geometry, boolean isFull) {
        this.extent = extent;
        this.geometry = geometry;
        this.isFull = isFull;
    }

    public GridExtent getExtent() {
        return this.extent;
    }

    public void setExtent(GridExtent extent) {
        this.extent = extent;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public void setFull(boolean full) {
        this.isFull = full;
    }

    public double getArea() {
        if (this.area == null) {
            this.area = CTerranArea.CalculateTerranArea(this.geometry);
        }
        return this.area;
    }

    public void setArea(double area) {
        this.area = area;
    }

    public double[] getCenter() {
        if (this.center == null && this.geometry != null) {
            Point interiorPoint = this.geometry.getInteriorPoint();
            this.center = new double[]{interiorPoint.getX(), interiorPoint.getY()};
        }
        return this.center;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }
}

