/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.shovel.label;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.commons.util.DoubleBuilderL;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.dataholder.ExtentDataHolder;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import com.geoway.vtile.transform.dataholder.shovel.AbstractShovel;
import com.geoway.vtile.transform.dataholder.shovel.label.LineNodeInfo;
import com.geoway.vtile.transform.tools.Boxset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractLineLoction
extends AbstractShovel {
    private int base;
    private IGridSystem grid;
    private int baseLevel;
    private double baseUnit;
    private int minCutPoint;
    private int minCutPixel;
    protected HashMap<Integer, Double> baseUnitMap = new HashMap();

    public AbstractLineLoction(IGridSystem grid, int beginLevel, int endLevel, int minCutPixel, int minCutPoint, int base) {
        this.grid = grid;
        this.baseLevel = endLevel;
        this.minCutPixel = minCutPixel;
        this.minCutPoint = minCutPoint;
        this.base = base;
        this.baseUnit = grid.getResolution(endLevel) * (double)this.base;
        for (int i = 0; i <= endLevel - beginLevel; ++i) {
            this.baseUnitMap.put(beginLevel + i, grid.getResolution(beginLevel + i) * (double)base);
        }
    }

    protected void doError() {
        throw new RuntimeException("\u7ebf\u6ce8\u8bb0\u5904\u7406\u7684\u7c7b\u578b\u5fc5\u987b\u662fLINESTRING\u6216\u8005MULTILINESTRING");
    }

    protected void dealWithLine(DoubleBuilder coords, ExtentDataHolderArray gridArray) {
        this.buildLineLabelNode2(coords, gridArray);
    }

    private double getLengthByCoords(DoubleBuilder coords) {
        double[] temp = Boxset.createEmptyDoubleArray();
        double lengthAll = 0.0;
        int length = coords.size();
        for (int i = 0; i < length; i += 2) {
            double x = coords.get(i);
            double y = coords.get(i + 1);
            if (Boxset.isEmpty(temp)) {
                temp[0] = x;
                temp[1] = y;
                continue;
            }
            double lengthPath = AbstractLineLoction.length(temp[0], temp[1], x, y);
            lengthAll += lengthPath;
            temp[0] = x;
            temp[1] = y;
        }
        return lengthAll;
    }

    private void buildLineLabelNode2(DoubleBuilder coords, ExtentDataHolderArray gridArray) {
        gridArray.boxsetReset();
        double lengthAll = this.getLengthByCoords(coords);
        for (ExtentDataHolder extentDataHolder : gridArray.getExtentDataHolderArr()) {
            double resolution;
            double minDistanceForSave;
            if (!gridArray.isSave(extentDataHolder.getL()).booleanValue() || lengthAll <= (minDistanceForSave = (resolution = this.grid.getResolution(extentDataHolder.getL()).doubleValue()) * (double)this.minCutPixel)) continue;
            LineNodeInfo lineNodeInfo = new LineNodeInfo();
            lineNodeInfo.setCoords(coords);
            lineNodeInfo.setLength(lengthAll);
            ArrayList<double[]> points = new ArrayList<double[]>();
            for (int index = 0; index < coords.size() - 1; index += 2) {
                double x = coords.get(index);
                double y = coords.get(index + 1);
                double[] point = new double[]{x, y};
                points.add(point);
            }
            lineNodeInfo.setNodes(points);
            DoubleBuilderL doubleBuilder = new DoubleBuilderL();
            Boxset boxset = new Boxset(extentDataHolder.getExtent(), extentDataHolder.getExtent().getBufferSize());
            List<double[]> nodes = lineNodeInfo.getNodes();
            double[] lastNode = new double[2];
            Boolean lastIn = null;
            for (double[] thisNode : nodes) {
                List<double[]> crossPoints;
                boolean thisIn = boxset.in(thisNode[0], thisNode[1]);
                if (lastIn == null) {
                    if (thisIn) {
                        doubleBuilder.append(thisNode);
                    }
                } else if (lastIn.booleanValue()) {
                    if (thisIn) {
                        doubleBuilder.append(thisNode);
                    } else {
                        crossPoints = boxset.getCrossPoints(lastNode, thisNode);
                        crossPoints.forEach(arg_0 -> ((DoubleBuilder)doubleBuilder).append(arg_0));
                    }
                } else {
                    crossPoints = boxset.getCrossPoints(lastNode, thisNode);
                    crossPoints.forEach(arg_0 -> ((DoubleBuilder)doubleBuilder).append(arg_0));
                    if (thisIn) {
                        doubleBuilder.append(thisNode);
                    }
                }
                if (!thisIn) {
                    this.saveDoubleBuilder(gridArray, extentDataHolder, (DoubleBuilder)doubleBuilder);
                }
                lastIn = thisIn;
                lastNode = thisNode;
            }
            this.saveDoubleBuilder(gridArray, extentDataHolder, (DoubleBuilder)doubleBuilder);
        }
    }

    private void saveDoubleBuilder(ExtentDataHolderArray gridArray, ExtentDataHolder extentDataHolder, DoubleBuilder doubleBuilder) {
        if (doubleBuilder.size() > 0) {
            DoubleBuilderL pixelDoubleBuilder = new DoubleBuilderL();
            for (int i = 0; i < doubleBuilder.size() - 1; i += 2) {
                double[] node = new double[]{doubleBuilder.get(i), doubleBuilder.get(i + 1)};
                this.dealWithXY(extentDataHolder.getExtent(), node);
                pixelDoubleBuilder.append(node);
            }
            gridArray.beginPath();
            extentDataHolder.savePoints((DoubleBuilder)pixelDoubleBuilder, 1.0, null);
            gridArray.endPath();
            doubleBuilder.reset();
        }
    }

    protected void dealWithXY(GridExtent extent, double[] points) {
        double x = points[0];
        double y = points[1];
        double _x = Math.round((x - extent.getLeft()) / extent.getResolution());
        double _y = Math.round((extent.getTop() - y) / extent.getResolution());
        points[0] = _x;
        points[1] = _y;
    }

    private LineNodeInfo buildLinePathNodesInfo(DoubleBuilder coords, double baseUnit) {
        LineNodeInfo lineNodeInfo = new LineNodeInfo();
        double[] tempPoint = Boxset.createEmptyDoubleArray();
        ArrayList<double[]> pointList = new ArrayList<double[]>();
        double lengthAll = 0.0;
        double markLength = baseUnit;
        for (int index = 0; index < coords.size() - 1; index += 2) {
            double x = coords.get(index);
            double y = coords.get(index + 1);
            if (Boxset.isEmpty(tempPoint)) {
                tempPoint[0] = x;
                tempPoint[1] = y;
                pointList.add(new double[]{x, y});
                continue;
            }
            if (index == coords.size() - 2) {
                pointList.add(new double[]{x, y});
                break;
            }
            double tempLength = AbstractLineLoction.length(tempPoint[0], tempPoint[1], x, y);
            lengthAll += tempLength;
            pointList.add(new double[]{x, y});
            markLength = tempLength >= markLength ? baseUnit : (markLength -= tempLength);
            tempPoint[0] = x;
            tempPoint[1] = y;
        }
        lineNodeInfo.setCoords(coords);
        lineNodeInfo.setLength(lengthAll);
        lineNodeInfo.setNodes(pointList);
        return lineNodeInfo;
    }

    public static double length(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        return StrictMath.sqrt(dx * dx + dy * dy);
    }
}

