/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.service.impl;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.LayerBean;
import com.geoway.vtile.spatial.grid.GridManager;
import com.geoway.vtile.spatial.grid.QuadtreeGrid;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.LayerTileCutterCell;
import com.geoway.vtile.transform.cell.ServerTileCutterCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import com.geoway.vtile.transform.service.ITileDataService;
import com.geoway.vtile.transform.tools.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDataService
implements ITileDataService {
    Logger logger = LoggerFactory.getLogger(TileDataService.class);
    protected ExecutorService executorService;
    private boolean bDiagnose = Log4jUtil.isDiagnoseEnable();

    public TileDataService(int threadCount) {
        this.executorService = Executors.newFixedThreadPool(threadCount, new NamedThreadFactory("RealtimeTileThread"));
    }

    @Override
    public byte[] getData(IVectorService service, String layerName, String type, String gridstr, Integer x, Integer y, Integer level, String filter, Boolean _cut, Integer start, Integer limit) throws Exception {
        LAYER_TYPE layerType = LAYER_TYPE.all;
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            layerType = LAYER_TYPE.valueOf(type);
        }
        boolean isProject = null != service.getProjConfig() && service.getProjConfig().isProject;
        QuadtreeGrid grid = GridManager.getQuadtreeGrid((String)gridstr, (int[])service.getOrigin(), (double[])service.getResolutions());
        if (isProject) {
            grid = (QuadtreeGrid)service.getProjectedMeta().getGridTree();
        }
        if (level < grid.getBeginLevel()) {
            return new byte[0];
        }
        GridExtent extent = grid.getGridExtent(level.intValue(), x.intValue(), y.intValue());
        ITileCutterCell<GridExtent, List<Object[]>> serverCell = this.getCell(service, layerName, layerType);
        serverCell.setMainLevel(level);
        serverCell.init();
        TileCutOptions options = new TileCutOptions();
        options.setExtraSqlFilter(filter);
        options.setStart(start);
        options.setLimit(limit);
        options.setLimitMark(true);
        List<Object[]> data = serverCell.cut(extent, options);
        byte[] returnData = data == null || data.isEmpty() ? new byte[]{} : (byte[])data.get(0)[1];
        this.logger.debug("\u8bf7\u6c42\u8fd4\u56de\u5927\u5c0f " + returnData.length);
        return returnData;
    }

    private ITileCutterCell<GridExtent, List<Object[]>> getCell(IVectorService service, String layerName, LAYER_TYPE type) {
        if (StringUtils.isNotEmpty((CharSequence)layerName)) {
            layerName = layerName.replace(LayerBean.LABEL_SUFFIX, "");
            ILayer layer = (ILayer)service.getLayerMap().get(layerName);
            if (layer == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u56fe\u5c42 : " + layerName);
            }
            LayerTileCutterCell layerTileCutterCell = new LayerTileCutterCell(layer, type);
            layerTileCutterCell.setMapService(service);
            return layerTileCutterCell;
        }
        return new ServerTileCutterCell(service, this.executorService, type);
    }
}

