/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.screenextent.impl;

import com.geoway.vtile.commons.util.BuilderCreator;
import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.resources.inmemoryold.IArrayFilter;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.geofeature.GeoPart;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.dataholder.ExtentDataHolder;
import com.geoway.vtile.transform.dataholder.screenextent.ScreenExtent;
import com.geoway.vtile.transform.tools.Boxset;
import com.geoway.vtile.transform.writer.Writer;

public class ConcurrentScreenExtent
implements ScreenExtent {
    protected int l;
    protected int x;
    protected int y;
    protected IArrayFilter arrayFilter;
    protected ExtentDataHolder parent;
    protected ExtentDataHolder[] children;
    protected GridExtent extent;
    protected Writer writer;
    protected ThreadLocal<Boolean> clockwise;
    protected ThreadLocal<DoubleBuilder> processedData;
    protected ThreadLocal<Boolean> isFull;
    protected ThreadLocal<Boolean> cutOutScreen;
    protected ThreadLocal<byte[][]> pixelCheckBuffer;
    ThreadLocal<Boxset> boxsetThreadLocal;
    ThreadLocal<Boolean> isReset;

    public ConcurrentScreenExtent(GridExtent extent, Writer writer, ExtentDataHolder parent) {
        this.extent = extent;
        this.l = extent.getLevel();
        this.x = extent.getX();
        this.y = extent.getY();
        this.writer = writer;
        this.parent = parent;
        this.pixelCheckBuffer = null;
        this.boxsetThreadLocal = new ThreadLocal();
        this.clockwise = new ThreadLocal();
        this.processedData = new ThreadLocal();
        this.isFull = new ThreadLocal();
        this.cutOutScreen = new ThreadLocal();
        this.pixelCheckBuffer = new ThreadLocal();
        this.isReset = new ThreadLocal();
    }

    @Override
    public Boolean getClockwise() {
        return this.clockwise.get();
    }

    @Override
    public Boolean isSave() {
        return true;
    }

    @Override
    public void resetProcessedCache() {
        if (this.processedData != null) {
            this.processedData = null;
        }
    }

    @Override
    public double getSimplify() {
        return 0.0;
    }

    @Override
    public void savePoints(DoubleBuilder points, double times, GeoPart.RING_TYPE ringType) {
        if (points.size() > 2 && ringType != null) {
            boolean isCW;
            double area = this.calculateSignedArea(points);
            boolean bl = isCW = area < 0.0;
            if (isCW) {
                if (ringType == GeoPart.RING_TYPE.outside) {
                    points = GeoBuffer.reverseCoordinates((DoubleBuilder)points, (int)2);
                }
            } else if (ringType == GeoPart.RING_TYPE.inside) {
                points = GeoBuffer.reverseCoordinates((DoubleBuilder)points, (int)2);
            }
        }
        this.writer.addCoordinates(points, times);
    }

    private double calculateSignedArea(DoubleBuilder doubleBuilder) {
        double sum = 0.0;
        int size = doubleBuilder.size() / 2;
        int i = 0;
        int len = size;
        int j = len - 1;
        while (i < len) {
            double px1 = doubleBuilder.get(i * 2);
            double py1 = doubleBuilder.get(i * 2 + 1);
            double px2 = doubleBuilder.get(j * 2);
            double py2 = doubleBuilder.get(j * 2 + 1);
            sum += (px2 - px1) * (py1 + py2);
            j = i++;
        }
        return sum;
    }

    @Override
    public Boolean getCutOutScreen() {
        Boolean cutOutScreen = this.cutOutScreen.get();
        if (cutOutScreen == null) {
            this.setCutOutScreen(true);
            return true;
        }
        return cutOutScreen;
    }

    @Override
    public void setFull() {
        DoubleBuilder doubleBuilder = BuilderCreator.createDouble();
        int base = this.extent.getGrid().getBase();
        if (this.getClockwise().booleanValue()) {
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)base * 1.2);
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)base * 1.2);
            doubleBuilder.append((double)base * 1.2);
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)base * 1.2);
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)(-base) * 0.1);
        } else {
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)base * 1.2);
            doubleBuilder.append((double)base * 1.2);
            doubleBuilder.append((double)base * 1.2);
            doubleBuilder.append((double)base * 1.2);
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)(-base) * 0.1);
            doubleBuilder.append((double)(-base) * 0.1);
        }
        this.savePoints(doubleBuilder, 1.0, GeoPart.RING_TYPE.outside);
    }

    @Override
    public void savePoint(double x, double y, int times) {
        this.writer.beginPath();
        this.writer.addCoordinates(x, y, times);
        this.writer.endPath();
    }

    @Override
    public Integer getAccuracy() {
        return this.writer.getAccuracy();
    }

    @Override
    public void begin() {
        this.writer.beginTile();
    }

    @Override
    public void next() {
        this.writer.featureNext();
    }

    @Override
    public void end() {
        this.writer.endTile();
    }

    @Override
    public void beginFeature() {
        this.writer.beginFeature();
    }

    @Override
    public void endFeature() {
        this.writer.endFeature();
    }

    @Override
    public void featureMunltiGeometryNextPart() {
        this.writer.endPath();
    }

    @Override
    public void setPropertys(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        this.writer.setPropertys(geoType, propertyFields, propertyObject);
    }

    @Override
    public void setPropertysPart(Object part) {
        this.writer.setPropertysPart(part);
    }

    @Override
    public void setChildren(ExtentDataHolder[] childrenArr) {
        this.children = childrenArr;
    }

    @Override
    public <T> T getData() {
        return this.writer.getData();
    }

    @Override
    public Boolean isMainHolder() {
        if (this.parent == null) {
            return true;
        }
        return false;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void beginPath() {
        this.writer.beginPath();
    }

    @Override
    public void endPath() {
        this.writer.endPath();
    }

    @Override
    public void setGeoType(Constants.GEO_TYPE geoType) {
        this.writer.setGeoType(geoType);
    }

    @Override
    public void setExceed(boolean exceed) {
        this.writer.setExceed(exceed);
    }

    @Override
    public void setCutOutScreen(Boolean cutOutScreen) {
        this.cutOutScreen.set(cutOutScreen);
    }

    @Override
    public byte[][] getPixelCheckBuffer() {
        byte[][] pixelCheckBuffer = this.pixelCheckBuffer.get();
        if (pixelCheckBuffer == null) {
            int baseSize = this.extent.getGrid().getBaseTileSize();
            pixelCheckBuffer = new byte[baseSize + 2][baseSize + 2];
            this.pixelCheckBuffer.set(pixelCheckBuffer);
        }
        return pixelCheckBuffer;
    }

    @Override
    public ExtentDataHolder getParent() {
        return this.parent;
    }

    @Override
    public int getL() {
        return this.l;
    }

    @Override
    public int getLevel() {
        return this.l;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public GridExtent getExtent() {
        return this.extent;
    }

    @Override
    public Boxset getBoxset() {
        Boxset boxset = this.boxsetThreadLocal.get();
        if (boxset == null) {
            boxset = new Boxset(this.extent, this.extent.getBufferSize());
            this.boxsetThreadLocal.set(boxset);
        }
        if (this.isReset()) {
            boxset.reset();
        }
        return boxset;
    }

    public boolean isReset() {
        Boolean isReset = this.isReset.get();
        if (isReset == null) {
            return false;
        }
        return isReset;
    }

    @Override
    public void boxsetReset() {
        this.isReset.set(true);
    }

    @Override
    public DoubleBuilder getProcessedCache() {
        return this.processedData.get();
    }

    @Override
    public void setProcessedCache(DoubleBuilder processedData) {
        this.processedData.set(processedData);
    }

    @Override
    public ExtentDataHolder[] getChildren() {
        return this.children;
    }

    @Override
    public void full(Boolean clockwise) {
        this.isFull.set(true);
        this.clockwise.set(clockwise);
    }

    @Override
    public boolean isFull() {
        Boolean isFull = this.isFull.get();
        if (isFull == null) {
            return false;
        }
        return isFull;
    }
}

