/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell;

import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.resources.MongodbDao;
import com.geoway.vtile.spatial.geofeature.GeoFeature;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.bean.FeatureTile;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.abstractclass.AbstractLayerTileCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.dataholder.IMetricsHolder;
import com.geoway.vtile.transform.dataholder.bucket.BucketHolder;
import com.geoway.vtile.transform.dataholder.metrics.ObjectArrayMetricsHolder;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCursor;
import io.protostuff.ProtostuffIOUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaUnionCutterCell
extends AbstractLayerTileCell
implements ITileCutterCell<GridExtent, Object[]> {
    Logger logger = LoggerFactory.getLogger(AreaUnionCutterCell.class);
    MongodbDao mongodbDao;
    boolean hasAreaField = false;

    public AreaUnionCutterCell(ILayer layer, MongodbDao mongodbDao, Integer mainLevel, boolean hasAreaField) {
        this.layer = layer;
        this.mongodbDao = mongodbDao;
        this.mainLevel = mainLevel;
        this.hasAreaField = hasAreaField;
    }

    @Override
    public void init() {
    }

    @Override
    public Object[] cut(GridExtent item, TileCutOptions options) throws Exception {
        if (item.getLevel() != this.mainLevel.intValue()) {
            return this.merge(item);
        }
        return this.calculate(item);
    }

    private Object[] calculate(GridExtent extent) throws IOException {
        String key = extent.getKey();
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"fkey", (Object)key);
        MongoCursor documentMongoCursor = this.mongodbDao.find((Bson)query);
        Document doc = null;
        ArrayList<ObjectArrayMetricsHolder> collect = new ArrayList<ObjectArrayMetricsHolder>();
        while (documentMongoCursor.hasNext()) {
            doc = (Document)documentMongoCursor.next();
            byte[] content = ((Binary)doc.get((Object)"fdata1")).getData();
            if (content == null || content.length == 0) continue;
            FeatureTile featureTile = new FeatureTile(content);
            List<GeoFeature> features = featureTile.getFeatures();
            for (GeoFeature feature : features) {
                Object[] props = feature.getProperty();
                int propLen = props.length;
                int groupFieldsNum = propLen - 2;
                if (this.hasAreaField) {
                    --groupFieldsNum;
                }
                collect.add(new ObjectArrayMetricsHolder(Double.valueOf((String)props[propLen - 1]), ArrayUtils.subarray((Object[])props, (int)0, (int)groupFieldsNum)));
            }
        }
        BucketHolder dataRoot = null;
        if (collect != null && !collect.isEmpty()) {
            dataRoot = BucketHolder.createBucket((IMetricsHolder)collect.get(0));
            int size = collect.size();
            if (size > 1) {
                for (int i = 1; i < size; ++i) {
                    BucketHolder.mergeBuckets(dataRoot, (IMetricsHolder)collect.get(i));
                }
            }
        } else {
            return null;
        }
        return new Object[]{key, dataRoot};
    }

    private Object[] merge(GridExtent extent) {
        GridExtent[] extents = this.getDown(extent, this.mainLevel - extent.getLevel());
        List ids = Arrays.stream(extents).map(item -> item.getKey()).collect(Collectors.toList());
        BasicDBObject query = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        values.addAll(ids);
        query.put((Object)"fkey", (Object)new BasicDBObject("$in", (Object)values));
        MongoCursor documentMongoCursor = this.mongodbDao.find((Bson)query);
        ArrayList<BucketHolder> tileBuckets = new ArrayList<BucketHolder>();
        Document doc = null;
        while (documentMongoCursor.hasNext()) {
            doc = (Document)documentMongoCursor.next();
            byte[] content = ((Binary)doc.get((Object)"fstatis")).getData();
            BucketHolder holder = (BucketHolder)BucketHolder.schema.newMessage();
            ProtostuffIOUtil.mergeFrom((byte[])content, (Object)holder, BucketHolder.schema);
            tileBuckets.add(holder);
        }
        if (tileBuckets.isEmpty()) {
            return null;
        }
        BucketHolder tileRoot = BucketHolder.mergeBucketsList(tileBuckets);
        return new Object[]{extent.getKey(), tileRoot};
    }

    private GridExtent[] getDown(GridExtent extent, int downLevel) {
        if (downLevel <= 0) {
            return new GridExtent[]{extent};
        }
        LinkedList<GridExtent> list = new LinkedList<GridExtent>();
        int endLevel = extent.getLevel() + downLevel;
        this.buildDownArray(extent, list, endLevel);
        return list.toArray(new GridExtent[list.size()]);
    }

    private void buildDownArray(GridExtent extent, LinkedList<GridExtent> list, int endLevel) {
        int x = extent.getX();
        int y = extent.getY();
        int l = extent.getLevel() + 1;
        GridExtent extent0 = extent.getGrid().getGridExtent(l, x * 2, y * 2);
        if (extent0.getLevel() < endLevel) {
            this.buildDownArray(extent0, list, endLevel);
        } else {
            list.push(extent0);
        }
        GridExtent extent1 = extent.getGrid().getGridExtent(l, x * 2 + 1, y * 2);
        if (extent1.getLevel() < endLevel) {
            this.buildDownArray(extent1, list, endLevel);
        } else {
            list.push(extent1);
        }
        GridExtent extent2 = extent.getGrid().getGridExtent(l, x * 2, y * 2 + 1);
        if (extent2.getLevel() < endLevel) {
            this.buildDownArray(extent2, list, endLevel);
        } else {
            list.push(extent2);
        }
        GridExtent extent3 = extent.getGrid().getGridExtent(l, x * 2 + 1, y * 2 + 1);
        if (extent3.getLevel() < endLevel) {
            this.buildDownArray(extent3, list, endLevel);
        } else {
            list.push(extent3);
        }
    }
}

