/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools.varint;

import com.geoway.vtile.transform.tools.varint.ZigZagUtil;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class DecodingVarint {
    public static int Byte2Int(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static int[] VariantStream2IntArray(ByteArrayOutputStream out) throws Exception {
        byte[] bytes = out.toByteArray();
        out.close();
        return DecodingVarint.Varint2IntArray(bytes);
    }

    public static int[] Varint2IntArray(byte[] data) {
        ByteBuffer bf = ByteBuffer.allocate(5);
        ByteBuffer intBuffer = ByteBuffer.allocate(data.length * 4);
        for (byte b : data) {
            byte t = (byte)(b >> 7);
            if (t == 0 && bf.position() > 0) {
                intBuffer.put(DecodingVarint.VariantByte2Int(bf));
                bf.clear();
            }
            bf.put(b);
        }
        intBuffer.put(DecodingVarint.VariantByte2Int(bf));
        intBuffer.flip();
        int[] intarray = new int[intBuffer.limit() / 4];
        intarray[0] = ZigZagUtil.decoding(intBuffer.getInt(0));
        for (int i = 1; i < intarray.length; ++i) {
            intarray[i] = intarray[0] + ZigZagUtil.decoding(intBuffer.getInt(i * 4));
        }
        return intarray;
    }

    public static byte[] VariantByte2Int(ByteBuffer bf) {
        bf.flip();
        byte[] t = new byte[]{0, 0, 0, 0};
        int j = t.length - 1;
        int offset = 0;
        byte high = 0;
        for (int i = bf.limit() - 1; i >= 0; --i) {
            high = i - 1 >= 0 ? (byte)(bf.get(i - 1) << 7 - offset) : (byte)0;
            if (j == -1) break;
            t[j] = (byte)((bf.get(i) & 0x7F) >> offset | high);
            --j;
            ++offset;
        }
        return t;
    }

    public static byte[] VariantByte2Int(byte[] data) {
        byte[] t = new byte[]{0, 0, 0, 0};
        int j = t.length - 1;
        int offset = 0;
        byte high = 0;
        for (int i = data.length - 1; i >= 0; --i) {
            high = i - 1 >= 0 ? (byte)(data[i - 1] << 7 - offset) : (byte)0;
            if (j == -1) break;
            t[j] = (byte)((data[i] & 0x7F) >> offset | high);
            --j;
            ++offset;
        }
        return t;
    }

    public static double bytes2Double(byte[] arr) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)(arr[i] & 0xFF) << 8 * i;
        }
        return Double.longBitsToDouble(value);
    }

    public static int varintToInt(byte[] data) {
        return ZigZagUtil.decoding(DecodingVarint.Byte2Int(DecodingVarint.VariantByte2Int(data)));
    }
}

