/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.data_service.DataServiceAdvancedOptions;
import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.ScreenLoction;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.abstractclass.AbstractLayerTileCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.cell.process.CutTileLabelProcesser;
import com.geoway.vtile.transform.cell.process.ProcessList;
import com.geoway.vtile.transform.dataholder.ExtentDataHolder;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import com.geoway.vtile.transform.dataholder.screenextent.impl.ScreenExtentArray;
import com.geoway.vtile.transform.dataholder.shovel.ScreenLoctionManager;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import com.geoway.vtile.transform.enums.TILE_TYPE;
import com.geoway.vtile.transform.enums.TILE_VERSION_ENUM;
import com.geoway.vtile.transform.writer.Writer;
import com.geoway.vtile.transform.writer.WriterManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerLabelTileCutterCell
extends AbstractLayerTileCell
implements ITileCutterCell<GridExtent, Map<LAYER_TYPE, List<Object[]>>> {
    public static final long TILE_FEATURE_COUNT_TOOMUCH = 5000000L;
    protected TILE_TYPE tileType = TILE_TYPE.vector_tile;
    protected TILE_VERSION_ENUM tileVersion = TILE_VERSION_ENUM.v2_0;
    protected ITable table;
    Logger logger = LoggerFactory.getLogger(LayerLabelTileCutterCell.class);
    protected long MAX_SINGLE_THREAD_SIZE = 100000L;

    public LayerLabelTileCutterCell(ILayer layer, LAYER_TYPE isVectorCellOrLabelCell) {
        this.layer = layer;
        this.isVectorCellOrLabelCell = isVectorCellOrLabelCell;
    }

    public LayerLabelTileCutterCell(ILayer layer, LAYER_TYPE isVectorCellOrLabelCell, TILE_VERSION_ENUM tileVersion, TILE_TYPE tileType) {
        this.layer = layer;
        this.isVectorCellOrLabelCell = isVectorCellOrLabelCell;
        this.tileVersion = tileVersion;
        this.tileType = tileType;
    }

    @Override
    public void init() {
    }

    @Override
    public Map<LAYER_TYPE, List<Object[]>> cut(GridExtent extent, TileCutOptions options) throws Exception {
        return this.cut(extent, options.getExtraSqlFilter(), options.getStart(), options.getLimit(), options.getLimitMark());
    }

    private Map<LAYER_TYPE, List<Object[]>> cut(GridExtent extent, String extraSqlFilter, int start, int limit, Boolean limitMark) throws Exception {
        ILayerLevel subLevel;
        Integer level;
        GridExtent subextent;
        Object res;
        List iList;
        int hitCount;
        if (!this.layer.isHaveLabel() && this.isVectorCellOrLabelCell == LAYER_TYPE.label) {
            return null;
        }
        if (this.isCancel()) {
            return null;
        }
        this.logger.debug("\u56fe\u5c42" + this.layer.getId() + " \u7f51\u683c " + extent.toString() + " \u8fc7\u6ee4sql " + extraSqlFilter);
        Integer extentLevel = extent.getLevel();
        ILayerLevel layerLevel = (ILayerLevel)this.layer.getLevelMap().get(extentLevel);
        int currentLevel = extentLevel;
        int endLevel = currentLevel + this.down;
        while (layerLevel == null && currentLevel <= endLevel) {
            layerLevel = (ILayerLevel)this.layer.getLevelMap().get(++currentLevel);
        }
        if (layerLevel == null) {
            return null;
        }
        DataServiceAdvancedOptions advancedOptions = ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions();
        int bufferSize = advancedOptions.getBufferSize();
        extent.setBufferSize(Integer.valueOf(bufferSize));
        String wkt = extent.getExtentByBuffer(bufferSize).getWkt();
        IDataSet dbDataSet = layerLevel.getDataSet();
        ITable table = dbDataSet.getDataService().getTable();
        ScreenLoction screenLoction = ScreenLoctionManager.getScreenLoction(this.layer, LAYER_TYPE.layer, table.spatialInfo().getGeometryType(), extent, this.down);
        ScreenLoction screenLocationLabel = ScreenLoctionManager.getScreenLoction(this.layer, LAYER_TYPE.label, table.spatialInfo().getGeometryType(), extent, this.down);
        if (StringUtils.isNotEmpty((CharSequence)extraSqlFilter)) {
            extraSqlFilter = extraSqlFilter.replace("\"", "'");
        }
        QueryFilter filter = this.buildFilter(dbDataSet, table, wkt, extent, extraSqlFilter, start, limit);
        long queryStart = 0L;
        if (Log4jUtil.isDiagnoseEnable()) {
            queryStart = System.currentTimeMillis();
            this.logger.info(Log4jUtil.MARKER_DIAG, "\u7f51\u683c {}({}_{}_{}) \u7a7a\u95f4\u67e5\u8be2\u5f00\u59cb", new Object[]{this.layer.getId(), extent.getX(), extent.getY(), extent.getLevel()});
        }
        int n = hitCount = null != (iList = table.mapDao().queryArray(filter, Integer.valueOf(1000))) ? iList.size() : 0;
        if (Log4jUtil.isDiagnoseEnable()) {
            double querySeconds = (double)(System.currentTimeMillis() - queryStart) * 1.0 / 1000.0;
            this.logger.info(Log4jUtil.MARKER_DIAG, "\u7f51\u683c {}({}_{}_{}) \u67e5\u8be2\u7ed3\u675f, count: {}, \u8017\u65f6: {} s", new Object[]{this.layer.getId(), extent.getX(), extent.getY(), extent.getLevel(), hitCount, String.format("%.3f", querySeconds)});
        }
        if ((long)hitCount >= 5000000L) {
            this.logger.warn("\u3010\u6027\u80fd\u8b66\u544a\u3011\uff1a\u5f53\u524d\u7f51\u683c {}({}_{}_{}) \u6570\u636e\u91cf\u592a\u5927: {}\uff0c\u8bf7\u4f18\u5316\u914d\u56fe\u548c\u74e6\u7247\u9884\u70ed\u7ea7\u522b!", new Object[]{this.layer.getId(), extent.getX(), extent.getY(), extent.getLevel(), hitCount});
        }
        if (0 == hitCount) {
            if (Log4jUtil.isDiagnoseEnable()) {
                this.logger.info(Log4jUtil.MARKER_DIAG, "\u7f51\u683c {}({}_{}_{}) \u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u65e0\u9700\u5904\u7406", new Object[]{this.layer.getId(), extent.getX(), extent.getY(), extent.getLevel()});
            }
            return null;
        }
        Boolean isExceed = false;
        if (limitMark.booleanValue() && limit == iList.size()) {
            isExceed = true;
        }
        boolean isUseMultiThread = (long)iList.size() > this.MAX_SINGLE_THREAD_SIZE;
        Class<? extends Writer> layerWriterClass = WriterManager.getWriterClass(this.tileType, this.tileVersion, isUseMultiThread);
        Class<? extends Writer> labelWriterClass = WriterManager.getWriterClass(this.tileType, this.tileVersion, isUseMultiThread);
        ScreenExtentArray extentDataHolderArray = new ScreenExtentArray(extent, this.down, layerWriterClass);
        ScreenExtentArray extentLabelDataHolderArray = new ScreenExtentArray(extent, this.down, labelWriterClass);
        this.filterExtentByLevel(extentDataHolderArray, extentLevel, layerLevel.getLevel());
        this.filterExtentByLevel(extentLabelDataHolderArray, extentLevel, layerLevel.getLevel());
        extentDataHolderArray.begin();
        extentLabelDataHolderArray.begin();
        ProcessList process = new ProcessList(isUseMultiThread);
        CutTileLabelProcesser cutTileProcesser = new CutTileLabelProcesser(this, this.layer, extentDataHolderArray, extentLabelDataHolderArray, screenLoction, screenLocationLabel);
        process.init(table, cutTileProcesser);
        Iterator localIterator = iList.iterator();
        while (localIterator.hasNext()) {
            if (this.isCancel()) {
                return null;
            }
            Object id = ((Object[])localIterator.next())[0];
            process.push(id);
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            this.logger.info("\u7f51\u683c {}_{}_{} \u5f00\u59cb\u5904\u7406\u6570\u636e", new Object[]{extent.getX(), extent.getY(), extent.getLevel()});
            queryStart = System.currentTimeMillis();
        }
        process.end();
        if (Log4jUtil.isDiagnoseEnable()) {
            double costSeconds = (double)(System.currentTimeMillis() - queryStart) * 1.0 / 1000.0;
            this.logger.info("\u7f51\u683c {}_{}_{} \u74e6\u7247\u9884\u70ed\u7ed3\u675f\uff0c\u8017\u65f6: {} s", new Object[]{extent.getX(), extent.getY(), extent.getLevel(), String.format("%.3f", costSeconds)});
        }
        process.waitEnd();
        extentDataHolderArray.end();
        extentLabelDataHolderArray.end();
        ExtentDataHolder[] extentDataHolders = extentDataHolderArray.getExtentDataHolderArr();
        ExtentDataHolder[] extentLabelDataHolders = extentLabelDataHolderArray.getExtentDataHolderArr();
        LinkedHashMap<LAYER_TYPE, List<Object[]>> gridMap = new LinkedHashMap<LAYER_TYPE, List<Object[]>>();
        ArrayList<Object[]> gridList = new ArrayList<Object[]>();
        ArrayList<Object[]> labelGridList = new ArrayList<Object[]>();
        for (ExtentDataHolder extentDataHolder : extentDataHolders) {
            extentDataHolder.setExceed(isExceed);
            res = extentDataHolder.getData();
            subextent = extentDataHolder.getExtent();
            level = subextent.getLevel();
            subLevel = (ILayerLevel)this.layer.getLevelMap().get(level);
            if (subLevel != null && subLevel.isVirtual().booleanValue() || res == null || ((byte[])res).length == 0) continue;
            gridList.add(new Object[]{subextent, res, isExceed});
        }
        gridMap.put(LAYER_TYPE.layer, gridList);
        for (ExtentDataHolder extentLabelDataHolder : extentLabelDataHolders) {
            extentLabelDataHolder.setExceed(isExceed);
            res = extentLabelDataHolder.getData();
            subextent = extentLabelDataHolder.getExtent();
            level = subextent.getLevel();
            subLevel = (ILayerLevel)this.layer.getLevelMap().get(level);
            if (subLevel != null && subLevel.isVirtual().booleanValue() || res == null || ((byte[])res).length == 0) continue;
            labelGridList.add(new Object[]{subextent, res, isExceed});
        }
        gridMap.put(LAYER_TYPE.label, labelGridList);
        return gridMap;
    }

    void filterExtentByLevel(ExtentDataHolderArray extentDataHolderArray, int mainLevel, int beginLevel) {
        int currentLevel;
        if (mainLevel >= beginLevel) {
            return;
        }
        ExtentDataHolder mainHolder = extentDataHolderArray.getMainHolder();
        ArrayList<Object> all = new ArrayList<Object>();
        all.add(mainHolder);
        List<Object> children = mainHolder.getChildren() == null ? new ArrayList() : Arrays.asList(mainHolder.getChildren());
        for (currentLevel = mainLevel + 1; currentLevel < beginLevel; ++currentLevel) {
            ArrayList newChildren = new ArrayList();
            children.forEach(child -> newChildren.addAll(Arrays.asList(child.getChildren())));
            children = newChildren;
        }
        mainHolder.setChildren((ExtentDataHolder[])children.stream().toArray(ExtentDataHolder[]::new));
        int endLevel = mainLevel + this.down;
        while (currentLevel < endLevel) {
            all.addAll(children);
            ArrayList newChildren = new ArrayList();
            children.forEach(child -> newChildren.addAll(Arrays.asList(child.getChildren())));
            children = newChildren;
            ++currentLevel;
        }
        all.addAll(children);
        extentDataHolderArray.setExtentDataHolderArr((ExtentDataHolder[])all.stream().toArray(ExtentDataHolder[]::new));
    }

    public String toLog() {
        return null;
    }

    @Override
    public void setDown(int down) {
        this.down = down;
    }

    @Override
    public Integer getDown() {
        return this.down;
    }
}

