/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell.process;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.data_service.DataServiceAdvancedOptions;
import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.ScreenLoction;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.process.AbstractProcesser;
import com.geoway.vtile.transform.cell.process.IProcesser;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutTileLabelProcesser
extends AbstractProcesser<GeoBuffer>
implements IProcesser<GeoBuffer> {
    private static Logger logger = LoggerFactory.getLogger(CutTileLabelProcesser.class);
    ExtentDataHolderArray extentDataHolderArray;
    ExtentDataHolderArray extentLabelDataHolderArray;
    ScreenLoction screenLoction;
    ScreenLoction screenLocationLabel;
    private final Map<Integer, ILayerLevel> layerLevelMap;

    public CutTileLabelProcesser(ITileCutterCell cell, ILayer layer, ExtentDataHolderArray dataHolderArray, ExtentDataHolderArray extentLabelDataHolderArray, ScreenLoction screenLoction, ScreenLoction screenLocationLabel) {
        super(cell, layer);
        this.extentDataHolderArray = dataHolderArray;
        this.extentLabelDataHolderArray = extentLabelDataHolderArray;
        this.screenLoction = screenLoction;
        this.screenLocationLabel = screenLocationLabel;
        this.layerLevelMap = layer.getLevelMap();
    }

    @Override
    public void process(List<Object[]> dataArr, String[] propertyFields, int idIndex, int spatialIndex) {
        double costSeconds;
        propertyFields = (String[])ArrayUtils.remove((Object[])propertyFields, (int)spatialIndex);
        long queryStart = 0L;
        GridExtent extent = this.extentDataHolderArray.getMainGridExtent();
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u7f51\u683c {}({}_{}_{}) \u5f00\u59cb\u5904\u7406layer\u74e6\u7247, \u672c\u6279\u6b21\u6570\u91cf : {}", new Object[]{this.layer.getId(), extent.getX(), extent.getY(), extent.getLevel(), dataArr.size()});
            queryStart = System.currentTimeMillis();
        }
        this.processLayer(dataArr, propertyFields, idIndex, spatialIndex);
        if (Log4jUtil.isDiagnoseEnable()) {
            costSeconds = (double)(System.currentTimeMillis() - queryStart) * 1.0 / 1000.0;
            logger.info("\u7f51\u683c {}({}_{}_{}) \u5904\u7406layer\u74e6\u7247\u7ed3\u675f\uff0c\u8017\u65f6: {} s", new Object[]{this.layer.getId(), extent.getX(), extent.getY(), extent.getLevel(), String.format("%.3f", costSeconds)});
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u7f51\u683c {}({}_{}_{}) \u5f00\u59cb\u5904\u7406\u6ce8\u8bb0\u74e6\u7247, \u672c\u6279\u6b21\u6570\u91cf : {}", new Object[]{this.layer.getId(), extent.getX(), extent.getY(), extent.getLevel(), dataArr.size()});
            queryStart = System.currentTimeMillis();
        }
        this.processLabel(dataArr, propertyFields, idIndex, spatialIndex);
        if (Log4jUtil.isDiagnoseEnable()) {
            costSeconds = (double)(System.currentTimeMillis() - queryStart) * 1.0 / 1000.0;
            logger.info("\u7f51\u683c {}({}_{}_{}) \u5904\u7406\u6ce8\u8bb0\u74e6\u7247\u7ed3\u675f\uff0c\u8017\u65f6: {} s", new Object[]{this.layer.getId(), extent.getX(), extent.getY(), extent.getLevel(), String.format("%.3f", costSeconds)});
        }
    }

    private void processLayer(List<Object[]> dataArr, String[] propertyFields, int idIndex, int spatialIndex) {
        for (Object[] data : dataArr) {
            if (this.cell.isCancel()) {
                return;
            }
            GeoBuffer geo = ((Geom)data[spatialIndex]).toGeoBuffer();
            data = ArrayUtils.remove((Object[])data, (int)spatialIndex);
            Map<Integer, Boolean> saveMap = this.createSaveMap(propertyFields, data);
            Map<Integer, Double> simplifyMap = this.createSimplifyMap();
            Map<Integer, Boolean> ignoreOnePointFeatureMap = this.createIgnoreOnePointFeatureMap();
            this.extentDataHolderArray.setSaveMap(saveMap);
            this.extentDataHolderArray.setSimplifyMap(simplifyMap);
            this.extentDataHolderArray.setIgnoreOnePointFeatureMap(ignoreOnePointFeatureMap);
            if (!this.layer.getCutOutScreen().booleanValue()) {
                this.extentDataHolderArray.setCutOutScreen(false);
            }
            try {
                this.screenLoction.toScreenLoction(geo, this.extentDataHolderArray, propertyFields, data, idIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("id:" + data[idIndex] + ";\u51fa\u73b0\u9519\u8bef");
                throw e;
            }
            this.extentDataHolderArray.next();
        }
    }

    private void processLabel(List<Object[]> dataArr, String[] propertyFields, int idIndex, int spatialIndex) {
        for (Object[] data : dataArr) {
            if (this.cell.isCancel()) {
                return;
            }
            GeoBuffer geo = ((Geom)data[spatialIndex]).toGeoBuffer();
            data = ArrayUtils.remove((Object[])data, (int)spatialIndex);
            Map<Integer, Boolean> saveMap = this.createSaveMap(propertyFields, data);
            Map<Integer, Double> simplifyMap = this.createSimplifyMap();
            Map<Integer, Boolean> ignoreOnePointFeatureMap = this.createIgnoreOnePointFeatureMap();
            this.extentLabelDataHolderArray.setSaveMap(saveMap);
            this.extentLabelDataHolderArray.setSimplifyMap(simplifyMap);
            this.extentLabelDataHolderArray.setIgnoreOnePointFeatureMap(ignoreOnePointFeatureMap);
            if (!this.layer.getCutOutScreen().booleanValue()) {
                this.extentLabelDataHolderArray.setCutOutScreen(false);
            }
            try {
                this.screenLocationLabel.toScreenLoction(geo, this.extentLabelDataHolderArray, propertyFields, data, idIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("id:" + data[idIndex] + ";\u51fa\u73b0\u9519\u8bef");
                throw e;
            }
            this.extentLabelDataHolderArray.next();
        }
    }

    private Map<Integer, Boolean> createSaveMap(String[] fieleNames, Object[] data) {
        HashMap<Integer, Boolean> saveMap = new HashMap<Integer, Boolean>();
        int beginLevel = this.extentDataHolderArray.getMainHolder().getLevel();
        int endLevel = beginLevel + this.cell.getDown();
        ILayerLevel layerLevel = null;
        for (int i = beginLevel; i <= endLevel; ++i) {
            Boolean save;
            layerLevel = this.layerLevelMap.get(i);
            if (layerLevel == null) {
                saveMap.put(i, false);
                continue;
            }
            try {
                save = layerLevel.isFeatureSave(fieleNames, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            saveMap.put(i, save);
        }
        return saveMap;
    }

    private Map<Integer, Double> createSimplifyMap() {
        HashMap<Integer, Double> simplifyMap = new HashMap<Integer, Double>();
        int beginLevel = this.extentDataHolderArray.getMainHolder().getLevel();
        int endLevel = beginLevel + this.cell.getDown();
        ILayerLevel layerLevel = null;
        for (int i = beginLevel; i <= endLevel; ++i) {
            layerLevel = this.layerLevelMap.get(i);
            if (layerLevel == null) continue;
            DataServiceAdvancedOptions advancedOptions = ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions();
            simplifyMap.put(i, advancedOptions.getSimplify());
        }
        return simplifyMap;
    }

    private Map<Integer, Boolean> createIgnoreOnePointFeatureMap() {
        HashMap<Integer, Boolean> ignoreOnePointFeatureMap = new HashMap<Integer, Boolean>();
        int beginLevel = this.extentDataHolderArray.getMainHolder().getLevel();
        int endLevel = beginLevel + this.cell.getDown();
        ILayerLevel layerLevel = null;
        for (int i = beginLevel; i <= endLevel; ++i) {
            layerLevel = this.layerLevelMap.get(i);
            if (layerLevel == null) continue;
            DataServiceAdvancedOptions advancedOptions = ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions();
            ignoreOnePointFeatureMap.put(i, advancedOptions.isIgnoreOnePointFeature());
        }
        return ignoreOnePointFeatureMap;
    }
}

